/************************************************************************************************/
/* Stata User File for H121 Data                                                                 */
/*                                                                                              */
/* This file contains information and a sample Stata program to create a permanent              */
/* Stata dataset for users who want to use Stata in processing the MEPS data provided           */
/* in this PUF release.  Stata (StataCorp) has the capability to produce                        */
/* appropriate standard errors for estimates from a survey with a complex sample                */
/* design such as the Medical Expenditure Panel Survey (MEPS).                                  */
/* The input file for creating a permanent Stata dataset is the ASCII data file                 */
/* (H121.DAT) supplied in this PUF release, which in turn can be extracted from the              */
/* .EXE file. After entering the Stata interactive environment access the Stata DO-File         */
/* editor by clicking on the appropriate icon in the command line at the top of the             */
/* screen.  Copy and paste the following Stata commands into the editor and save as a           */
/* DO file.  A DO file is a Stata program which may then be executed using the DO command.      */
/* For example, if the DO file is named H121.DO and is located in the directory                  */
/* C:\MEPS\PROG, then the file may be executed by typing the following command into             */
/* the Stata command line:                                                                      */
/*                         do C:\MEPS\PROG\H121.DO                                               */
/* The program below will output the Stata dataset H121.DTA                                      */
/************************************************************************************************/


#delimit ;
cd $datadir/MEPS/dat/fullyearconsolidated;
clear;

* INPUT ALL VARIABLES;
infix
  long   DUID 1-5
  int    PID 6-8
  str    DUPERSID 9-16
  byte   PANEL 17-18
  str    FAMID31 19-20
  str    FAMID42 21-22
  str    FAMID53 23-24
  str    FAMID08 25-26
  str    FAMIDYR 27-28
  str    RULETR31 29-30
  str    RULETR42 31-32
  str    RULETR53 33-34
  str    RULETR08 35-36
  byte   RUSIZE31 37-38
  byte   RUSIZE42 39-40
  byte   RUSIZE53 41-42
  byte   RUSIZE08 43-44
  byte   RUCLAS31 45-46
  byte   RUCLAS42 47-48
  byte   RUCLAS53 49-50
  byte   RUCLAS08 51-51
  byte   FAMSZE31 52-53
  byte   FAMSZE42 54-55
  byte   FAMSZE53 56-57
  byte   FAMSZE08 58-59
  byte   FMRS1231 60-61
  byte   FAMS1231 62-63
  byte   FAMSZEYR 64-65
  byte   FAMRFPYR 66-66
  byte   REGION31 67-68
  byte   REGION42 69-70
  byte   REGION53 71-72
  byte   REGION08 73-74
  byte   MSA31 75-76
  byte   MSA42 77-78
  byte   MSA53 79-80
  byte   MSA08 81-82
  int    REFPRS31 83-85
  int    REFPRS42 86-88
  int    REFPRS53 89-91
  int    REFPRS08 92-94
  byte   RESP31 95-95
  byte   RESP42 96-96
  byte   RESP53 97-97
  byte   RESP08 98-98
  byte   PROXY31 99-100
  byte   PROXY42 101-102
  byte   PROXY53 103-104
  byte   PROXY08 105-105
  byte   INTVLANG 106-107
  byte   BEGRFD31 108-109
  byte   BEGRFM31 110-111
  int    BEGRFY31 112-115
  byte   ENDRFD31 116-117
  byte   ENDRFM31 118-119
  int    ENDRFY31 120-123
  byte   BEGRFD42 124-125
  byte   BEGRFM42 126-127
  int    BEGRFY42 128-131
  byte   ENDRFD42 132-133
  byte   ENDRFM42 134-135
  int    ENDRFY42 136-139
  byte   BEGRFD53 140-141
  byte   BEGRFM53 142-143
  int    BEGRFY53 144-147
  byte   ENDRFD53 148-149
  byte   ENDRFM53 150-151
  int    ENDRFY53 152-155
  byte   ENDRFD08 156-157
  byte   ENDRFM08 158-159
  int    ENDRFY08 160-163
  byte   KEYNESS 164-164
  byte   INSCOP31 165-165
  byte   INSCOP42 166-166
  byte   INSCOP53 167-167
  byte   INSCOP08 168-168
  byte   INSC1231 169-169
  byte   INSCOPE 170-170
  byte   ELGRND31 171-171
  byte   ELGRND42 172-172
  byte   ELGRND53 173-173
  byte   ELGRND08 174-174
  byte   PSTATS31 175-176
  byte   PSTATS42 177-178
  byte   PSTATS53 179-180
  str    RURSLT31 181-182
  str    RURSLT42 183-184
  str    RURSLT53 185-186
  byte   AGE31X 187-188
  byte   AGE42X 189-190
  byte   AGE53X 191-192
  byte   AGE08X 193-194
  byte   AGELAST 195-196
  str    CPSFAMID 197-198
  str    HIEUIDX 199-205
  byte   FCSZ1231 206-207
  byte   FCRP1231 208-209
  byte   DOBMM 210-211
  int    DOBYY 212-215
  byte   SEX 216-216
  byte   RACEX 217-217
  byte   RACEAX 218-218
  byte   RACEBX 219-219
  byte   RACEWX 220-220
  byte   RACETHNX 221-221
  byte   HISPANX 222-222
  byte   HISPCAT 223-224
  byte   MARRY31X 225-226
  byte   MARRY42X 227-228
  byte   MARRY53X 229-230
  byte   MARRY08X 231-232
  int    SPOUID31 233-235
  int    SPOUID42 236-238
  int    SPOUID53 239-241
  int    SPOUID08 242-244
  byte   SPOUIN31 245-246
  byte   SPOUIN42 247-248
  byte   SPOUIN53 249-250
  byte   SPOUIN08 251-252
  byte   EDUCYR 253-254
  byte   HIDEG 255-256
  byte   FTSTU31X 257-258
  byte   FTSTU42X 259-260
  byte   FTSTU53X 261-262
  byte   FTSTU08X 263-264
  byte   ACTDTY31 265-266
  byte   ACTDTY42 267-268
  byte   ACTDTY53 269-270
  byte   HONRDC31 271-272
  byte   HONRDC42 273-274
  byte   HONRDC53 275-276
  byte   RFREL31X 277-278
  byte   RFREL42X 279-280
  byte   RFREL53X 281-282
  byte   RFREL08X 283-284
  int    MOPID31X 285-287
  int    MOPID42X 288-290
  int    MOPID53X 291-293
  int    DAPID31X 294-296
  int    DAPID42X 297-299
  int    DAPID53X 300-302
  byte   SSIDIS08 303-304
  byte   AFDC08 305-306
  byte   FILEDR08 307-308
  byte   WILFIL08 309-310
  byte   FLSTAT08 311-312
  byte   FILER08 313-314
  byte   JTINRU08 315-316
  int    JNTPID08 317-319
  byte   CLMDEP08 320-321
  byte   DEPDNT08 322-323
  byte   DPINRU08 324-325
  byte   DPOTSD08 326-327
  byte   TAXFRM08 328-329
  byte   DEDUCT08 330-331
  double TOTDED08 332-340
  byte   CLMHIP08 341-342
  byte   EICRDT08 343-344
  byte   FOODST08 345-346
  byte   FOODMN08 347-348
  double FOODVL08 349-355
  long   TTLP08X 356-362
  long   FAMINC08 363-369
  byte   POVCAT08 370-370
  double POVLEV08 371-381
  long   WAGEP08X 382-387
  byte   WAGIMP08 388-388
  long   BUSNP08X 389-395
  byte   BUSIMP08 396-396
  int    UNEMP08X 397-400
  byte   UNEIMP08 401-401
  long   WCMPP08X 402-406
  byte   WCPIMP08 407-407
  long   INTRP08X 408-412
  byte   INTIMP08 413-413
  long   DIVDP08X 414-418
  byte   DIVIMP08 419-419
  long   SALEP08X 420-426
  byte   SALIMP08 427-427
  long   PENSP08X 428-432
  byte   PENIMP08 433-433
  long   SSECP08X 434-438
  byte   SSCIMP08 439-439
  long   TRSTP08X 440-445
  byte   TRTIMP08 446-446
  long   VETSP08X 447-451
  byte   VETIMP08 452-452
  long   IRASP08X 453-457
  byte   IRAIMP08 458-458
  long   REFDP08X 459-463
  byte   REFIMP08 464-464
  long   ALIMP08X 465-469
  byte   ALIIMP08 470-470
  long   CHLDP08X 471-476
  byte   CHLIMP08 477-477
  long   CASHP08X 478-483
  byte   CSHIMP08 484-484
  long   SSIP08X 485-489
  byte   SSIIMP08 490-490
  int    PUBP08X 491-494
  byte   PUBIMP08 495-495
  long   OTHRP08X 496-500
  byte   OTHIMP08 501-501
  byte   RTHLTH31 502-503
  byte   RTHLTH42 504-505
  byte   RTHLTH53 506-507
  byte   MNHLTH31 508-509
  byte   MNHLTH42 510-511
  byte   MNHLTH53 512-513
  byte   PREGNT31 514-515
  byte   PREGNT42 516-517
  byte   PREGNT53 518-519
  byte   HIBPDX 520-521
  byte   HIBPAGED 522-523
  byte   BPMLDX 524-525
  byte   CHDDX 526-527
  byte   CHDAGED 528-529
  byte   ANGIDX 530-531
  byte   ANGIAGED 532-533
  byte   MIDX 534-535
  byte   MIAGED 536-537
  byte   OHRTDX 538-539
  byte   OHRTAGED 540-541
  byte   STRKDX 542-543
  byte   STRKAGED 544-545
  byte   EMPHDX 546-547
  byte   EMPHAGED 548-549
  byte   CHBRON31 550-551
  byte   CHBRON53 552-553
  byte   CHOLDX 554-555
  byte   CHOLAGED 556-557
  byte   CANCERDX 558-559
  byte   CABLADDR 560-561
  byte   BLDRAGED 562-563
  byte   BLDRREMS 564-565
  byte   CABLOOD 566-567
  byte   BLODAGED 568-569
  byte   BLODREMS 570-571
  byte   CABONE 572-573
  byte   BONEAGED 574-575
  byte   BONEREMS 576-577
  byte   CABRAIN 578-579
  byte   BRAIAGED 580-581
  byte   BRAIREMS 582-583
  byte   CABREAST 584-585
  byte   BRSTAGED 586-587
  byte   BRSTREMS 588-589
  byte   CACERVIX 590-591
  byte   CERVAGED 592-593
  byte   CERVREMS 594-595
  byte   CACOLON 596-597
  byte   COLOAGED 598-599
  byte   COLOREMS 600-601
  byte   CAKIDNEY 602-603
  byte   KIDNAGED 604-605
  byte   KIDNREMS 606-607
  byte   CALARYNX 608-609
  byte   LRNXAGED 610-611
  byte   LRNXREMS 612-613
  byte   CALEUKEM 614-615
  byte   LEUKAGED 616-617
  byte   LEUKREMS 618-619
  byte   CALIVER 620-621
  byte   LIVRAGED 622-623
  byte   LIVRREMS 624-625
  byte   CALUNG 626-627
  byte   LUNGAGED 628-629
  byte   LUNGREMS 630-631
  byte   CALYMPH 632-633
  byte   LYMPAGED 634-635
  byte   LYMPREMS 636-637
  byte   CAMELANO 638-639
  byte   MELAAGED 640-641
  byte   MELAREMS 642-643
  byte   CAMOUTH 644-645
  byte   MOUTAGED 646-647
  byte   MOUTREMS 648-649
  byte   CAMUSCLE 650-651
  byte   MUSCAGED 652-653
  byte   MUSCREMS 654-655
  byte   CAOVARY 656-657
  byte   OVRYAGED 658-659
  byte   OVRYREMS 660-661
  byte   CAPANCRS 662-663
  byte   PANCAGED 664-665
  byte   PANCREMS 666-667
  byte   CAPROSTA 668-669
  byte   PRSTAGED 670-671
  byte   PRSTREMS 672-673
  byte   CARECTUM 674-675
  byte   RECTAGED 676-677
  byte   RECTREMS 678-679
  byte   CASKINDK 680-681
  byte   SKDKAGED 682-683
  byte   SKDKREMS 684-685
  byte   CASKINNM 686-687
  byte   SKNMAGED 688-689
  byte   SKNMREMS 690-691
  byte   CASTOMCH 692-693
  byte   STOMAGED 694-695
  byte   STOMREMS 696-697
  byte   CATESTIS 698-699
  byte   TSTSAGED 700-701
  byte   TSTSREMS 702-703
  byte   CATHROAT 704-705
  byte   THRTAGED 706-707
  byte   THRTREMS 708-709
  byte   CATHYROD 710-711
  byte   THYRAGED 712-713
  byte   THYRREMS 714-715
  byte   CAUTERUS 716-717
  byte   UTERAGED 718-719
  byte   UTERREMS 720-721
  byte   CAOTHER 722-723
  byte   OTHRAGED 724-725
  byte   OTHRREMS 726-727
  byte   DIABDX 728-729
  byte   DIABAGED 730-731
  byte   JTPAIN31 732-733
  byte   JTPAIN53 734-735
  byte   ARTHDX 736-737
  byte   ARTHAGED 738-739
  byte   ARTHTYPE 740-741
  byte   ASTHDX 742-743
  byte   ASTHAGED 744-745
  byte   ASSTIL31 746-747
  byte   ASSTIL53 748-749
  byte   ASATAK31 750-751
  byte   ASATAK53 752-753
  byte   ASTHEP31 754-755
  byte   ASTHEP53 756-757
  byte   ASACUT53 758-759
  byte   ASMRCN53 760-761
  byte   ASPREV53 762-763
  byte   ASDALY53 764-765
  byte   ASPKFL53 766-767
  byte   ASEVFL53 768-769
  byte   ASWNFL53 770-771
  byte   ADHDADDX 772-773
  byte   ADHDAGED 774-775
  byte   IADLHP31 776-777
  byte   IADLHP42 778-779
  byte   IADLHP53 780-781
  byte   IADL3M31 782-783
  byte   IADL3M42 784-785
  byte   IADL3M53 786-787
  byte   ADLHLP31 788-789
  byte   ADLHLP42 790-791
  byte   ADLHLP53 792-793
  byte   ADL3MO31 794-795
  byte   ADL3MO42 796-797
  byte   ADL3MO53 798-799
  byte   AIDHLP31 800-801
  byte   AIDHLP53 802-803
  byte   WLKLIM31 804-805
  byte   WLKLIM53 806-807
  byte   LFTDIF31 808-809
  byte   LFTDIF53 810-811
  byte   STPDIF31 812-813
  byte   STPDIF53 814-815
  byte   WLKDIF31 816-817
  byte   WLKDIF53 818-819
  byte   MILDIF31 820-821
  byte   MILDIF53 822-823
  byte   STNDIF31 824-825
  byte   STNDIF53 826-827
  byte   BENDIF31 828-829
  byte   BENDIF53 830-831
  byte   RCHDIF31 832-833
  byte   RCHDIF53 834-835
  byte   FNGRDF31 836-837
  byte   FNGRDF53 838-839
  byte   WLK3MO31 840-841
  byte   WLK3MO53 842-843
  byte   ACTLIM31 844-845
  byte   ACTLIM53 846-847
  byte   WRKLIM31 848-849
  byte   WRKLIM53 850-851
  byte   HSELIM31 852-853
  byte   HSELIM53 854-855
  byte   SCHLIM31 856-857
  byte   SCHLIM53 858-859
  byte   UNABLE31 860-861
  byte   UNABLE53 862-863
  byte   SOCLIM31 864-865
  byte   SOCLIM53 866-867
  byte   COGLIM31 868-869
  byte   COGLIM53 870-871
  byte   WRGLAS42 872-873
  byte   SEEDIF42 874-875
  byte   BLIND42 876-877
  byte   READNW42 878-879
  byte   RECPEP42 880-881
  byte   VISION42 882-883
  byte   HEARAD42 884-885
  byte   HEARDI42 886-887
  byte   DEAF42 888-889
  byte   HEARMO42 890-891
  byte   HEARSM42 892-893
  byte   HEARNG42 894-895
  byte   ANYLIM08 896-897
  byte   LSHLTH42 898-899
  byte   NEVILL42 900-901
  byte   SICEAS42 902-903
  byte   HLTHLF42 904-905
  byte   WRHLTH42 906-907
  byte   CHPMED42 908-909
  byte   CHPMHB42 910-911
  byte   CHPMCN42 912-913
  byte   CHSERV42 914-915
  byte   CHSRHB42 916-917
  byte   CHSRCN42 918-919
  byte   CHLIMI42 920-921
  byte   CHLIHB42 922-923
  byte   CHLICO42 924-925
  byte   CHTHER42 926-927
  byte   CHTHHB42 928-929
  byte   CHTHCO42 930-931
  byte   CHCOUN42 932-933
  byte   CHEMPB42 934-935
  byte   CSHCN42 936-937
  byte   MOMPRO42 938-939
  byte   DADPRO42 940-941
  byte   UNHAP42 942-943
  byte   SCHLBH42 944-945
  byte   HAVFUN42 946-947
  byte   ADUPRO42 948-949
  byte   NERVAF42 950-951
  byte   SIBPRO42 952-953
  byte   KIDPRO42 954-955
  byte   SPRPRO42 956-957
  byte   SCHPRO42 958-959
  byte   HOMEBH42 960-961
  byte   TRBLE42 962-963
  byte   CHILCR42 964-965
  byte   CHILWW42 966-967
  byte   CHRTCR42 968-969
  byte   CHRTWW42 970-971
  byte   CHAPPT42 972-973
  byte   CHNDCR42 974-975
  byte   CHENEC42 976-977
  byte   CHLIST42 978-979
  byte   CHEXPL42 980-981
  byte   CHRESP42 982-983
  byte   CHPRTM42 984-985
  byte   CHHECR42 986-987
  byte   CHSPEC42 988-989
  byte   CHEYRE42 990-991
  byte   MESHGT42 992-993
  byte   WHNHGT42 994-995
  byte   MESWGT42 996-997
  byte   WHNWGT42 998-999
  double CHBMIX42 1000-1004
  byte   MESVIS42 1005-1006
  byte   MESBPR42 1007-1008
  byte   WHNBPR42 1009-1010
  byte   DENTAL42 1011-1012
  byte   WHNDEN42 1013-1014
  byte   EATHLT42 1015-1016
  byte   WHNEAT42 1017-1018
  byte   PHYSCL42 1019-1020
  byte   WHNPHY42 1021-1022
  byte   SAFEST42 1023-1024
  byte   WHNSAF42 1025-1026
  byte   BOOST42 1027-1028
  byte   WHNBST42 1029-1030
  byte   LAPBLT42 1031-1032
  byte   WHNLAP42 1033-1034
  byte   HELMET42 1035-1036
  byte   WHNHEL42 1037-1038
  byte   NOSMOK42 1039-1040
  byte   WHNSMK42 1041-1042
  byte   TIMALN42 1043-1044
  byte   DENTCK53 1045-1046
  byte   BPCHEK53 1047-1048
  byte   BPMONT53 1049-1050
  byte   CHOLCK53 1051-1052
  byte   CHECK53 1053-1054
  byte   NOFAT53 1055-1056
  byte   EXRCIS53 1057-1058
  byte   FLUSHT53 1059-1060
  byte   ASPRIN53 1061-1062
  byte   NOASPR53 1063-1064
  byte   STOMCH53 1065-1066
  byte   LSTETH53 1067-1068
  byte   PSA53 1069-1070
  byte   HYSTER53 1071-1072
  byte   PAPSMR53 1073-1074
  byte   BRSTEX53 1075-1076
  byte   MAMOGR53 1077-1078
  byte   STOOL53 1079-1080
  byte   WHENST53 1081-1082
  byte   BOWEL53 1083-1084
  byte   WHNBWL53 1085-1086
  byte   PHYACT53 1087-1088
  double BMINDX53 1089-1092
  byte   SEATBE53 1093-1094
  byte   SAQELIG 1095-1095
  int    ADPRX42 1096-1098
  byte   ADILCR42 1099-1100
  byte   ADILWW42 1101-1102
  byte   ADRTCR42 1103-1104
  byte   ADRTWW42 1105-1106
  byte   ADAPPT42 1107-1108
  byte   ADNDCR42 1109-1110
  byte   ADEGMC42 1111-1112
  byte   ADLIST42 1113-1114
  byte   ADEXPL42 1115-1116
  byte   ADRESP42 1117-1118
  byte   ADPRTM42 1119-1120
  byte   ADHECR42 1121-1122
  byte   ADSMOK42 1123-1124
  byte   ADNSMK42 1125-1126
  byte   ADDRBP42 1127-1128
  byte   ADSPEC42 1129-1130
  byte   ADSPRF42 1131-1132
  byte   ADGENH42 1133-1134
  byte   ADDAYA42 1135-1136
  byte   ADCLIM42 1137-1138
  byte   ADPALS42 1139-1140
  byte   ADPWLM42 1141-1142
  byte   ADMALS42 1143-1144
  byte   ADMWLM42 1145-1146
  byte   ADPAIN42 1147-1148
  byte   ADCAPE42 1149-1150
  byte   ADNRGY42 1151-1152
  byte   ADDOWN42 1153-1154
  byte   ADSOCA42 1155-1156
  double PCS42 1157-1161
  double MCS42 1162-1166
  byte   SFFLAG42 1167-1168
  byte   ADNERV42 1169-1170
  byte   ADHOPE42 1171-1172
  byte   ADREST42 1173-1174
  byte   ADSAD42 1175-1176
  byte   ADEFRT42 1177-1178
  byte   ADWRTH42 1179-1180
  byte   K6SUM42 1181-1182
  byte   ADINTR42 1183-1184
  byte   ADDPRS42 1185-1186
  double PHQ242 1187-1191
  byte   ADINSA42 1192-1193
  byte   ADINSB42 1194-1195
  byte   ADRISK42 1196-1197
  byte   ADOVER42 1198-1199
  byte   ADCMPM42 1200-1201
  byte   ADCMPD42 1202-1203
  int    ADCMPY42 1204-1207
  byte   ADLANG42 1208-1209
  byte   DSDIA53 1210-1211
  byte   DSA1C53 1212-1213
  byte   DSFT0953 1214-1215
  byte   DSFT0853 1216-1217
  byte   DSFT0753 1218-1219
  byte   DSFB0753 1220-1221
  byte   DSFTNV53 1222-1223
  byte   DSEY0953 1224-1225
  byte   DSEY0853 1226-1227
  byte   DSEY0753 1228-1229
  byte   DSEB0753 1230-1231
  byte   DSEYNV53 1232-1233
  byte   DSCH0953 1234-1235
  byte   DSCH0853 1236-1237
  byte   DSCH0753 1238-1239
  byte   DSCB0753 1240-1241
  byte   DSCHNV53 1242-1243
  byte   DSFL0953 1244-1245
  byte   DSFL0853 1246-1247
  byte   DSFL0753 1248-1249
  byte   DSVB0753 1250-1251
  byte   DSFLNV53 1252-1253
  byte   DSKIDN53 1254-1255
  byte   DSEYPR53 1256-1257
  byte   DSDIET53 1258-1259
  byte   DSMED53 1260-1261
  byte   DSINSU53 1262-1263
  byte   DSCPCP53 1264-1265
  byte   DSCNPC53 1266-1267
  byte   DSCPHN53 1268-1269
  byte   DSCINT53 1270-1271
  byte   DSCGRP53 1272-1273
  byte   DSCONF53 1274-1275
  byte   DSPRX53 1276-1277
  int    DDNWRK31 1278-1280
  int    DDNWRK42 1281-1283
  int    DDNWRK53 1284-1286
  byte   WKINBD31 1287-1288
  int    WKINBD42 1289-1291
  int    WKINBD53 1292-1294
  byte   DDNSCL31 1295-1296
  byte   DDNSCL42 1297-1298
  byte   DDNSCL53 1299-1300
  byte   SCLNBD31 1301-1302
  byte   SCLNBD42 1303-1304
  byte   SCLNBD53 1305-1306
  int    DDBDYS31 1307-1309
  int    DDBDYS42 1310-1312
  int    DDBDYS53 1313-1315
  byte   OTHDYS31 1316-1317
  byte   OTHDYS42 1318-1319
  byte   OTHDYS53 1320-1321
  byte   OTHNDD31 1322-1323
  int    OTHNDD42 1324-1326
  byte   OTHNDD53 1327-1328
  byte   ACCELI42 1329-1330
  byte   LANGHM42 1331-1332
  byte   ENGCMF42 1333-1334
  byte   ENGSPK42 1335-1336
  byte   USBORN42 1337-1338
  byte   USLIVE42 1339-1340
  byte   HAVEUS42 1341-1342
  byte   YNOUSC42 1343-1344
  byte   NOREAS42 1345-1346
  byte   SELDSI42 1347-1348
  byte   NEWARE42 1349-1350
  byte   DKWHRU42 1351-1352
  byte   USCNOT42 1353-1354
  byte   PERSLA42 1355-1356
  byte   DIFFPL42 1357-1358
  byte   INSRPL42 1359-1360
  byte   MYSELF42 1361-1362
  byte   CARECO42 1363-1364
  byte   OTHINS42 1365-1366
  byte   JOBRSN42 1367-1368
  byte   NEWDOC42 1369-1370
  byte   DOCELS42 1371-1372
  byte   NOLIKE42 1373-1374
  byte   HEALTH42 1375-1376
  byte   KNOWDR42 1377-1378
  byte   ONJOB42 1379-1380
  byte   NOGODR42 1381-1382
  byte   TRANS42 1383-1384
  byte   CLINIC42 1385-1386
  byte   OTHREA42 1387-1388
  byte   PROVTY42 1389-1390
  byte   PLCTYP42 1391-1392
  byte   GOTOUS42 1393-1394
  byte   TMTKUS42 1395-1396
  byte   DFTOUS42 1397-1398
  byte   TYPEPE42 1399-1400
  byte   LOCATN42 1401-1402
  byte   HSPLAP42 1403-1404
  byte   WHITPR42 1405-1406
  byte   BLCKPR42 1407-1408
  byte   ASIANP42 1409-1410
  byte   NATAMP42 1411-1412
  byte   PACISP42 1413-1414
  byte   OTHRCP42 1415-1416
  byte   GENDRP42 1417-1418
  byte   MINORP42 1419-1420
  byte   PREVEN42 1421-1422
  byte   REFFRL42 1423-1424
  byte   ONGONG42 1425-1426
  byte   PHNREG42 1427-1428
  byte   OFFHOU42 1429-1430
  byte   AFTHOU42 1431-1432
  byte   TREATM42 1433-1434
  byte   RESPCT42 1435-1436
  byte   DECIDE42 1437-1438
  byte   EXPLOP42 1439-1440
  byte   LANGPR42 1441-1442
  byte   MDUNAB42 1443-1444
  byte   MDUNRS42 1445-1446
  byte   MDUNPR42 1447-1448
  byte   MDDLAY42 1449-1450
  byte   MDDLRS42 1451-1452
  byte   MDDLPR42 1453-1454
  byte   DNUNAB42 1455-1456
  byte   DNUNRS42 1457-1458
  byte   DNUNPR42 1459-1460
  byte   DNDLAY42 1461-1462
  byte   DNDLRS42 1463-1464
  byte   DNDLPR42 1465-1466
  byte   PMUNAB42 1467-1468
  byte   PMUNRS42 1469-1470
  byte   PMUNPR42 1471-1472
  byte   PMDLAY42 1473-1474
  byte   PMDLRS42 1475-1476
  byte   PMDLPR42 1477-1478
  byte   EMPST31 1479-1480
  byte   EMPST42 1481-1482
  byte   EMPST53 1483-1484
  byte   RNDFLG31 1485-1486
  byte   MORJOB31 1487-1488
  byte   MORJOB42 1489-1490
  byte   MORJOB53 1491-1492
  byte   EVRWRK 1493-1494
  double HRWG31X 1495-1500
  double HRWG42X 1501-1506
  double HRWG53X 1507-1512
  byte   HRWGIM31 1513-1513
  byte   HRWGIM42 1514-1514
  byte   HRWGIM53 1515-1515
  byte   HRHOW31 1516-1517
  byte   HRHOW42 1518-1519
  byte   HRHOW53 1520-1521
  byte   DIFFWG31 1522-1523
  byte   DIFFWG42 1524-1525
  byte   DIFFWG53 1526-1527
  double NHRWG31 1528-1533
  double NHRWG42 1534-1539
  double NHRWG53 1540-1545
  int    HOUR31 1546-1548
  byte   HOUR42 1549-1550
  int    HOUR53 1551-1553
  byte   TEMPJB31 1554-1555
  byte   TEMPJB42 1556-1557
  byte   TEMPJB53 1558-1559
  byte   SSNLJB31 1560-1561
  byte   SSNLJB42 1562-1563
  byte   SSNLJB53 1564-1565
  byte   SELFCM31 1566-1567
  byte   SELFCM42 1568-1569
  byte   SELFCM53 1570-1571
  byte   DISVW31X 1572-1573
  byte   DISVW42X 1574-1575
  byte   DISVW53X 1576-1577
  byte   CHOIC31 1578-1579
  byte   CHOIC42 1580-1581
  byte   CHOIC53 1582-1583
  byte   INDCAT31 1584-1585
  byte   INDCAT42 1586-1587
  byte   INDCAT53 1588-1589
  int    NUMEMP31 1590-1592
  int    NUMEMP42 1593-1595
  int    NUMEMP53 1596-1598
  byte   MORE31 1599-1600
  byte   MORE42 1601-1602
  byte   MORE53 1603-1604
  byte   UNION31 1605-1606
  byte   UNION42 1607-1608
  byte   UNION53 1609-1610
  byte   NWK31 1611-1612
  byte   NWK42 1613-1614
  byte   NWK53 1615-1616
  byte   CHGJ3142 1617-1618
  byte   CHGJ4253 1619-1620
  byte   YCHJ3142 1621-1622
  byte   YCHJ4253 1623-1624
  byte   STJBDD31 1625-1626
  byte   STJBMM31 1627-1628
  int    STJBYY31 1629-1632
  byte   STJBDD42 1633-1634
  byte   STJBMM42 1635-1636
  int    STJBYY42 1637-1640
  byte   STJBDD53 1641-1642
  byte   STJBMM53 1643-1644
  int    STJBYY53 1645-1648
  byte   EVRETIRE 1649-1650
  byte   OCCCAT31 1651-1652
  byte   OCCCAT42 1653-1654
  byte   OCCCAT53 1655-1656
  byte   PAYVAC31 1657-1658
  byte   PAYVAC42 1659-1660
  byte   PAYVAC53 1661-1662
  byte   SICPAY31 1663-1664
  byte   SICPAY42 1665-1666
  byte   SICPAY53 1667-1668
  byte   PAYDR31 1669-1670
  byte   PAYDR42 1671-1672
  byte   PAYDR53 1673-1674
  byte   RETPLN31 1675-1676
  byte   RETPLN42 1677-1678
  byte   RETPLN53 1679-1680
  byte   BSNTY31 1681-1682
  byte   BSNTY42 1683-1684
  byte   BSNTY53 1685-1686
  byte   JOBORG31 1687-1688
  byte   JOBORG42 1689-1690
  byte   JOBORG53 1691-1692
  byte   HELD31X 1693-1694
  byte   HELD42X 1695-1696
  byte   HELD53X 1697-1698
  byte   OFFER31X 1699-1700
  byte   OFFER42X 1701-1702
  byte   OFFER53X 1703-1704
  byte   OFREMP31 1705-1706
  byte   OFREMP42 1707-1708
  byte   OFREMP53 1709-1710
  byte   YNOINS31 1711-1712
  byte   YNOINS42 1713-1714
  byte   YNOINS53 1715-1716
  byte   TRIJA08X 1717-1718
  byte   TRIFE08X 1719-1720
  byte   TRIMA08X 1721-1722
  byte   TRIAP08X 1723-1724
  byte   TRIMY08X 1725-1726
  byte   TRIJU08X 1727-1728
  byte   TRIJL08X 1729-1730
  byte   TRIAU08X 1731-1732
  byte   TRISE08X 1733-1734
  byte   TRIOC08X 1735-1736
  byte   TRINO08X 1737-1738
  byte   TRIDE08X 1739-1740
  byte   MCRJA08 1741-1742
  byte   MCRFE08 1743-1744
  byte   MCRMA08 1745-1746
  byte   MCRAP08 1747-1748
  byte   MCRMY08 1749-1750
  byte   MCRJU08 1751-1752
  byte   MCRJL08 1753-1754
  byte   MCRAU08 1755-1756
  byte   MCRSE08 1757-1758
  byte   MCROC08 1759-1760
  byte   MCRNO08 1761-1762
  byte   MCRDE08 1763-1764
  byte   MCRJA08X 1765-1766
  byte   MCRFE08X 1767-1768
  byte   MCRMA08X 1769-1770
  byte   MCRAP08X 1771-1772
  byte   MCRMY08X 1773-1774
  byte   MCRJU08X 1775-1776
  byte   MCRJL08X 1777-1778
  byte   MCRAU08X 1779-1780
  byte   MCRSE08X 1781-1782
  byte   MCROC08X 1783-1784
  byte   MCRNO08X 1785-1786
  byte   MCRDE08X 1787-1788
  byte   MCDJA08 1789-1790
  byte   MCDFE08 1791-1792
  byte   MCDMA08 1793-1794
  byte   MCDAP08 1795-1796
  byte   MCDMY08 1797-1798
  byte   MCDJU08 1799-1800
  byte   MCDJL08 1801-1802
  byte   MCDAU08 1803-1804
  byte   MCDSE08 1805-1806
  byte   MCDOC08 1807-1808
  byte   MCDNO08 1809-1810
  byte   MCDDE08 1811-1812
  byte   MCDJA08X 1813-1814
  byte   MCDFE08X 1815-1816
  byte   MCDMA08X 1817-1818
  byte   MCDAP08X 1819-1820
  byte   MCDMY08X 1821-1822
  byte   MCDJU08X 1823-1824
  byte   MCDJL08X 1825-1826
  byte   MCDAU08X 1827-1828
  byte   MCDSE08X 1829-1830
  byte   MCDOC08X 1831-1832
  byte   MCDNO08X 1833-1834
  byte   MCDDE08X 1835-1836
  byte   OPAJA08 1837-1838
  byte   OPAFE08 1839-1840
  byte   OPAMA08 1841-1842
  byte   OPAAP08 1843-1844
  byte   OPAMY08 1845-1846
  byte   OPAJU08 1847-1848
  byte   OPAJL08 1849-1850
  byte   OPAAU08 1851-1852
  byte   OPASE08 1853-1854
  byte   OPAOC08 1855-1856
  byte   OPANO08 1857-1858
  byte   OPADE08 1859-1860
  byte   OPBJA08 1861-1862
  byte   OPBFE08 1863-1864
  byte   OPBMA08 1865-1866
  byte   OPBAP08 1867-1868
  byte   OPBMY08 1869-1870
  byte   OPBJU08 1871-1872
  byte   OPBJL08 1873-1874
  byte   OPBAU08 1875-1876
  byte   OPBSE08 1877-1878
  byte   OPBOC08 1879-1880
  byte   OPBNO08 1881-1882
  byte   OPBDE08 1883-1884
  byte   STAJA08 1885-1886
  byte   STAFE08 1887-1888
  byte   STAMA08 1889-1890
  byte   STAAP08 1891-1892
  byte   STAMY08 1893-1894
  byte   STAJU08 1895-1896
  byte   STAJL08 1897-1898
  byte   STAAU08 1899-1900
  byte   STASE08 1901-1902
  byte   STAOC08 1903-1904
  byte   STANO08 1905-1906
  byte   STADE08 1907-1908
  byte   PUBJA08X 1909-1910
  byte   PUBFE08X 1911-1912
  byte   PUBMA08X 1913-1914
  byte   PUBAP08X 1915-1916
  byte   PUBMY08X 1917-1918
  byte   PUBJU08X 1919-1920
  byte   PUBJL08X 1921-1922
  byte   PUBAU08X 1923-1924
  byte   PUBSE08X 1925-1926
  byte   PUBOC08X 1927-1928
  byte   PUBNO08X 1929-1930
  byte   PUBDE08X 1931-1932
  byte   PEGJA08 1933-1934
  byte   PEGFE08 1935-1936
  byte   PEGMA08 1937-1938
  byte   PEGAP08 1939-1940
  byte   PEGMY08 1941-1942
  byte   PEGJU08 1943-1944
  byte   PEGJL08 1945-1946
  byte   PEGAU08 1947-1948
  byte   PEGSE08 1949-1950
  byte   PEGOC08 1951-1952
  byte   PEGNO08 1953-1954
  byte   PEGDE08 1955-1956
  byte   PDKJA08 1957-1958
  byte   PDKFE08 1959-1960
  byte   PDKMA08 1961-1962
  byte   PDKAP08 1963-1964
  byte   PDKMY08 1965-1966
  byte   PDKJU08 1967-1968
  byte   PDKJL08 1969-1970
  byte   PDKAU08 1971-1972
  byte   PDKSE08 1973-1974
  byte   PDKOC08 1975-1976
  byte   PDKNO08 1977-1978
  byte   PDKDE08 1979-1980
  byte   PNGJA08 1981-1982
  byte   PNGFE08 1983-1984
  byte   PNGMA08 1985-1986
  byte   PNGAP08 1987-1988
  byte   PNGMY08 1989-1990
  byte   PNGJU08 1991-1992
  byte   PNGJL08 1993-1994
  byte   PNGAU08 1995-1996
  byte   PNGSE08 1997-1998
  byte   PNGOC08 1999-2000
  byte   PNGNO08 2001-2002
  byte   PNGDE08 2003-2004
  byte   POGJA08 2005-2006
  byte   POGFE08 2007-2008
  byte   POGMA08 2009-2010
  byte   POGAP08 2011-2012
  byte   POGMY08 2013-2014
  byte   POGJU08 2015-2016
  byte   POGJL08 2017-2018
  byte   POGAU08 2019-2020
  byte   POGSE08 2021-2022
  byte   POGOC08 2023-2024
  byte   POGNO08 2025-2026
  byte   POGDE08 2027-2028
  byte   PRSJA08 2029-2030
  byte   PRSFE08 2031-2032
  byte   PRSMA08 2033-2034
  byte   PRSAP08 2035-2036
  byte   PRSMY08 2037-2038
  byte   PRSJU08 2039-2040
  byte   PRSJL08 2041-2042
  byte   PRSAU08 2043-2044
  byte   PRSSE08 2045-2046
  byte   PRSOC08 2047-2048
  byte   PRSNO08 2049-2050
  byte   PRSDE08 2051-2052
  byte   POUJA08 2053-2054
  byte   POUFE08 2055-2056
  byte   POUMA08 2057-2058
  byte   POUAP08 2059-2060
  byte   POUMY08 2061-2062
  byte   POUJU08 2063-2064
  byte   POUJL08 2065-2066
  byte   POUAU08 2067-2068
  byte   POUSE08 2069-2070
  byte   POUOC08 2071-2072
  byte   POUNO08 2073-2074
  byte   POUDE08 2075-2076
  byte   PRIJA08 2077-2078
  byte   PRIFE08 2079-2080
  byte   PRIMA08 2081-2082
  byte   PRIAP08 2083-2084
  byte   PRIMY08 2085-2086
  byte   PRIJU08 2087-2088
  byte   PRIJL08 2089-2090
  byte   PRIAU08 2091-2092
  byte   PRISE08 2093-2094
  byte   PRIOC08 2095-2096
  byte   PRINO08 2097-2098
  byte   PRIDE08 2099-2100
  byte   HPEJA08 2101-2102
  byte   HPEFE08 2103-2104
  byte   HPEMA08 2105-2106
  byte   HPEAP08 2107-2108
  byte   HPEMY08 2109-2110
  byte   HPEJU08 2111-2112
  byte   HPEJL08 2113-2114
  byte   HPEAU08 2115-2116
  byte   HPESE08 2117-2118
  byte   HPEOC08 2119-2120
  byte   HPENO08 2121-2122
  byte   HPEDE08 2123-2124
  byte   HPDJA08 2125-2126
  byte   HPDFE08 2127-2128
  byte   HPDMA08 2129-2130
  byte   HPDAP08 2131-2132
  byte   HPDMY08 2133-2134
  byte   HPDJU08 2135-2136
  byte   HPDJL08 2137-2138
  byte   HPDAU08 2139-2140
  byte   HPDSE08 2141-2142
  byte   HPDOC08 2143-2144
  byte   HPDNO08 2145-2146
  byte   HPDDE08 2147-2148
  byte   HPNJA08 2149-2150
  byte   HPNFE08 2151-2152
  byte   HPNMA08 2153-2154
  byte   HPNAP08 2155-2156
  byte   HPNMY08 2157-2158
  byte   HPNJU08 2159-2160
  byte   HPNJL08 2161-2162
  byte   HPNAU08 2163-2164
  byte   HPNSE08 2165-2166
  byte   HPNOC08 2167-2168
  byte   HPNNO08 2169-2170
  byte   HPNDE08 2171-2172
  byte   HPOJA08 2173-2174
  byte   HPOFE08 2175-2176
  byte   HPOMA08 2177-2178
  byte   HPOAP08 2179-2180
  byte   HPOMY08 2181-2182
  byte   HPOJU08 2183-2184
  byte   HPOJL08 2185-2186
  byte   HPOAU08 2187-2188
  byte   HPOSE08 2189-2190
  byte   HPOOC08 2191-2192
  byte   HPONO08 2193-2194
  byte   HPODE08 2195-2196
  byte   HPSJA08 2197-2198
  byte   HPSFE08 2199-2200
  byte   HPSMA08 2201-2202
  byte   HPSAP08 2203-2204
  byte   HPSMY08 2205-2206
  byte   HPSJU08 2207-2208
  byte   HPSJL08 2209-2210
  byte   HPSAU08 2211-2212
  byte   HPSSE08 2213-2214
  byte   HPSOC08 2215-2216
  byte   HPSNO08 2217-2218
  byte   HPSDE08 2219-2220
  byte   HPRJA08 2221-2222
  byte   HPRFE08 2223-2224
  byte   HPRMA08 2225-2226
  byte   HPRAP08 2227-2228
  byte   HPRMY08 2229-2230
  byte   HPRJU08 2231-2232
  byte   HPRJL08 2233-2234
  byte   HPRAU08 2235-2236
  byte   HPRSE08 2237-2238
  byte   HPROC08 2239-2240
  byte   HPRNO08 2241-2242
  byte   HPRDE08 2243-2244
  byte   INSJA08X 2245-2246
  byte   INSFE08X 2247-2248
  byte   INSMA08X 2249-2250
  byte   INSAP08X 2251-2252
  byte   INSMY08X 2253-2254
  byte   INSJU08X 2255-2256
  byte   INSJL08X 2257-2258
  byte   INSAU08X 2259-2260
  byte   INSSE08X 2261-2262
  byte   INSOC08X 2263-2264
  byte   INSNO08X 2265-2266
  byte   INSDE08X 2267-2268
  byte   PRVEV08 2269-2269
  byte   TRIEV08 2270-2270
  byte   MCREV08 2271-2271
  byte   MCDEV08 2272-2272
  byte   OPAEV08 2273-2273
  byte   OPBEV08 2274-2274
  byte   UNINS08 2275-2275
  byte   INSCOV08 2276-2276
  byte   TRIST31X 2277-2278
  byte   TRIST42X 2279-2280
  byte   TRIST08X 2281-2282
  byte   TRIPR31X 2283-2284
  byte   TRIPR42X 2285-2286
  byte   TRIPR08X 2287-2288
  byte   TRIEX31X 2289-2290
  byte   TRIEX42X 2291-2292
  byte   TRIEX08X 2293-2294
  byte   TRILI31X 2295-2296
  byte   TRILI42X 2297-2298
  byte   TRILI08X 2299-2300
  byte   TRICH31X 2301-2302
  byte   TRICH42X 2303-2304
  byte   TRICH08X 2305-2306
  byte   MCRPD31 2307-2308
  byte   MCRPD42 2309-2310
  byte   MCRPD08 2311-2312
  byte   MCRPD31X 2313-2314
  byte   MCRPD42X 2315-2316
  byte   MCRPD08X 2317-2318
  byte   MCRPHO31 2319-2320
  byte   MCRPHO42 2321-2322
  byte   MCRPHO08 2323-2324
  byte   MCDHMO31 2325-2326
  byte   MCDHMO42 2327-2328
  byte   MCDHMO08 2329-2330
  byte   MCDMC31 2331-2332
  byte   MCDMC42 2333-2334
  byte   MCDMC08 2335-2336
  byte   PRVHMO31 2337-2338
  byte   PRVHMO42 2339-2340
  byte   PRVHMO08 2341-2342
  byte   PRVMNC31 2343-2344
  byte   PRVMNC42 2345-2346
  byte   PRVMNC08 2347-2348
  byte   PRVDRL31 2349-2350
  byte   PRVDRL42 2351-2352
  byte   PRVDRL08 2353-2354
  byte   PHMONP31 2355-2356
  byte   PHMONP42 2357-2358
  byte   PHMONP08 2359-2360
  byte   PMNCNP31 2361-2362
  byte   PMNCNP42 2363-2364
  byte   PMNCNP08 2365-2366
  byte   PRDRNP31 2367-2368
  byte   PRDRNP42 2369-2370
  byte   PRDRNP08 2371-2372
  byte   PREVCOVR 2373-2374
  byte   COVRMM 2375-2376
  int    COVRYY 2377-2380
  byte   WASESTB 2381-2382
  byte   WASMCARE 2383-2384
  byte   WASMCAID 2385-2386
  byte   WASCHAMP 2387-2388
  byte   WASVA 2389-2390
  byte   WASPRIV 2391-2392
  byte   WASOTGOV 2393-2394
  byte   WASAFDC 2395-2396
  byte   WASSSI 2397-2398
  byte   WASSTAT1 2399-2400
  byte   WASSTAT2 2401-2402
  byte   WASSTAT3 2403-2404
  byte   WASSTAT4 2405-2406
  byte   WASOTHER 2407-2408
  byte   NOINSBEF 2409-2410
  byte   NOINSTM 2411-2412
  byte   NOINUNIT 2413-2414
  byte   MORECOVR 2415-2416
  byte   INSENDMM 2417-2418
  int    INSENDYY 2419-2422
  byte   TRICR31X 2423-2424
  byte   TRICR42X 2425-2426
  byte   TRICR53X 2427-2428
  byte   TRICR08X 2429-2430
  byte   TRIAT31X 2431-2432
  byte   TRIAT42X 2433-2434
  byte   TRIAT53X 2435-2436
  byte   TRIAT08X 2437-2438
  byte   MCAID31 2439-2440
  byte   MCAID42 2441-2442
  byte   MCAID53 2443-2444
  byte   MCAID08 2445-2446
  byte   MCAID31X 2447-2448
  byte   MCAID42X 2449-2450
  byte   MCAID53X 2451-2452
  byte   MCAID08X 2453-2454
  byte   MCARE31 2455-2456
  byte   MCARE42 2457-2458
  byte   MCARE53 2459-2460
  byte   MCARE08 2461-2462
  byte   MCARE31X 2463-2464
  byte   MCARE42X 2465-2466
  byte   MCARE53X 2467-2468
  byte   MCARE08X 2469-2470
  byte   MCDAT31X 2471-2472
  byte   MCDAT42X 2473-2474
  byte   MCDAT53X 2475-2476
  byte   MCDAT08X 2477-2478
  byte   OTPAAT31 2479-2480
  byte   OTPAAT42 2481-2482
  byte   OTPAAT53 2483-2484
  byte   OTPAAT08 2485-2486
  byte   OTPBAT31 2487-2488
  byte   OTPBAT42 2489-2490
  byte   OTPBAT53 2491-2492
  byte   OTPBAT08 2493-2494
  byte   OTPUBA31 2495-2496
  byte   OTPUBA42 2497-2498
  byte   OTPUBA53 2499-2500
  byte   OTPUBA08 2501-2502
  byte   OTPUBB31 2503-2504
  byte   OTPUBB42 2505-2506
  byte   OTPUBB53 2507-2508
  byte   OTPUBB08 2509-2510
  byte   PRIDK31 2511-2512
  byte   PRIDK42 2513-2514
  byte   PRIDK53 2515-2516
  byte   PRIDK08 2517-2518
  byte   PRIEU31 2519-2520
  byte   PRIEU42 2521-2522
  byte   PRIEU53 2523-2524
  byte   PRIEU08 2525-2526
  byte   PRING31 2527-2528
  byte   PRING42 2529-2530
  byte   PRING53 2531-2532
  byte   PRING08 2533-2534
  byte   PRIOG31 2535-2536
  byte   PRIOG42 2537-2538
  byte   PRIOG53 2539-2540
  byte   PRIOG08 2541-2542
  byte   PRIS31 2543-2544
  byte   PRIS42 2545-2546
  byte   PRIS53 2547-2548
  byte   PRIS08 2549-2550
  byte   PRIV31 2551-2552
  byte   PRIV42 2553-2554
  byte   PRIV53 2555-2556
  byte   PRIV08 2557-2558
  byte   PRIVAT31 2559-2560
  byte   PRIVAT42 2561-2562
  byte   PRIVAT53 2563-2564
  byte   PRIVAT08 2565-2566
  byte   PROUT31 2567-2568
  byte   PROUT42 2569-2570
  byte   PROUT53 2571-2572
  byte   PROUT08 2573-2574
  byte   PUB31X 2575-2576
  byte   PUB42X 2577-2578
  byte   PUB53X 2579-2580
  byte   PUB08X 2581-2582
  byte   PUBAT31X 2583-2584
  byte   PUBAT42X 2585-2586
  byte   PUBAT53X 2587-2588
  byte   PUBAT08X 2589-2590
  byte   INS31X 2591-2592
  byte   INS42X 2593-2594
  byte   INS53X 2595-2596
  byte   INS08X 2597-2598
  byte   INSAT31X 2599-2600
  byte   INSAT42X 2601-2602
  byte   INSAT53X 2603-2604
  byte   INSAT08X 2605-2606
  byte   STAPR31 2607-2608
  byte   STAPR42 2609-2610
  byte   STAPR53 2611-2612
  byte   STAPR08 2613-2614
  byte   STPRAT31 2615-2616
  byte   STPRAT42 2617-2618
  byte   STPRAT53 2619-2620
  byte   STPRAT08 2621-2622
  byte   EVRUNINS 2623-2623
  byte   EVRUNAT 2624-2624
  byte   DENTIN31 2625-2626
  byte   DENTIN42 2627-2628
  byte   DENTIN53 2629-2630
  byte   DNTINS31 2631-2632
  byte   DNTINS08 2633-2634
  byte   PMEDIN31 2635-2636
  byte   PMEDIN42 2637-2638
  byte   PMEDIN53 2639-2640
  byte   PMDINS31 2641-2642
  byte   PMDINS08 2643-2644
  byte   PMEDUP31 2645-2646
  byte   PMEDUP42 2647-2648
  byte   PMEDUP53 2649-2650
  byte   PMEDPY31 2651-2652
  byte   PMEDPY42 2653-2654
  byte   PMEDPY53 2655-2656
  int    PMEDOP31 2657-2660
  int    PMEDOP42 2661-2664
  int    PMEDOP53 2665-2668
  byte   GDCPBM42 2669-2670
  byte   APRTRM42 2671-2672
  byte   APRDLM42 2673-2674
  byte   LKINFM42 2675-2676
  byte   PBINFM42 2677-2678
  byte   CSTSVM42 2679-2680
  byte   PBSVCM42 2681-2682
  byte   PPRWKM42 2683-2684
  byte   PBPWKM42 2685-2686
  byte   RTPLNM42 2687-2688
  byte   GDCPBT42 2689-2690
  byte   APRTRT42 2691-2692
  byte   APRDLT42 2693-2694
  byte   LKINFT42 2695-2696
  byte   PBINFT42 2697-2698
  byte   CSTSVT42 2699-2700
  byte   PBSVCT42 2701-2702
  byte   PPRWKT42 2703-2704
  byte   PBPWKT42 2705-2706
  byte   RTPLNT42 2707-2708
  long   TOTTCH08 2709-2715
  long   TOTEXP08 2716-2721
  long   TOTSLF08 2722-2726
  long   TOTMCR08 2727-2732
  long   TOTMCD08 2733-2738
  long   TOTPRV08 2739-2744
  long   TOTVA08 2745-2750
  long   TOTTRI08 2751-2755
  long   TOTOFD08 2756-2760
  long   TOTSTL08 2761-2765
  long   TOTWCP08 2766-2771
  long   TOTOPR08 2772-2777
  long   TOTOPU08 2778-2782
  long   TOTOSR08 2783-2787
  int    OBTOTV08 2788-2790
  long   OBVTCH08 2791-2796
  long   OBVEXP08 2797-2802
  long   OBVSLF08 2803-2807
  long   OBVMCR08 2808-2813
  long   OBVMCD08 2814-2818
  long   OBVPRV08 2819-2823
  long   OBVVA08 2824-2828
  long   OBVTRI08 2829-2833
  int    OBVOFD08 2834-2837
  long   OBVSTL08 2838-2842
  long   OBVWCP08 2843-2847
  long   OBVOPR08 2848-2852
  long   OBVOPU08 2853-2857
  long   OBVOSR08 2858-2862
  int    OBDRV08 2863-2865
  long   OBDTCH08 2866-2871
  long   OBDEXP08 2872-2877
  long   OBDSLF08 2878-2882
  long   OBDMCR08 2883-2887
  long   OBDMCD08 2888-2892
  long   OBDPRV08 2893-2897
  long   OBDVA08 2898-2902
  long   OBDTRI08 2903-2907
  int    OBDOFD08 2908-2911
  long   OBDSTL08 2912-2916
  long   OBDWCP08 2917-2921
  long   OBDOPR08 2922-2926
  long   OBDOPU08 2927-2931
  long   OBDOSR08 2932-2936
  int    OBOTHV08 2937-2939
  long   OBOTCH08 2940-2945
  long   OBOEXP08 2946-2951
  long   OBOSLF08 2952-2956
  long   OBOMCR08 2957-2962
  long   OBOMCD08 2963-2967
  long   OBOPRV08 2968-2972
  int    OBOVA08 2973-2976
  int    OBOTRI08 2977-2980
  int    OBOOFD08 2981-2984
  long   OBOSTL08 2985-2989
  int    OBOWCP08 2990-2993
  long   OBOOPR08 2994-2998
  int    OBOOPU08 2999-3002
  long   OBOOSR08 3003-3007
  int    OBCHIR08 3008-3010
  long   OBCTCH08 3011-3015
  long   OBCEXP08 3016-3020
  int    OBCSLF08 3021-3024
  int    OBCMCR08 3025-3028
  int    OBCMCD08 3029-3032
  int    OBCPRV08 3033-3036
  int    OBCVA08 3037-3039
  byte   OBCTRI08 3040-3041
  byte   OBCOFD08 3042-3042
  int    OBCSTL08 3043-3046
  int    OBCWCP08 3047-3050
  long   OBCOPR08 3051-3055
  byte   OBCOPU08 3056-3057
  long   OBCOSR08 3058-3062
  int    OBNURS08 3063-3065
  long   OBNTCH08 3066-3071
  long   OBNEXP08 3072-3077
  int    OBNSLF08 3078-3081
  long   OBNMCR08 3082-3087
  long   OBNMCD08 3088-3092
  long   OBNPRV08 3093-3097
  int    OBNVA08 3098-3101
  int    OBNTRI08 3102-3105
  int    OBNOFD08 3106-3109
  long   OBNSTL08 3110-3114
  int    OBNWCP08 3115-3118
  int    OBNOPR08 3119-3122
  int    OBNOPU08 3123-3126
  int    OBNOSR08 3127-3130
  byte   OBOPTO08 3131-3131
  int    OBETCH08 3132-3135
  int    OBEEXP08 3136-3139
  int    OBESLF08 3140-3143
  int    OBEMCR08 3144-3147
  int    OBEMCD08 3148-3150
  int    OBEPRV08 3151-3153
  int    OBEVA08 3154-3156
  int    OBETRI08 3157-3159
  int    OBEOFD08 3160-3162
  int    OBESTL08 3163-3165
  byte   OBEWCP08 3166-3166
  int    OBEOPR08 3167-3169
  byte   OBEOPU08 3170-3171
  int    OBEOSR08 3172-3174
  byte   OBASST08 3175-3176
  long   OBATCH08 3177-3181
  long   OBAEXP08 3182-3186
  long   OBASLF08 3187-3191
  int    OBAMCR08 3192-3195
  int    OBAMCD08 3196-3199
  int    OBAPRV08 3200-3203
  int    OBAVA08 3204-3207
  int    OBATRI08 3208-3211
  int    OBAOFD08 3212-3215
  int    OBASTL08 3216-3218
  int    OBAWCP08 3219-3222
  int    OBAOPR08 3223-3226
  int    OBAOPU08 3227-3229
  int    OBAOSR08 3230-3233
  byte   OBTHER08 3234-3235
  long   OBTTCH08 3236-3240
  long   OBTEXP08 3241-3245
  int    OBTSLF08 3246-3249
  int    OBTMCR08 3250-3253
  int    OBTMCD08 3254-3257
  long   OBTPRV08 3258-3262
  int    OBTVA08 3263-3266
  int    OBTTRI08 3267-3270
  int    OBTOFD08 3271-3273
  int    OBTSTL08 3274-3276
  int    OBTWCP08 3277-3280
  int    OBTOPR08 3281-3284
  int    OBTOPU08 3285-3288
  int    OBTOSR08 3289-3292
  int    OPTOTV08 3293-3295
  long   OPTTCH08 3296-3301
  long   OPTEXP08 3302-3307
  long   OPTSLF08 3308-3312
  long   OPTMCR08 3313-3317
  long   OPTMCD08 3318-3323
  long   OPTPRV08 3324-3328
  long   OPTVA08 3329-3333
  long   OPTTRI08 3334-3338
  int    OPTOFD08 3339-3342
  int    OPTSTL08 3343-3346
  long   OPTWCP08 3347-3351
  long   OPTOPR08 3352-3356
  int    OPTOPU08 3357-3360
  long   OPTOSR08 3361-3365
  long   OPFTCH08 3366-3371
  long   OPFEXP08 3372-3377
  int    OPFSLF08 3378-3381
  long   OPFMCR08 3382-3386
  long   OPFMCD08 3387-3392
  long   OPFPRV08 3393-3397
  long   OPFVA08 3398-3402
  long   OPFTRI08 3403-3407
  int    OPFOFD08 3408-3411
  int    OPFSTL08 3412-3415
  long   OPFWCP08 3416-3420
  long   OPFOPR08 3421-3425
  int    OPFOPU08 3426-3429
  long   OPFOSR08 3430-3434
  long   OPDEXP08 3435-3439
  long   OPDTCH08 3440-3445
  long   OPDSLF08 3446-3450
  int    OPDMCR08 3451-3454
  long   OPDMCD08 3455-3459
  int    OPDPRV08 3460-3463
  int    OPDVA08 3464-3466
  int    OPDTRI08 3467-3470
  int    OPDOFD08 3471-3474
  int    OPDSTL08 3475-3478
  int    OPDWCP08 3479-3482
  int    OPDOPR08 3483-3486
  int    OPDOPU08 3487-3490
  int    OPDOSR08 3491-3493
  int    OPDRV08 3494-3496
  long   OPVTCH08 3497-3502
  long   OPVEXP08 3503-3508
  int    OPVSLF08 3509-3512
  long   OPVMCR08 3513-3517
  long   OPVMCD08 3518-3523
  long   OPVPRV08 3524-3528
  long   OPVVA08 3529-3533
  long   OPVTRI08 3534-3538
  int    OPVOFD08 3539-3542
  int    OPVSTL08 3543-3546
  long   OPVWCP08 3547-3551
  long   OPVOPR08 3552-3556
  int    OPVOPU08 3557-3560
  long   OPVOSR08 3561-3565
  long   OPSEXP08 3566-3570
  long   OPSTCH08 3571-3576
  long   OPSSLF08 3577-3581
  int    OPSMCR08 3582-3585
  long   OPSMCD08 3586-3590
  int    OPSPRV08 3591-3594
  int    OPSVA08 3595-3597
  int    OPSTRI08 3598-3601
  int    OPSOFD08 3602-3605
  int    OPSSTL08 3606-3609
  int    OPSWCP08 3610-3613
  int    OPSOPR08 3614-3617
  int    OPSOPU08 3618-3621
  int    OPSOSR08 3622-3624
  int    OPOTHV08 3625-3627
  long   OPOTCH08 3628-3633
  long   OPOEXP08 3634-3639
  int    OPOSLF08 3640-3643
  long   OPOMCR08 3644-3648
  int    OPOMCD08 3649-3652
  long   OPOPRV08 3653-3657
  int    OPOVA08 3658-3661
  int    OPOTRI08 3662-3665
  int    OPOOFD08 3666-3668
  int    OPOSTL08 3669-3672
  long   OPOWCP08 3673-3677
  int    OPOOPR08 3678-3681
  int    OPOOPU08 3682-3685
  int    OPOOSR08 3686-3689
  long   OPPEXP08 3690-3694
  long   OPPTCH08 3695-3699
  int    OPPSLF08 3700-3703
  int    OPPMCR08 3704-3707
  int    OPPMCD08 3708-3711
  int    OPPPRV08 3712-3715
  byte   OPPVA08 3716-3717
  int    OPPTRI08 3718-3720
  byte   OPPOFD08 3721-3722
  byte   OPPSTL08 3723-3724
  int    OPPWCP08 3725-3727
  int    OPPOPR08 3728-3730
  int    OPPOPU08 3731-3733
  int    OPPOSR08 3734-3736
  int    AMCHIR08 3737-3739
  long   AMCTCH08 3740-3744
  long   AMCEXP08 3745-3749
  int    AMCSLF08 3750-3753
  int    AMCMCR08 3754-3757
  int    AMCMCD08 3758-3761
  int    AMCPRV08 3762-3765
  int    AMCVA08 3766-3768
  byte   AMCTRI08 3769-3770
  byte   AMCOFD08 3771-3771
  int    AMCSTL08 3772-3775
  int    AMCWCP08 3776-3779
  long   AMCOPR08 3780-3784
  byte   AMCOPU08 3785-3786
  long   AMCOSR08 3787-3791
  int    AMNURS08 3792-3794
  long   AMNTCH08 3795-3800
  long   AMNEXP08 3801-3806
  int    AMNSLF08 3807-3810
  long   AMNMCR08 3811-3816
  long   AMNMCD08 3817-3821
  long   AMNPRV08 3822-3826
  int    AMNVA08 3827-3830
  int    AMNTRI08 3831-3834
  int    AMNOFD08 3835-3838
  long   AMNSTL08 3839-3843
  int    AMNWCP08 3844-3847
  int    AMNOPR08 3848-3851
  int    AMNOPU08 3852-3855
  int    AMNOSR08 3856-3859
  byte   AMOPTO08 3860-3860
  int    AMETCH08 3861-3864
  int    AMEEXP08 3865-3868
  int    AMESLF08 3869-3872
  int    AMEMCR08 3873-3876
  int    AMEMCD08 3877-3879
  int    AMEPRV08 3880-3882
  int    AMEVA08 3883-3885
  int    AMETRI08 3886-3888
  int    AMEOFD08 3889-3891
  int    AMESTL08 3892-3894
  byte   AMEWCP08 3895-3895
  int    AMEOPR08 3896-3898
  byte   AMEOPU08 3899-3900
  int    AMEOSR08 3901-3903
  byte   AMASST08 3904-3905
  long   AMATCH08 3906-3910
  long   AMAEXP08 3911-3915
  long   AMASLF08 3916-3920
  int    AMAMCR08 3921-3924
  int    AMAMCD08 3925-3928
  int    AMAPRV08 3929-3932
  int    AMAVA08 3933-3936
  int    AMATRI08 3937-3940
  int    AMAOFD08 3941-3944
  int    AMASTL08 3945-3947
  int    AMAWCP08 3948-3951
  int    AMAOPR08 3952-3955
  int    AMAOPU08 3956-3958
  int    AMAOSR08 3959-3962
  byte   AMTHER08 3963-3964
  long   AMTTCH08 3965-3969
  long   AMTEXP08 3970-3974
  int    AMTSLF08 3975-3978
  long   AMTMCR08 3979-3983
  int    AMTMCD08 3984-3987
  long   AMTPRV08 3988-3992
  int    AMTVA08 3993-3996
  int    AMTTRI08 3997-4000
  int    AMTOFD08 4001-4003
  int    AMTSTL08 4004-4007
  long   AMTWCP08 4008-4012
  int    AMTOPR08 4013-4016
  int    AMTOPU08 4017-4020
  int    AMTOSR08 4021-4024
  byte   AMTOTC08 4025-4026
  byte   AMDRC08 4027-4028
  byte   ERTOT08 4029-4030
  long   ERTTCH08 4031-4036
  long   ERTEXP08 4037-4042
  long   ERTSLF08 4043-4047
  long   ERTMCR08 4048-4053
  long   ERTMCD08 4054-4058
  long   ERTPRV08 4059-4063
  long   ERTVA08 4064-4068
  int    ERTTRI08 4069-4072
  int    ERTOFD08 4073-4076
  int    ERTSTL08 4077-4080
  long   ERTWCP08 4081-4085
  long   ERTOPR08 4086-4090
  int    ERTOPU08 4091-4094
  int    ERTOSR08 4095-4098
  long   ERFTCH08 4099-4103
  long   ERFEXP08 4104-4109
  long   ERFSLF08 4110-4114
  long   ERFMCR08 4115-4120
  long   ERFMCD08 4121-4125
  long   ERFPRV08 4126-4130
  long   ERFVA08 4131-4135
  int    ERFTRI08 4136-4139
  int    ERFOFD08 4140-4143
  int    ERFSTL08 4144-4147
  long   ERFWCP08 4148-4152
  long   ERFOPR08 4153-4157
  int    ERFOPU08 4158-4161
  int    ERFOSR08 4162-4165
  int    ERDEXP08 4166-4169
  long   ERDTCH08 4170-4174
  int    ERDSLF08 4175-4178
  int    ERDMCR08 4179-4182
  int    ERDMCD08 4183-4186
  int    ERDPRV08 4187-4190
  int    ERDVA08 4191-4193
  int    ERDTRI08 4194-4196
  byte   ERDOFD08 4197-4198
  int    ERDSTL08 4199-4201
  int    ERDWCP08 4202-4205
  int    ERDOPR08 4206-4209
  int    ERDOPU08 4210-4212
  int    ERDOSR08 4213-4216
  byte   IPZERO08 4217-4217
  long   ZIFTCH08 4218-4222
  long   ZIFEXP08 4223-4227
  int    ZIFSLF08 4228-4231
  long   ZIFMCR08 4232-4236
  long   ZIFMCD08 4237-4241
  long   ZIFPRV08 4242-4246
  int    ZIFVA08 4247-4249
  long   ZIFTRI08 4250-4254
  byte   ZIFOFD08 4255-4255
  byte   ZIFSTL08 4256-4256
  int    ZIFWCP08 4257-4260
  int    ZIFOPR08 4261-4264
  byte   ZIFOPU08 4265-4265
  long   ZIFOSR08 4266-4270
  int    ZIDEXP08 4271-4274
  long   ZIDTCH08 4275-4279
  int    ZIDSLF08 4280-4282
  int    ZIDMCR08 4283-4286
  int    ZIDMCD08 4287-4290
  int    ZIDPRV08 4291-4294
  byte   ZIDVA08 4295-4295
  int    ZIDTRI08 4296-4299
  byte   ZIDOFD08 4300-4301
  byte   ZIDSTL08 4302-4303
  int    ZIDWCP08 4304-4307
  int    ZIDOPR08 4308-4311
  byte   ZIDOPU08 4312-4312
  byte   ZIDOSR08 4313-4313
  byte   IPDIS08 4314-4315
  long   IPTEXP08 4316-4321
  long   IPTTCH08 4322-4328
  long   IPTSLF08 4329-4333
  long   IPTMCR08 4334-4339
  long   IPTMCD08 4340-4345
  long   IPTPRV08 4346-4351
  long   IPTVA08 4352-4357
  long   IPTTRI08 4358-4362
  long   IPTOFD08 4363-4367
  long   IPTSTL08 4368-4372
  long   IPTWCP08 4373-4378
  long   IPTOPR08 4379-4384
  long   IPTOPU08 4385-4389
  long   IPTOSR08 4390-4394
  long   IPFEXP08 4395-4400
  long   IPFTCH08 4401-4407
  long   IPFSLF08 4408-4412
  long   IPFMCR08 4413-4418
  long   IPFMCD08 4419-4424
  long   IPFPRV08 4425-4430
  long   IPFVA08 4431-4436
  long   IPFTRI08 4437-4441
  long   IPFOFD08 4442-4446
  long   IPFSTL08 4447-4451
  long   IPFWCP08 4452-4456
  long   IPFOPR08 4457-4462
  long   IPFOPU08 4463-4467
  long   IPFOSR08 4468-4472
  long   IPDEXP08 4473-4478
  long   IPDTCH08 4479-4484
  int    IPDSLF08 4485-4488
  long   IPDMCR08 4489-4493
  long   IPDMCD08 4494-4499
  long   IPDPRV08 4500-4504
  int    IPDVA08 4505-4508
  int    IPDTRI08 4509-4512
  int    IPDOFD08 4513-4516
  int    IPDSTL08 4517-4520
  long   IPDWCP08 4521-4525
  long   IPDOPR08 4526-4530
  int    IPDOPU08 4531-4534
  int    IPDOSR08 4535-4538
  int    IPNGTD08 4539-4541
  byte   DVTOT08 4542-4543
  long   DVTTCH08 4544-4548
  long   DVTEXP08 4549-4553
  long   DVTSLF08 4554-4558
  int    DVTMCR08 4559-4562
  long   DVTMCD08 4563-4567
  long   DVTPRV08 4568-4572
  int    DVTVA08 4573-4576
  int    DVTTRI08 4577-4580
  int    DVTOFD08 4581-4584
  int    DVTSTL08 4585-4588
  int    DVTWCP08 4589-4591
  int    DVTOPR08 4592-4595
  int    DVTOPU08 4596-4599
  long   DVTOSR08 4600-4604
  byte   DVGEN08 4605-4606
  long   DVGTCH08 4607-4611
  long   DVGEXP08 4612-4616
  long   DVGSLF08 4617-4621
  int    DVGMCR08 4622-4625
  int    DVGMCD08 4626-4629
  long   DVGPRV08 4630-4634
  int    DVGVA08 4635-4638
  int    DVGTRI08 4639-4642
  int    DVGOFD08 4643-4645
  int    DVGSTL08 4646-4649
  int    DVGWCP08 4650-4652
  int    DVGOPR08 4653-4656
  int    DVGOPU08 4657-4660
  int    DVGOSR08 4661-4664
  byte   DVORTH08 4665-4666
  long   DVOTCH08 4667-4671
  long   DVOEXP08 4672-4676
  long   DVOSLF08 4677-4681
  int    DVOMCR08 4682-4684
  long   DVOMCD08 4685-4689
  long   DVOPRV08 4690-4694
  int    DVOVA08 4695-4697
  int    DVOTRI08 4698-4701
  int    DVOOFD08 4702-4705
  byte   DVOSTL08 4706-4706
  byte   DVOWCP08 4707-4707
  int    DVOOPR08 4708-4711
  int    DVOOPU08 4712-4714
  long   DVOOSR08 4715-4719
  int    HHTOTD08 4720-4722
  int    HHAGD08 4723-4725
  long   HHATCH08 4726-4731
  long   HHAEXP08 4732-4736
  long   HHASLF08 4737-4741
  long   HHAMCR08 4742-4746
  long   HHAMCD08 4747-4751
  long   HHAPRV08 4752-4756
  int    HHAVA08 4757-4760
  int    HHATRI08 4761-4764
  long   HHAOFD08 4765-4769
  long   HHASTL08 4770-4774
  byte   HHAWCP08 4775-4775
  int    HHAOPR08 4776-4779
  int    HHAOPU08 4780-4783
  long   HHAOSR08 4784-4788
  int    HHINDD08 4789-4791
  long   HHNTCH08 4792-4796
  long   HHNEXP08 4797-4801
  long   HHNSLF08 4802-4806
  int    HHNMCR08 4807-4810
  long   HHNMCD08 4811-4815
  long   HHNPRV08 4816-4820
  int    HHNVA08 4821-4824
  byte   HHNTRI08 4825-4825
  int    HHNOFD08 4826-4829
  int    HHNSTL08 4830-4833
  int    HHNWCP08 4834-4837
  int    HHNOPR08 4838-4841
  byte   HHNOPU08 4842-4842
  byte   HHNOSR08 4843-4843
  int    HHINFD08 4844-4846
  int    VISEXP08 4847-4850
  int    VISTCH08 4851-4854
  int    VISSLF08 4855-4858
  int    VISMCR08 4859-4861
  int    VISMCD08 4862-4865
  int    VISPRV08 4866-4869
  int    VISVA08 4870-4872
  int    VISTRI08 4873-4875
  int    VISOFD08 4876-4878
  int    VISSTL08 4879-4881
  int    VISWCP08 4882-4884
  int    VISOPR08 4885-4887
  int    VISOPU08 4888-4890
  int    VISOSR08 4891-4893
  long   OTHTCH08 4894-4898
  long   OTHEXP08 4899-4903
  int    OTHSLF08 4904-4907
  int    OTHMCR08 4908-4911
  int    OTHMCD08 4912-4915
  long   OTHPRV08 4916-4920
  int    OTHVA08 4921-4924
  int    OTHTRI08 4925-4928
  int    OTHOFD08 4929-4932
  int    OTHSTL08 4933-4935
  int    OTHWCP08 4936-4939
  int    OTHOPR08 4940-4943
  int    OTHOPU08 4944-4946
  int    OTHOSR08 4947-4949
  int    RXTOT08 4950-4952
  long   RXEXP08 4953-4957
  long   RXSLF08 4958-4962
  long   RXMCR08 4963-4967
  long   RXMCD08 4968-4972
  long   RXPRV08 4973-4977
  long   RXVA08 4978-4982
  long   RXTRI08 4983-4987
  int    RXOFD08 4988-4991
  long   RXSTL08 4992-4996
  long   RXWCP08 4997-5001
  long   RXOPR08 5002-5006
  int    RXOPU08 5007-5010
  int    RXOSR08 5011-5014
  long   TOTPTR08 5015-5020
  long   TOTOTH08 5021-5026
  long   OBVPTR08 5027-5031
  long   OBVOTH08 5032-5036
  long   OBDPTR08 5037-5041
  long   OBDOTH08 5042-5046
  long   OBOPTR08 5047-5051
  long   OBOOTH08 5052-5056
  int    OBCPTR08 5057-5060
  long   OBCOTH08 5061-5065
  long   OBNPTR08 5066-5070
  long   OBNOTH08 5071-5075
  int    OBEPTR08 5076-5078
  int    OBEOTH08 5079-5081
  int    OBAPTR08 5082-5085
  int    OBAOTH08 5086-5089
  long   OBTPTR08 5090-5094
  int    OBTOTH08 5095-5098
  long   OPTPTR08 5099-5103
  long   OPTOTH08 5104-5108
  long   OPFPTR08 5109-5113
  long   OPFOTH08 5114-5118
  int    OPDPTR08 5119-5122
  int    OPDOTH08 5123-5126
  long   OPVPTR08 5127-5131
  long   OPVOTH08 5132-5136
  int    OPSPTR08 5137-5140
  int    OPSOTH08 5141-5144
  long   OPOPTR08 5145-5149
  int    OPOOTH08 5150-5153
  int    OPPPTR08 5154-5157
  int    OPPOTH08 5158-5160
  int    AMCPTR08 5161-5164
  long   AMCOTH08 5165-5169
  long   AMNPTR08 5170-5174
  long   AMNOTH08 5175-5179
  int    AMEPTR08 5180-5182
  int    AMEOTH08 5183-5185
  int    AMAPTR08 5186-5189
  int    AMAOTH08 5190-5193
  long   AMTPTR08 5194-5198
  int    AMTOTH08 5199-5202
  long   ERTPTR08 5203-5207
  long   ERTOTH08 5208-5212
  long   ERFPTR08 5213-5217
  long   ERFOTH08 5218-5222
  int    ERDPTR08 5223-5226
  int    ERDOTH08 5227-5230
  long   ZIFPTR08 5231-5235
  long   ZIFOTH08 5236-5240
  int    ZIDPTR08 5241-5244
  int    ZIDOTH08 5245-5248
  long   IPTPTR08 5249-5254
  long   IPTOTH08 5255-5260
  long   IPFPTR08 5261-5266
  long   IPFOTH08 5267-5272
  long   IPDPTR08 5273-5277
  long   IPDOTH08 5278-5282
  long   DVTPTR08 5283-5287
  long   DVTOTH08 5288-5292
  long   DVGPTR08 5293-5297
  int    DVGOTH08 5298-5301
  long   DVOPTR08 5302-5306
  long   DVOOTH08 5307-5311
  long   HHAPTR08 5312-5316
  long   HHAOTH08 5317-5321
  long   HHNPTR08 5322-5326
  int    HHNOTH08 5327-5330
  int    VISPTR08 5331-5334
  int    VISOTH08 5335-5337
  long   OTHPTR08 5338-5342
  int    OTHOTH08 5343-5346
  long   RXPTR08 5347-5351
  long   RXOTH08 5352-5356
  double PERWT08F 5357-5368
  double FAMWT08F 5369-5380
  double FAMWT08C 5381-5392
  double SAQWT08F 5393-5404
  double DIABW08F 5405-5416
  int    VARSTR 5417-5420
  byte   VARPSU 5421-5421
using H121.dat;

*DEFINE VARIABLE LABELS;
label variable DUID "DWELLING UNIT ID";
label variable PID "PERSON NUMBER";
label variable DUPERSID "PERSID (DUID + PID)";
label variable PANEL "PANEL NUMBER";
label variable FAMID31 "FAMILY ID (STUDENT MERGED IN) - R3/1";
label variable FAMID42 "FAMILY ID (STUDENT MERGED IN) - R4/2";
label variable FAMID53 "FAMILY ID (STUDENT MERGED IN) - R5/3";
label variable FAMID08 "FAMILY ID (STUDENT MERGED IN) - 12/31/08";
label variable FAMIDYR "ANNUAL FAMILY IDENTIFIER";
label variable RULETR31 "RU LETTER - R3/1";
label variable RULETR42 "RU LETTER - R4/2";
label variable RULETR53 "RU LETTER - R5/3";
label variable RULETR08 "RU LETTER AS OF 12/31/08";
label variable RUSIZE31 "RU SIZE - R3/1";
label variable RUSIZE42 "RU SIZE - R4/2";
label variable RUSIZE53 "RU SIZE - R5/3";
label variable RUSIZE08 "RU SIZE AS OF 12/31/08";
label variable RUCLAS31 "RU FIELDED AS:STANDARD/NEW/STUDENT-R3/1";
label variable RUCLAS42 "RU FIELDED AS:STANDARD/NEW/STUDENT-R4/2";
label variable RUCLAS53 "RU FIELDED AS:STANDARD/NEW/STUDENT-R5/3";
label variable RUCLAS08 "RU FIELDED AS:STANDARD/NEW/STUD-12/31/08";
label variable FAMSZE31 "RU SIZE INCLUDING STUDENTS - R3/1";
label variable FAMSZE42 "RU SIZE INCLUDING STUDENTS - R4/2";
label variable FAMSZE53 "RU SIZE INCLUDING STUDENTS - R5/3";
label variable FAMSZE08 "RU SIZE INCLUDING STUDENT AS OF 12/31/08";
label variable FMRS1231 "MEMBER OF RESPONDING 12/31 FAMILY";
label variable FAMS1231 "FAMILY SIZE OF RESPONDING 12/31 FAMILY";
label variable FAMSZEYR "SIZE OF RESPONDING ANNUALIZED FAMILY";
label variable FAMRFPYR "REFERENCE PERSON OF ANNUALIZED FAMILY";
label variable REGION31 "CENSUS REGION - R3/1";
label variable REGION42 "CENSUS REGION - R4/2";
label variable REGION53 "CENSUS REGION - R5/3";
label variable REGION08 "CENSUS REGION AS OF 12/31/08";
label variable MSA31 "MSA STATUS - R3/1";
label variable MSA42 "MSA STATUS - R4/2";
label variable MSA53 "MSA STATUS - R5/3";
label variable MSA08 "MSA AS OF 12/31/08";
label variable REFPRS31 "REFERENCE PERSON AT - R3/1";
label variable REFPRS42 "REFERENCE PERSON AT - R4/2";
label variable REFPRS53 "REFERENCE PERSON AT - R5/3";
label variable REFPRS08 "REFERENCE PERSON AS OF 12/31/08";
label variable RESP31 "1ST RESPONDENT INDICATOR FOR R3/1";
label variable RESP42 "1ST RESPONDENT INDICATOR FOR R4/2";
label variable RESP53 "1ST RESPONDENT INDICATOR FOR R5/3";
label variable RESP08 "1ST RESPONDENT INDICATOR AS OF 12/31/08";
label variable PROXY31 "WAS RESPONDENT A PROXY IN R3/1";
label variable PROXY42 "WAS RESPONDENT A PROXY IN R4/2";
label variable PROXY53 "WAS RESPONDENT A PROXY IN R5/3";
label variable PROXY08 "WAS RESPONDENT A PROXY AS OF 12/31/08";
label variable INTVLANG "LANGUAGE INTERVIEW WAS COMPLETED";
label variable BEGRFD31 "R3/1 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM31 "R3/1 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY31 "R3/1 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD31 "R3/1 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM31 "R3/1 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY31 "R3/1 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD42 "R4/2 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM42 "R4/2 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY42 "R4/2 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD42 "R4/2 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM42 "R4/2 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY42 "R4/2 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD53 "R5/3 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM53 "R5/3 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY53 "R5/3 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD53 "R5/3 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM53 "R5/3 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY53 "R5/3 REFERENCE PERIOD END DATE: YEAR";
label variable ENDRFD08 "2008 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM08 "2008 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY08 "2008 REFERENCE PERIOD END DATE: YEAR";
label variable KEYNESS "PERSON KEY STATUS";
label variable INSCOP31 "INSCOPE - R3/1";
label variable INSCOP42 "INSCOPE - R4/2";
label variable INSCOP53 "INSCOPE - R5/3";
label variable INSCOP08 "INSCOPE - R5/3 START THROUGH 12/31/08";
label variable INSC1231 "INSCOPE STATUS ON 12/31/08";
label variable INSCOPE "WAS PERSON EVER INSCOPE IN 2008";
label variable ELGRND31 "ELIGIBILITY - R3/1";
label variable ELGRND42 "ELIGIBILITY - R4/2";
label variable ELGRND53 "ELIGIBILITY - R5/3";
label variable ELGRND08 "ELIGIBILITY STATUS AS OF 12/31/08";
label variable PSTATS31 "PERSON DISPOSITION STATUS - R3/1";
label variable PSTATS42 "PERSON DISPOSITION STATUS - R4/2";
label variable PSTATS53 "PERSON DISPOSITION STATUS - R5/3";
label variable RURSLT31 "RU RESULT - R3/1";
label variable RURSLT42 "RU RESULT - R4/2";
label variable RURSLT53 "RU RESULT - R5/3";
label variable AGE31X "AGE - R3/1 (EDITED/IMPUTED)";
label variable AGE42X "AGE - R4/2 (EDITED/IMPUTED)";
label variable AGE53X "AGE - R5/3 (EDITED/IMPUTED)";
label variable AGE08X "AGE AS OF 12/31/08 (EDITED/IMPUTED)";
label variable AGELAST "AGE AT END OF REFERENCE PERIOD";
label variable CPSFAMID "CPSFAMID";
label variable HIEUIDX "HIEU IDENTIFIER";
label variable FCSZ1231 "FAM SIZE RESPONDING 12/31 CPS FAMILY";
label variable FCRP1231 "REF PERSON OF 12/31 CPS FAMILY";
label variable DOBMM "DATE OF BIRTH: MONTH";
label variable DOBYY "DATE OF BIRTH: YEAR";
label variable SEX "SEX";
label variable RACEX "RACE (EDITED/IMPUTED)";
label variable RACEAX "ASIAN AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEBX "BLACK AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEWX "WHITE AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACETHNX "RACE/ETHNICITY (EDITED/IMPUTED)";
label variable HISPANX "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable HISPCAT "SPECIFIC HISPANIC ETHNICITY GROUP";
label variable MARRY31X "MARITAL STATUS - R3/1 (EDITED/IMPUTED)";
label variable MARRY42X "MARITAL STATUS - R4/2 (EDITED/IMPUTED)";
label variable MARRY53X "MARITAL STATUS - R5/3 (EDITED/IMPUTED)";
label variable MARRY08X "MARITAL STATUS-12/31/08 (EDITED/IMPUTED)";
label variable SPOUID31 "SPOUSE ID - R3/1";
label variable SPOUID42 "SPOUSE ID - R4/2";
label variable SPOUID53 "SPOUSE ID - R5/3";
label variable SPOUID08 "SPOUSE ID - 12/31/08";
label variable SPOUIN31 "MARITAL STATUS W/SPOUSE PRESENT-R3/1";
label variable SPOUIN42 "MARITAL STATUS W/SPOUSE PRESENT-R4/2";
label variable SPOUIN53 "MARITAL STATUS W/SPOUSE PRESENT-R5/3";
label variable SPOUIN08 "MARITAL STATUS W/SPOUSE PRESENT-12/31/08";
label variable EDUCYR "YEARS OF EDUC WHEN FIRST ENTERED MEPS";
label variable HIDEG "HIGHEST DEGREE WHEN FIRST ENTERED MEPS";
label variable FTSTU31X "STUDENT STATUS IF AGES 17-23 - R3/1";
label variable FTSTU42X "STUDENT STATUS IF AGES 17-23 - R4/2";
label variable FTSTU53X "STUDENT STATUS IF AGES 17-23 - R5/3";
label variable FTSTU08X "STUDENT STATUS IF AGES 17-23 - 12/31/08";
label variable ACTDTY31 "MILITARY FULL-TIME ACTIVE DUTY - R3/1";
label variable ACTDTY42 "MILITARY FULL-TIME ACTIVE DUTY - R4/2";
label variable ACTDTY53 "MILITARY FULL-TIME ACTIVE DUTY - R5/3";
label variable HONRDC31 "HONORABLY DISCHARGED FROM MILITARY";
label variable HONRDC42 "HONORABLY DISCHARGED FROM MILITARY";
label variable HONRDC53 "HONORABLY DISCHARGED FROM MILITARY";
label variable RFREL31X "RELATION TO REF PERS-R3/1 (EDIT/IMP)";
label variable RFREL42X "RELATION TO REF PERS-R4/2 (EDIT/IMP)";
label variable RFREL53X "RELATION TO REF PERS-R5/3 (EDIT/IMP)";
label variable RFREL08X "RELATION TO REF PERS-12/31/08 (EDIT/IMP)";
label variable MOPID31X "PID OF PERSON S MOM - RD 3/1";
label variable MOPID42X "PID OF PERSON S MOM - RD 4/2";
label variable MOPID53X "PID OF PERSON S MOM - RD 5/3";
label variable DAPID31X "PID OF PERSON S DAD - RD 3/1";
label variable DAPID42X "PID OF PERSON S DAD - RD 4/2";
label variable DAPID53X "PID OF PERSON S DAD - RD 5/3";
label variable SSIDIS08 "SSI RECEIPT DUE TO DISABILITY";
label variable AFDC08 "DID PERSON S CHECK INCLUDE TANF";
label variable FILEDR08 "HAS PERSON FILED A FED INCOME TAX RETURN";
label variable WILFIL08 "WILL PERSON FILE FED INCOME TAX RETURN";
label variable FLSTAT08 "PERSON S FILING STATUS";
label variable FILER08 "PRIMARY OR SECONDARY FILER";
label variable JTINRU08 "JOINT FILER S MEMBERSHIP IN RU";
label variable JNTPID08 "PID OF SECONDARY FILER";
label variable CLMDEP08 "DID/WILL PERS CLAIM DEPENDENTS ON RETURN";
label variable DEPDNT08 "PERSON IS FLAGGED A DEPENDENT";
label variable DPINRU08 "DEPENDENTS IN/OUT OF RU";
label variable DPOTSD08 "HOW MANY DEPENDENTS LIVE OUTSIDE RU";
label variable TAXFRM08 "TAX FORM PERSON WILL FILE";
label variable DEDUCT08 "ITEMIZE OR STANDARD DEDUCTION";
label variable TOTDED08 "TOTAL OF ALL ITEMIZED DEDUCTIONS";
label variable CLMHIP08 "DID/WILL PERS DEDUCT HEALTH INSUR. PREM.";
label variable EICRDT08 "DID/WILL PERS RECEIVE EARNED INC CREDIT";
label variable FOODST08 "DID ANYONE PURCHASE FOOD STAMPS";
label variable FOODMN08 "NUMBER OF MONTHS FOOD STAMPS PURCHASED";
label variable FOODVL08 "MONTHLY VALUE OF FOOD STAMPS";
label variable TTLP08X "PERSON S TOTAL INCOME";
label variable FAMINC08 "FAMILY S TOTAL INCOME";
label variable POVCAT08 "FAMILY INC AS % POVERTY LINE-CATEGORICAL";
label variable POVLEV08 "FAMILY INC AS % POVERTY LINE-CONTINUOUS";
label variable WAGEP08X "PERSON S WAGE INCOME";
label variable WAGIMP08 "WAGE IMPUTATION FLAG";
label variable BUSNP08X "PERSON S BUSINESS INCOME";
label variable BUSIMP08 "BUSINESS INCOME IMPUTATION FLAG";
label variable UNEMP08X "PERSON S UNEMPLOYMENT COMP INCOME";
label variable UNEIMP08 "UNEMPLOYMENT IMPUTATION FLAG";
label variable WCMPP08X "PERSON S WORKERS  COMPENSATION";
label variable WCPIMP08 "WORKER S COMP IMPUTATION FLAG";
label variable INTRP08X "PERSON S INTEREST INCOME";
label variable INTIMP08 "INTEREST INCOME IMPUTATION FLAG";
label variable DIVDP08X "PERSON S DIVIDEND INCOME";
label variable DIVIMP08 "DIVIDEND INCOME IMPUTATION FLAG";
label variable SALEP08X "PERSON S SALES INCOME";
label variable SALIMP08 "SALES INCOME IMPUTATION FLAG";
label variable PENSP08X "PERSON S PENSION INCOME";
label variable PENIMP08 "PENSION INCOME IMPUTATION FLAG";
label variable SSECP08X "PERSON S SOCIAL SECURITY INCOME";
label variable SSCIMP08 "SOCIAL SECURITY INCOME IMPUTATION FLAG";
label variable TRSTP08X "PERSON S TRUST/RENT INCOME";
label variable TRTIMP08 "TRUST INCOME IMPUTATION FLAG";
label variable VETSP08X "PERSON S VETERAN S INCOME";
label variable VETIMP08 "VETERAN S INCOME IMPUTATION FLAG";
label variable IRASP08X "PERSON S IRA INCOME";
label variable IRAIMP08 "IRA INCOME IMPUTATION FLAG";
label variable REFDP08X "PERSON S REFUND INCOME";
label variable REFIMP08 "REFUND INCOME IMPUTATION FLAG";
label variable ALIMP08X "PERSON S ALIMONY INCOME";
label variable ALIIMP08 "ALIMONY INCOME IMPUTATION FLAG";
label variable CHLDP08X "PERSON S CHILD SUPPORT";
label variable CHLIMP08 "CHILD SUPPORT IMPUTATION FLAG";
label variable CASHP08X "PERSON S OTHER REGULAR CASH CONTRIBUTION";
label variable CSHIMP08 "CASH CONTRIBUTION IMPUTATION FLAG";
label variable SSIP08X "PERSON S SSI";
label variable SSIIMP08 "SSI IMPUTATION FLAG";
label variable PUBP08X "PERSON S PUBLIC ASSISTANCE";
label variable PUBIMP08 "PUBLIC ASSISTANCE IMPUTATION FLAG";
label variable OTHRP08X "PERSON S OTHER INCOME";
label variable OTHIMP08 "OTHER INCOME IMPUTATION FLAG";
label variable RTHLTH31 "PERCEIVED HEALTH STATUS - RD 3/1";
label variable RTHLTH42 "PERCEIVED HEALTH STATUS - RD 4/2";
label variable RTHLTH53 "PERCEIVED HEALTH STATUS - RD 5/3";
label variable MNHLTH31 "PERCEIVED MENTAL HEALTH STATUS - RD 3/1";
label variable MNHLTH42 "PERCEIVED MENTAL HEALTH STATUS - RD 4/2";
label variable MNHLTH53 "PERCEIVED MENTAL HEALTH STATUS - RD 5/3";
label variable PREGNT31 "PREGNANT DURING REF PERIOD - RD 3/1";
label variable PREGNT42 "PREGNANT DURING REF PERIOD - RD 4/2";
label variable PREGNT53 "PREGNANT DURING REF PERIOD - RD 5/3";
label variable HIBPDX "HIGH BLOOD PRESSURE DIAG (>17)";
label variable HIBPAGED "AGE OF DIAGNOSIS-HIGH BLOOD PRESSURE";
label variable BPMLDX "MULT DIAG HIGH BLOOD PRESS (>17)";
label variable CHDDX "CORONARY HRT DISEASE DIAG (>17)";
label variable CHDAGED "AGE OF DIAGNOSIS-CORONARY HEART";
label variable ANGIDX "ANGINA DIAGNOSIS (>17)";
label variable ANGIAGED "AGE OF DIAGNOSIS-ANGINA";
label variable MIDX "HEART ATTACK (MI) DIAG (>17)";
label variable MIAGED "AGE OF DIAGNOSIS-HEART ATTACK(MI)";
label variable OHRTDX "OTHER HEART DISEASE DIAG (>17)";
label variable OHRTAGED "AGE OF DIAGNOSIS-OTHER HEART DISEASE";
label variable STRKDX "STROKE DIAGNOSIS (>17)";
label variable STRKAGED "AGE OF DIAGNOSIS-STROKE";
label variable EMPHDX "EMPHYSEMA DIAGNOSIS (>17)";
label variable EMPHAGED "AGE OF DIAGNOSIS-EMPHYSEMA";
label variable CHBRON31 "CHRONC BRONCHITS LAST 12 MTHS (>17)-R3/1";
label variable CHBRON53 "CHRONC BRONCHITS LAST 12 MTHS (>17)-R5/3";
label variable CHOLDX "HIGH CHOLESTEROL DIAGNOSIS (>17)";
label variable CHOLAGED "AGE OF DIAGNOSIS-HIGH CHOLESTEROL";
label variable CANCERDX "CANCER DIAGNOSIS (>17)";
label variable CABLADDR "CANCER DIAGNOSED - BLADDER (>17)";
label variable BLDRAGED "AGE OF DIAGNOSIS-BLADDER CANCER";
label variable BLDRREMS "BLADDER CANCER IN REMISSION";
label variable CABLOOD "CANCER DIAGNOSED - BLOOD (>17)";
label variable BLODAGED "AGE OF DIAGNOSIS-BLOOD CANCER";
label variable BLODREMS "BLOOD CANCER IN REMISSION";
label variable CABONE "CANCER DIAGNOSED - BONE (>17)";
label variable BONEAGED "AGE OF DIAGNOSIS-BONE CANCER";
label variable BONEREMS "BONE CANCER IN REMISSION";
label variable CABRAIN "CANCER DIAGNOSED - BRAIN (>17)";
label variable BRAIAGED "AGE OF DIAGNOSIS-BRAIN CANCER";
label variable BRAIREMS "BRAIN CANCER IN REMISSION";
label variable CABREAST "CANCER DIAGNOSED - BREAST (>17)";
label variable BRSTAGED "AGE OF DIAGNOSIS-BREAST CANCER";
label variable BRSTREMS "BREAST CANCER IN REMISSION";
label variable CACERVIX "CANCER DIAGNOSED - CERVIX (>17)";
label variable CERVAGED "AGE OF DIAGNOSIS-CERVICAL CANCER";
label variable CERVREMS "CERVICAL CANCER IN REMISSION";
label variable CACOLON "CANCER DIAGNOSED - COLON (>17)";
label variable COLOAGED "AGE OF DIAGNOSIS-COLON CANCER";
label variable COLOREMS "COLON CANCER IN REMISSION";
label variable CAKIDNEY "CANCER DIAGNOSED - KIDNEY (>17)";
label variable KIDNAGED "AGE OF DIAGNOSIS-RENAL CANCER";
label variable KIDNREMS "RENAL CANCER IN REMISSION";
label variable CALARYNX "CANCER DIAGNOSED - LARYNX (>17)";
label variable LRNXAGED "AGE OF DIAGNOSIS-LARYNGEAL CANCER";
label variable LRNXREMS "LARYNGEAL CANCER IN REMISSION";
label variable CALEUKEM "CANCER DIAGNOSED - LEUKEMIA (>17)";
label variable LEUKAGED "AGE OF DIAGNOSIS-LEUKEMIA";
label variable LEUKREMS "LEUKEMIA IN REMISSION";
label variable CALIVER "CANCER DIAGNOSED - LIVER (>17)";
label variable LIVRAGED "AGE OF DIAGNOSIS-LIVER CANCER";
label variable LIVRREMS "LIVER CANCER IN REMISSION";
label variable CALUNG "CANCER DIAGNOSED - LUNG (>17)";
label variable LUNGAGED "AGE OF DIAGNOSIS-LUNG CANCER";
label variable LUNGREMS "LUNG CANCER IN REMISSION";
label variable CALYMPH "CANCER DIAGNOSED - LYMPHOMA (>17)";
label variable LYMPAGED "AGE OF DIAGNOSIS-LYMPHOMA";
label variable LYMPREMS "LYMPHOMA IN REMISSION";
label variable CAMELANO "CANCER DIAGNOSED - MELANOMA (>17)";
label variable MELAAGED "AGE OF DIAGNOSIS-MELANOMA";
label variable MELAREMS "MELANOMA IN REMISSION";
label variable CAMOUTH "CANCER DIAGNOSED - MOUTH/LIP/TONGE (>17)";
label variable MOUTAGED "AGE OF DIAGNOSIS-MOUTH/LIP/TONGUE";
label variable MOUTREMS "MOUTH/TONGUE/LIP CANCER IN REMISSION";
label variable CAMUSCLE "CANCER DIAGNOSED - SOFTTISS/MUSC/FAT (>17)";
label variable MUSCAGED "AGE OF DIAGNOSIS-SFTTISS/MUSC/FAT CANCER";
label variable MUSCREMS "SFT TISS/MUSC/FAT CANCER IN REMISSION";
label variable CAOVARY "CANCER DIAGNOSED - OVARY (>17)";
label variable OVRYAGED "AGE OF DIAGNOSIS-OVARIAN CANCER";
label variable OVRYREMS "OVARIAN CANCER IN REMISSION";
label variable CAPANCRS "CANCER DIAGNOSED - PANCREAS (>17)";
label variable PANCAGED "AGE OF DIAGNOSIS-PANCREATIC CANCER";
label variable PANCREMS "PANCREATIC CANCER IN REMISSION";
label variable CAPROSTA "CANCER DIAGNOSED - PROSTATE (>17)";
label variable PRSTAGED "AGE OF DIAGNOSIS-PROSTATE CANCER";
label variable PRSTREMS "PROSTATE CANCER IN REMISSION";
label variable CARECTUM "CANCER DIAGNOSED - RECTUM (>17)";
label variable RECTAGED "AGE OF DIAGNOSIS-RECTAL CANCER";
label variable RECTREMS "RECTAL CANCER IN REMISSION";
label variable CASKINDK "CANCER DIAGNOSED - SKIN-DKKIND (>17)";
label variable SKDKAGED "AGE OF DIAGNOSIS-SKIN-UNKNWN TYPE CANCER";
label variable SKDKREMS "SKIN-UNKNOWN TYPE CANCER IN REMISSION";
label variable CASKINNM "CANCER DIAGNOSED - SKIN-NONMELANO (>17)";
label variable SKNMAGED "AGE OF DIAGNOSIS-SKIN-NONMELANOMA CANCER";
label variable SKNMREMS "SKIN-NONMELANOMA CANCER IN REMISSION";
label variable CASTOMCH "CANCER DIAGNOSED - STOMACH (>17)";
label variable STOMAGED "AGE OF DIAGNOSIS-STOMACH CANCER";
label variable STOMREMS "STOMACH CANCER IN REMISSION";
label variable CATESTIS "CANCER DIAGNOSED - TESTIS (>17)";
label variable TSTSAGED "AGE OF DIAGNOSIS-TESTICULAR CANCER";
label variable TSTSREMS "TESTICULAR CANCER IN REMISSION";
label variable CATHROAT "CANCER DIAGNOSED - THROAT (>17)";
label variable THRTAGED "AGE OF DIAGNOSIS-THROAT CANCER";
label variable THRTREMS "THROAT CANCER IN REMISSION";
label variable CATHYROD "CANCER DIAGNOSED - THYROID (>17)";
label variable THYRAGED "AGE OF DIAGNOSIS-THYROID CANCER";
label variable THYRREMS "THYROID CANCER IN REMISSION";
label variable CAUTERUS "CANCER DIAGNOSED - UTERUS (>17)";
label variable UTERAGED "AGE OF DIAGNOSIS-UTERINE CANCER";
label variable UTERREMS "UTERINE CANCER IN REMISSION";
label variable CAOTHER "CANCER DIAGNOSED - OTHER (>17)";
label variable OTHRAGED "AGE OF DIAGNOSIS-OTHER CANCER";
label variable OTHRREMS "OTHER CANCER IN REMISSION";
label variable DIABDX "DIABETES DIAGNOSIS (>17)";
label variable DIABAGED "AGE OF DIAGNOSIS-DIABETES";
label variable JTPAIN31 "JOINT PAIN LAST 12 MONTHS (>17) - RD 3/1";
label variable JTPAIN53 "JOINT PAIN LAST 12 MONTHS (>17) - RD 5/3";
label variable ARTHDX "ARTHRITIS DIAGNOSIS (>17)";
label variable ARTHAGED "AGE OF DIAGNOSIS-ARTHRITIS";
label variable ARTHTYPE "TYPE OF ARTHRITIS DIAGNOSED (>17)";
label variable ASTHDX "ASTHMA DIAGNOSIS";
label variable ASTHAGED "AGE OF DIAGNOSIS-ASTHMA";
label variable ASSTIL31 "DOES PERSON STILL HAVE ASTHMA-RD3/1";
label variable ASSTIL53 "DOES PERSON STILL HAVE ASTHMA - RD 5/3";
label variable ASATAK31 "ASTHMA ATTACK LAST 12 MOS - RD3/1";
label variable ASATAK53 "ASTHMA ATTACK LAST 12 MOS - RD 5/3";
label variable ASTHEP31 "WHEN WAS LAST EPISODE OF ASTHMA - RD 3/1";
label variable ASTHEP53 "WHEN WAS LAST EPISODE OF ASTHMA - RD 5/3";
label variable ASACUT53 "USED ACUTE PRES INHALER LAST 3 MOS-RD5/3";
label variable ASMRCN53 "USED>3ACUTE CN PRES INH LAST 3 MOS-RD5/3";
label variable ASPREV53 "EVER USED PREV DAILY ASTHMA MEDS -RD 5/3";
label variable ASDALY53 "NOW TAKE PREV DAILY ASTHMA MEDS - RD 5/3";
label variable ASPKFL53 "HAVE PEAK FLOW METER AT HOME - RD 5/3";
label variable ASEVFL53 "EVER USED PEAK FLOW METER - RD 5/3";
label variable ASWNFL53 "WHEN LAST USED PEAK FLOW METER - RD 5/3";
label variable ADHDADDX "ADHDADD DIAGNOSIS (5-17)";
label variable ADHDAGED "AGE OF DIAGNOSIS-ADHD/ADD";
label variable IADLHP31 "IADL SCREENER - RD 3/1";
label variable IADLHP42 "IADL SCREENER - RD 4/2";
label variable IADLHP53 "IADL SCREENER - RD 5/3";
label variable IADL3M31 "IADL HELP 3+ MONTHS - RD 3/1";
label variable IADL3M42 "IADL HELP 3+ MONTHS - RD 4/2";
label variable IADL3M53 "IADL HELP 3+ MONTHS - RD 5/3";
label variable ADLHLP31 "ADL SCREENER - RD 3/1";
label variable ADLHLP42 "ADL SCREENER - RD 4/2";
label variable ADLHLP53 "ADL SCREENER - RD 5/3";
label variable ADL3MO31 "ADL HELP 3+ MONTHS - RD 3/1";
label variable ADL3MO42 "ADL HELP 3+ MONTHS - RD 4/2";
label variable ADL3MO53 "ADL HELP 3+ MONTHS - RD 5/3";
label variable AIDHLP31 "USED ASSISTIVE DEVICES - RD 3/1";
label variable AIDHLP53 "USED ASSISTIVE DEVICES - RD 5/3";
label variable WLKLIM31 "LIMITATION IN PHYSICAL FUNCTIONING-RD3/1";
label variable WLKLIM53 "LIMITATION IN PHYSICAL FUNCTIONING-RD5/3";
label variable LFTDIF31 "DIFFICULTY LIFTING 10 POUNDS - RD 3/1";
label variable LFTDIF53 "DIFFICULTY LIFTING 10 POUNDS - RD 5/3";
label variable STPDIF31 "DIFFICULTY WALKING UP 10 STEPS - RD 3/1";
label variable STPDIF53 "DIFFICULTY WALKING UP 10 STEPS - RD 5/3";
label variable WLKDIF31 "DIFFICULTY WALKING 3 BLOCKS - RD 3/1";
label variable WLKDIF53 "DIFFICULTY WALKING 3 BLOCKS - RD 5/3";
label variable MILDIF31 "DIFFICULTY WALKING A MILE - RD 3/1";
label variable MILDIF53 "DIFFICULTY WALKING A MILE - RD 5/3";
label variable STNDIF31 "DIFFICULTY STANDING 20 MINUTES - RD 3/1";
label variable STNDIF53 "DIFFICULTY STANDING 20 MINUTES - RD 5/3";
label variable BENDIF31 "DIFFICULTY BENDING/STOOPING - RD 3/1";
label variable BENDIF53 "DIFFICULTY BENDING/STOOPING - RD 5/3";
label variable RCHDIF31 "DIFFICULTY REACHING OVERHEAD - RD 3/1";
label variable RCHDIF53 "DIFFICULTY REACHING OVERHEAD - RD 5/3";
label variable FNGRDF31 "DIFFICULTY USING FINGERS TO GRASP-RD 3/1";
label variable FNGRDF53 "DIFFICULTY USING FINGERS TO GRASP-RD 5/3";
label variable WLK3MO31 "PHYS FUNCTIONING HELP 3+ MONTHS - RD 3/1";
label variable WLK3MO53 "PHYS FUNCTIONING HELP 3+ MONTHS - RD 5/3";
label variable ACTLIM31 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 3/1";
label variable ACTLIM53 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 5/3";
label variable WRKLIM31 "WORK LIMITATION - RD 3/1";
label variable WRKLIM53 "WORK LIMITATION - RD 5/3";
label variable HSELIM31 "HOUSEWORK LIMITATION - RD 3/1";
label variable HSELIM53 "HOUSEWORK LIMITATION - RD 5/3";
label variable SCHLIM31 "SCHOOL LIMITATION - RD 3/1";
label variable SCHLIM53 "SCHOOL LIMITATION - RD 5/3";
label variable UNABLE31 "COMPLETELY UNABLE TO DO ACTIVITY-RD 3/1";
label variable UNABLE53 "COMPLETELY UNABLE TO DO ACTIVITY-RD 5/3";
label variable SOCLIM31 "SOCIAL LIMITATIONS - RD 3/1";
label variable SOCLIM53 "SOCIAL LIMITATIONS - RD 5/3";
label variable COGLIM31 "COGNITIVE LIMITATIONS - RD 3/1";
label variable COGLIM53 "COGNITIVE LIMITATIONS - RD 5/3";
label variable WRGLAS42 "WEARS EYEGLASSES OR CONTACTS - RD 4/2";
label variable SEEDIF42 "DIFFCLTY SEEING W/GLASSES/CNTCTS-RD 4/2";
label variable BLIND42 "PERSON IS BLIND - RD 4/2";
label variable READNW42 "CAN READ NEWSPRNT W/GLASSES/CNTCTS-RD4/2";
label variable RECPEP42 "CAN RECGNZE PEOPLE W/GLASSES/CNTCTS-R4/2";
label variable VISION42 "VISION IMPAIRMENT (SUMMARY) - RD 4/2";
label variable HEARAD42 "PERSON WEARS HEARING AID - RD 4/2";
label variable HEARDI42 "ANY DIFFCLTY HEARING W/HEARING AID-RD4/2";
label variable DEAF42 "PERSON IS DEAF - RD 4/2";
label variable HEARMO42 "CAN HEAR MOST CONVERSATION - RD 4/2";
label variable HEARSM42 "CAN HEAR SOME CONVERSATION - RD 4/2";
label variable HEARNG42 "HEARING IMPAIRMENT (SUMMARY) - RD 4/2";
label variable ANYLIM08 "ANY LIMITATION IN P12R3,4,5/P13R1,2,3";
label variable LSHLTH42 "LESS HEALTHY THAN OTHR CHILD (0-17)-R4/2";
label variable NEVILL42 "NEVER BEEN SERIOUSLY ILL (0-17)-R4/2";
label variable SICEAS42 "CHILD GETS SICK EASILY (0-17)-R4/2";
label variable HLTHLF42 "CHILD WILL HAVE HEALTHY LIFE (0-17)-R4/2";
label variable WRHLTH42 "WORRY MORE ABOUT HEALTH (0-17)-R4/2";
label variable CHPMED42 "CSHCN:CHILD NEEDS PRESCRB MED(0-17)-R4/2";
label variable CHPMHB42 "CSHCN:PMED FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHPMCN42 "CSHCN:PMED COND LAST 12+ MOS (0-17)-R4/2";
label variable CHSERV42 "CSHCN:CHLD NEEDS MED&OTH SERV(0-17)-R4/2";
label variable CHSRHB42 "CSHCN:SERV FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHSRCN42 "CSHCN:SERV COND LAST 12+ MOS (0-17)-R4/2";
label variable CHLIMI42 "CSHCN:LIMITED IN ANY WAY (0-17)-R4/2";
label variable CHLIHB42 "CSHCN:LIMT FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHLICO42 "CSHCN:LIMIT COND LAST 12+MOS (0-17)-R4/2";
label variable CHTHER42 "CSHCN:CHLD NEEDS SPEC THERAPY(0-17)-R4/2";
label variable CHTHHB42 "CSHCN:SPEC THER FOR HLTH+COND(0-17)-R4/2";
label variable CHTHCO42 "CSHCN:THER COND LAST 12+ MOS (0-17)-R4/2";
label variable CHCOUN42 "CSHCN:CHILD NEEDS COUNSELING (0-17)-R4/2";
label variable CHEMPB42 "CSHCN:COUNS PROB LAST 12+MOS (0-17)-R4/2";
label variable CSHCN42 "CSHCN:CHILD W/SPEC HC NEEDS (0-17)-R4/2";
label variable MOMPRO42 "PROBLEM GETTING ALONG W/MOM (5-17)-R4/2";
label variable DADPRO42 "PROBLEM GETTING ALONG W/DAD (5-17)-R4/2";
label variable UNHAP42 "PROBLEM FEELING UNHAPPY/SAD (5-17)-R4/2";
label variable SCHLBH42 "PROBLEM BEHAVIOR AT SCHOOL (5-17)-R4/2";
label variable HAVFUN42 "PROBLEM HAVING FUN (5-17) - R4/2";
label variable ADUPRO42 "PRBLM GETTING ALONG W/ADULTS (5-17)-R4/2";
label variable NERVAF42 "PRBLM FEELING NERVOUS/AFRAID (5-17)-R4/2";
label variable SIBPRO42 "PRBLM GETTING ALONG W/SIBS (5-17)-R4/2";
label variable KIDPRO42 "PRBLM GETTING ALONG W/KIDS (5-17)-R4/2";
label variable SPRPRO42 "PROBLEM W/SPORTS/HOBBIES (5-17)-R4/2";
label variable SCHPRO42 "PROBLEM WITH SCHOOLWORK (5-17)-R4/2";
label variable HOMEBH42 "PROBLEM W/BEHAVIOR AT HOME (5-17)-R4/2";
label variable TRBLE42 "PRBLM STAY OUT OF TROUBLE (5-17)-R4/2";
label variable CHILCR42 "CAHPS:12MOS:ILL/INJ NEED CARE(0-17)-R4/2";
label variable CHILWW42 "CAHPS:12MOS:ILL CARE WHN WNTD(0-17)-R4/2";
label variable CHRTCR42 "CAHPS:12MOS:MAKE ROUT CARE APT(0-17)R4/2";
label variable CHRTWW42 "CAHPS:12MOS:ROUT APT WHN WNTD(0-17)-R4/2";
label variable CHAPPT42 "CAHPS:12MOS:# OF OFF/CLIN APTS(0-17)R4/2";
label variable CHNDCR42 "CAHPS:12MOS:NEED ANY CARE/TRT(0-17)-R4/2";
label variable CHENEC42 "CAHPS:12MOS:EASY GET NEC CARE (0-17)R4/2";
label variable CHLIST42 "CAHPS:12MOS:CHLD DR LSN TO YOU(0-17)R4/2";
label variable CHEXPL42 "CAHPS:12MOS:CHLD DR EXPL THNG(0-17)R4/2";
label variable CHRESP42 "CAHPS:12MOS:CHLD S DR SHW RESP(0-17)R4/2";
label variable CHPRTM42 "CAHPS:12MOS:CHILD DR ENGH TIME(0-17)R4/2";
label variable CHHECR42 "CAHPS:12MOS:RATE CHLD HLT CARE(0-17)R4/2";
label variable CHSPEC42 "CAHPS:12MOS:CHLD NEEDED SPEC(0-17)R4/2";
label variable CHEYRE42 "CAHPS:12MOS:ESY W/RFR TO SPEC(0-17)-R4/2";
label variable MESHGT42 "DOCTOR EVER MEASURED HEIGHT (0-17)-R4/2";
label variable WHNHGT42 "WHEN DOCTOR MEASURED HEIGHT (0-17)-R4/2";
label variable MESWGT42 "DOCTOR EVER MEASURED WEIGHT (0-17)-R4/2";
label variable WHNWGT42 "WHEN DOCTOR MEASURED WEIGHT (0-17)-R4/2";
label variable CHBMIX42 "CHILD S BODY MASS INDEX (6-17)-R4/2";
label variable MESVIS42 "DOCTOR CHECKED CHILD S VISION (3-6)-R4/2";
label variable MESBPR42 "DR CHECKED BLOOD PRESSURE (2-17)-R4/2";
label variable WHNBPR42 "WHEN DR CHECKED BLOOD PRESS (2-17)-R4/2";
label variable DENTAL42 "DR ADVISE REG DENTAL CHECKUP (2-17)-R4/2";
label variable WHNDEN42 "WHEN DR ADVISE DENT CHECKUP (2-17)-R4/2";
label variable EATHLT42 "DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable WHNEAT42 "WHEN DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable PHYSCL42 "DR ADVISE EXERCISE (2-17)-R4/2";
label variable WHNPHY42 "WHEN DR ADVISE EXERCISE (2-17)-R4/2";
label variable SAFEST42 "DR ADVISE CHLD SAFETY SEAT (WT<=40)-R4/2";
label variable WHNSAF42 "WHEN DR ADVISE SAFETY SEAT (WT<=40)-R4/2";
label variable BOOST42 "DR ADVISE BOOSTER SEAT (40<WT<=80)-R4/2";
label variable WHNBST42 "WHN DR ADVISE BOOST SEAT(40<WT<=80)-R4/2";
label variable LAPBLT42 "DR ADVISE LAP/SHOULDER BELT (80<WT)-R4/2";
label variable WHNLAP42 "WHN DR ADVISE LAP/SHLDR BLT (80<WT)-R4/2";
label variable HELMET42 "DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable WHNHEL42 "WHEN DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable NOSMOK42 "DR ADVISE SMKG IN HOME IS BAD(0-17)-R4/2";
label variable WHNSMK42 "WHN DR ADVIS SMKG IN HOME BAD(0-17)-R4/2";
label variable TIMALN42 "DOCTOR SPEND ANY TIME ALONE (12-17)-R4/2";
label variable DENTCK53 "HOW OFTEN DENTAL CHECK-UP - RD 5/3";
label variable BPCHEK53 "TIME SNCE LST BLOOD PRES CHK (>17)-RD5/3";
label variable BPMONT53 "# MOS SNCE LST BLOOD PRES CHK (>17)-R5/3";
label variable CHOLCK53 "HOW LNG CHOLEST LST CHCK (>17) - RD 5/3";
label variable CHECK53 "HOW LNG LST ROUTNE CHECKUP (>17)-RD 5/3";
label variable NOFAT53 "RESTRICT HGH FAT/CHOLES FOOD (>17)-RD5/3";
label variable EXRCIS53 "ADVISED TO EXERCISE MORE (>17) - RD 5/3";
label variable FLUSHT53 "HOW LNG LAST FLU VACINATION (>17)-RD 5/3";
label variable ASPRIN53 "TKE ASPIRN EVERY (OTHR) DAY (>17)-RD 5/3";
label variable NOASPR53 "TAKING ASPIRIN UNSAFE (>17) - RD 5/3";
label variable STOMCH53 "TKE ASPRN UNSAFE B/C STOMCH (>17)-RD 5/3";
label variable LSTETH53 "LOST ALL UPPR AND LOWR TEETH (>17)-RD5/3";
label variable PSA53 "HOW LONG SINCE LAST PSA (>39) - RD 5/3";
label variable HYSTER53 "HAD A HYSTERECTOMY (>17) - RD 5/3";
label variable PAPSMR53 "HOW LNG LST PAP SMEAR TST (>17) - RD 5/3";
label variable BRSTEX53 "HOW LNG SNCE LST BREAST EXAM (>17)-RD5/3";
label variable MAMOGR53 "HOW LNG SNCE LST MAMMOGRAM (>29) - RD5/3";
label variable STOOL53 "BLD STOOL TST KIT/CRDS HOME (>17)-RD5/3";
label variable WHENST53 "WHN LST BLD STOOL TST HME KIT (>17)-R5/3";
label variable BOWEL53 "SIGMOIDOSCOPY/COLONOSCOPY (>17) - RD 5/3";
label variable WHNBWL53 "LST SIGMOIDOSCOP/COLONOSCOP (>17)-RD 5/3";
label variable PHYACT53 "MOD/VIG PHYS ACTIV 3X WK (>17) - RD 5/3";
label variable BMINDX53 "ADULT BODY MASS INDEX (>17) - RD 5/3";
label variable SEATBE53 "WEARS SEAT BELT (>15) - RD 5/3";
label variable SAQELIG "ELIGIBILITY STATUS FOR SAQ";
label variable ADPRX42 "SAQ: RELATIONSHIP OF PROXY TO ADULT";
label variable ADILCR42 "SAQ 12MOS: ILL/INJURY NEEDING IMMED CARE";
label variable ADILWW42 "SAQ 12 MOS: GOT CARE WHEN NEEDED ILL/INJ";
label variable ADRTCR42 "SAQ 12 MOS: MADE APPT ROUTINE MED CARE";
label variable ADRTWW42 "SAQ 12 MOS: GOT MED APPT WHEN WANTED";
label variable ADAPPT42 "SAQ 12 MOS: # VISITS TO MED OFF FOR CARE";
label variable ADNDCR42 "SAQ 12MOS: NEED ANY CARE, TEST, TREATMNT";
label variable ADEGMC42 "SAQ 12MOS: EASY GETTING NEEDED MED CARE";
label variable ADLIST42 "SAQ 12 MOS: DOCTOR LISTENED TO YOU";
label variable ADEXPL42 "SAQ 12 MOS: DOC EXPLAINED SO UNDERSTOOD";
label variable ADRESP42 "SAQ 12 MOS: DR SHOWED RESPECT";
label variable ADPRTM42 "SAQ 12 MOS: DR SPENT ENUF TIME WITH YOU";
label variable ADHECR42 "SAQ 12 MOS: RATING OF HEALTH CARE";
label variable ADSMOK42 "SAQ: CURRENTLY SMOKE";
label variable ADNSMK42 "SAQ 12MOS: DR ADVISED TO QUIT SMOKING";
label variable ADDRBP42 "SAQ 2 YRS: DR CHECKED BLOOD PRESSURE";
label variable ADSPEC42 "SAQ 12 MOS: NEEDED TO SEE SPECIALIST";
label variable ADSPRF42 "SAQ 12MOS: HOW ESY GETTING SPEC REFERRAL";
label variable ADGENH42 "SAQ: HEALTH IN GENERAL SF-12V2";
label variable ADDAYA42 "SAQ: HLTH LIMITS MOD ACTIVITIES SF-12V2";
label variable ADCLIM42 "SAQ: HLTH LIMITS CLIMBING STAIRS SF-12V2";
label variable ADPALS42 "SAQ 4WKS:ACCMP LESS B/C PHY PRBS SF-12V2";
label variable ADPWLM42 "SAQ 4WKS:WORK LIMT B/C PHY PROBS SF-12V2";
label variable ADMALS42 "SAQ 4WKS:ACCMP LESS B/C MNT PRBS SF-12V2";
label variable ADMWLM42 "SAQ 4WKS:WORK LIMT B/C MNT PROBS SF-12V2";
label variable ADPAIN42 "SAQ 4WKS:PAIN LIMITS NORMAL WORK SF-12V2";
label variable ADCAPE42 "SAQ 4WKS: FELT CALM/PEACEFUL SF-12V2";
label variable ADNRGY42 "SAQ 4WKS: HAD A LOT OF ENERGY SF-12V2";
label variable ADDOWN42 "SAQ 4WKS: FELT DOWNHEARTED/DEPR SF-12V2";
label variable ADSOCA42 "SAQ 4WKS: HLTH STOPPED SOC ACTIV SF-12V2";
label variable PCS42 "SAQ:PHY COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable MCS42 "SAQ:MNT COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable SFFLAG42 "SAQ: PCS/MCS IMPUTATION FLAG SF-12V2";
label variable ADNERV42 "SAQ 30 DAYS: HOW OFTEN FELT NERVOUS";
label variable ADHOPE42 "SAQ 30 DAYS: HOW OFTEN FELT HOPELESS";
label variable ADREST42 "SAQ 30 DAYS: HOW OFTEN FELT RESTLESS";
label variable ADSAD42 "SAQ 30 DAYS: HOW OFTEN FELT SAD";
label variable ADEFRT42 "SAQ 30 DAYS: HOW OFTN EVRYTHNG AN EFFORT";
label variable ADWRTH42 "SAQ 30 DAYS: HOW OFTEN FELT WORTHLESS";
label variable K6SUM42 "SAQ 30 DAYS: OVERALL RATING OF FEELINGS";
label variable ADINTR42 "SAQ 2 WKS: LITTLE INTEREST IN THINGS";
label variable ADDPRS42 "SAQ 2 WKS: FELT DOWN/DEPRESSED/HOPELESS";
label variable PHQ242 "SAQ 2 WKS: OVERALL RATING OF FEELINGS";
label variable ADINSA42 "SAQ: DO NOT NEED HEALTH INSURANCE";
label variable ADINSB42 "SAQ: HEALTH INSURANCE NOT WORTH COST";
label variable ADRISK42 "SAQ: MORE LIKELY TO TAKE RISKS";
label variable ADOVER42 "SAQ: CAN OVERCOME ILLS WITHOUT MED HELP";
label variable ADCMPM42 "SAQ: DATE COMPLETED - MONTH";
label variable ADCMPD42 "SAQ: DATE COMPLETED - DAY";
label variable ADCMPY42 "SAQ: DATE COMPLETED - YEAR";
label variable ADLANG42 "SAQ: LANGUAGE OF SAQ INTERVIEW";
label variable DSDIA53 "DCS: DIABETES DIAGNOSIS BY HEALTH PROF";
label variable DSA1C53 "DCS: TIMES TESTED FOR A-ONE-C - 2008";
label variable DSFT0953 "DCS: HAD FEET CHECKED DURING 2009";
label variable DSFT0853 "DCS: HAD FEET CHECKED DURING 2008";
label variable DSFT0753 "DCS: HAD FEET CHECKED DURING 2007";
label variable DSFB0753 "DCS: HAD FEET CHECKED BEFORE 2007";
label variable DSFTNV53 "DCS: NEVER HAD FEET CHECKED";
label variable DSEY0953 "DCS: DILATED EYE EXAM IN 2009";
label variable DSEY0853 "DCS: DILATED EYE EXAM IN 2008";
label variable DSEY0753 "DCS: DILATED EYE EXAM IN 2007";
label variable DSEB0753 "DCS: DILATED EYE EXAM BEFORE 2007";
label variable DSEYNV53 "DCS: NEVER HAD DILATED EYE EXAM";
label variable DSCH0953 "DCS: BLOOD CHOLESTEROL CHECKED IN 2009";
label variable DSCH0853 "DCS: BLOOD CHOLESTEROL CHECKED IN 2008";
label variable DSCH0753 "DCS: BLOOD CHOLESTEROL CHECKED IN 2007";
label variable DSCB0753 "DCS: BLOOD CHOLESTEROL CHECKED BEF 2007";
label variable DSCHNV53 "DCS: NEVER HAD BLOOD CHOLESTEROL CHECKED";
label variable DSFL0953 "DCS: GOT FLU VACCINATION IN 2009";
label variable DSFL0853 "DCS: GOT FLU VACCINATION IN 2008";
label variable DSFL0753 "DCS: GOT FLU VACCINATION IN 2007";
label variable DSVB0753 "DCS: GOT FLU VACCINATION BEFORE 2007";
label variable DSFLNV53 "DCS: NEVER GOT FLU VACCINATION";
label variable DSKIDN53 "DCS: HAS DIABETES CAUSED KIDNEY PROBLEMS";
label variable DSEYPR53 "DCS: HAS DIABETES CAUSED EYE PROBS";
label variable DSDIET53 "DCS: TREAT DIABETES W/DIET MODIFICATION";
label variable DSMED53 "DCS: TREAT DIABETES W/MEDS BY MOUTH";
label variable DSINSU53 "DCS: TREAT DIABETES W/INSULIN INJECTIONS";
label variable DSCPCP53 "DCS: LEARNED CARE FROM PRIMARY CARE PROV";
label variable DSCNPC53 "DCS: LEARNED CARE FROM OTHER PROVIDER";
label variable DSCPHN53 "DCS: LEARN CARE FROM PHONE CALL W/PROV";
label variable DSCINT53 "DCS: LEARNED CARE FROM READING INTERNET";
label variable DSCGRP53 "DCS: LEARNED CARE BY TAKING GROUP CLASS";
label variable DSCONF53 "DCS: CONFIDENT TAKING CARE OF DIABETES";
label variable DSPRX53 "DCS: WAS RESPONDENT A PROXY";
label variable DDNWRK31 "# DAYS MISSED WORK DUE TO ILL/INJ (RD31)";
label variable DDNWRK42 "# DAYS MISSED WORK DUE TO ILL/INJ (RD42)";
label variable DDNWRK53 "# DAYS MISSED WORK DUE TO ILL/INJ (RD53)";
label variable WKINBD31 "# DAYS MISSED WORK STAYED IN BED (RD31)";
label variable WKINBD42 "# DAYS MISSED WORK STAYED IN BED (RD42)";
label variable WKINBD53 "# DAYS MISSED WORK STAYED IN BED (RD53)";
label variable DDNSCL31 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD31)";
label variable DDNSCL42 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD42)";
label variable DDNSCL53 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD53)";
label variable SCLNBD31 "# DAYS MISSED SCHOOL STAYD IN BED (RD31)";
label variable SCLNBD42 "# DAYS MISSED SCHOOL STAYD IN BED (RD42)";
label variable SCLNBD53 "# DAYS MISSED SCHOOL STAYD IN BED (RD53)";
label variable DDBDYS31 "# OTH DAY SPENT IN BED SINCE START(RD31)";
label variable DDBDYS42 "# OTH DAY SPENT IN BED SINCE START(RD42)";
label variable DDBDYS53 "# OTH DAY SPENT IN BED SINCE START(RD53)";
label variable OTHDYS31 "MISS ANY WORK DAY TO CARE FOR OTH (RD31)";
label variable OTHDYS42 "MISS ANY WORK DAY TO CARE FOR OTH (RD42)";
label variable OTHDYS53 "MISS ANY WORK DAY TO CARE FOR OTH (RD53)";
label variable OTHNDD31 "# DAY MISSED WORK TO CARE FOR OTH (RD31)";
label variable OTHNDD42 "# DAY MISSED WORK TO CARE FOR OTH (RD42)";
label variable OTHNDD53 "# DAY MISSED WORK TO CARE FOR OTH (RD53)";
label variable ACCELI42 "PERS ELIGIBLE FOR ACCESS SUPPLEMENT-R4/2";
label variable LANGHM42 "AC01 LANGUAGE SPOKEN MOST IN HOME-R4/2";
label variable ENGCMF42 "AC02 WHOLE HH COMFRTBLE SPEAKNG ENG-R4/2";
label variable ENGSPK42 "AC02A NOT COMFRTBLE SPEAKNG ENGLISH-R4/2";
label variable USBORN42 "AC03 WAS PERSON BORN IN US-R4/2";
label variable USLIVE42 "AC04 # YRS PERSON LIVED IN US-R4/2";
label variable HAVEUS42 "AC05 DOES PERSON HAVE USC PROVIDER-R4/2";
label variable YNOUSC42 "AC07 MAIN REAS PERS DOESNT HAVE USC-R4/2";
label variable NOREAS42 "AC08 OTH REAS NO USC:NO OTH REASONS-R4/2";
label variable SELDSI42 "AC08 OTH REAS NO USC:SELDM/NEV SICK-R4/2";
label variable NEWARE42 "AC08 OTH REAS NO USC:RECENTLY MOVED-R4/2";
label variable DKWHRU42 "AC08 OTH REAS NO USC:DK WHERE TO GO-R4/2";
label variable USCNOT42 "AC08 OTH REAS NO USC: USC NOT AVAIL-R4/2";
label variable PERSLA42 "AC08 OTH REAS NO USC: LANGUAGE-R4/2";
label variable DIFFPL42 "AC08 OTH REAS NO USC:DIFFRNT PLACES-R4/2";
label variable INSRPL42 "AC08 OTH REAS NO USC:JUST CHNGD INS-R4/2";
label variable MYSELF42 "AC08 OTH REAS NO USC:NO DOC/TRT SLF-R4/2";
label variable CARECO42 "AC08 OTH REAS NO USC:COST OF MED CR-R4/2";
label variable OTHINS42 "AC08 OTH REAS NO USC: INS RELATED-R4/2";
label variable JOBRSN42 "AC08 OTH REAS NO USC: JOB RELATED-R4/2";
label variable NEWDOC42 "AC08 OTH REAS NO USC: LOOKNG FOR DR-R4/2";
label variable DOCELS42 "AC08 OTH REAS NO USC: DR ELSEWHERE-R4/2";
label variable NOLIKE42 "AC08 OTH REAS NO USC: DONT LIKE DRS-R4/2";
label variable HEALTH42 "AC08 OTH REAS NO USC: HLTH RELATED-R4/2";
label variable KNOWDR42 "AC08 OTH REAS NO USC: KNOWS/IS A DR-R4/2";
label variable ONJOB42 "AC08 OTH REAS NO USC: DR AT WORK-R4/2";
label variable NOGODR42 "AC08 OTH REAS NO USC: WONT GO TO DR-R4/2";
label variable TRANS42 "AC08 OTH REAS NO USC: TRANSPRT/TIME-R4/2";
label variable CLINIC42 "AC08 OTH REAS NO USC: HOSP/ER/CLNIC-R4/2";
label variable OTHREA42 "AC08 OTH REAS NO USC: OTHER REASON-R4/2";
label variable PROVTY42 "PROVIDER TYPE-R4/2";
label variable PLCTYP42 "USC TYPE OF PLACE-R4/2";
label variable GOTOUS42 "AC12 HOW DOES PERS GET TO USC PROV-R4/2";
label variable TMTKUS42 "AC13 HOW LONG IT TAKES GET TO USC-R4/2";
label variable DFTOUS42 "AC14 HOW DIFFICULT IS IT GET TO USC-R4/2";
label variable TYPEPE42 "USC TYPE OF PROVIDER-R4/2";
label variable LOCATN42 "USC LOCATION-R4/2";
label variable HSPLAP42 "AC18 IS PROVIDER HISPANIC OR LATINO-R4/2";
label variable WHITPR42 "AC19 IS PROVIDER WHITE-R4/2";
label variable BLCKPR42 "AC19 IS PROVIDER BLACK/AFRICAN AMER-R4/2";
label variable ASIANP42 "AC19 IS PROVIDER ASIAN-R4/2";
label variable NATAMP42 "AC19 IS PROVIDER NATIVE AMERICAN-R4/2";
label variable PACISP42 "AC19 IS PROVIDER OTH PACIFIC ISLNDR-R4/2";
label variable OTHRCP42 "AC19 IS PROVIDER SOME OTHER RACE-R4/2";
label variable GENDRP42 "AC20 IS PROVIDER MALE OR FEMALE-R4/2";
label variable MINORP42 "AC22 GO TO USC FOR NEW HEALTH PROB-R4/2";
label variable PREVEN42 "AC22 GO TO USC FOR PRVNTVE HLT CARE-R4/2";
label variable REFFRL42 "AC22 GO TO USC FOR REFERRALS-R4/2";
label variable ONGONG42 "AC22 GO TO USC FOR ONGOING HLTH PRB-R4/2";
label variable PHNREG42 "AC23 HOW DIFF CONTACT USC BY PHONE-R4/2";
label variable OFFHOU42 "AC24 USC HAS OFFCE HRS NGHTS/WKENDS-R4/2";
label variable AFTHOU42 "AC25 HOW DIFF CONTACT USC AFT HOURS-R4/2";
label variable TREATM42 "AC26 PROV ASK ABOUT OTH TREATMENTS-R4/2";
label variable RESPCT42 "AC27 PROV SHOWS RESPECT FOR TRTMNTS-R4/2";
label variable DECIDE42 "AC28 PROV ASKS PERS TO HELP DECIDE-R4/2";
label variable EXPLOP42 "AC30 PROV EXPLNS OPTIONS TO PERS-R4/2";
label variable LANGPR42 "AC31 PROV SPEAKS PERSON S LANGUAGE-R4/2";
label variable MDUNAB42 "UNABLE TO GET NECESSRY MEDICAL CARE-R4/2";
label variable MDUNRS42 "AC34 RSN UNABLE GET NECSRY MED CARE-R4/2";
label variable MDUNPR42 "AC35 PRB NOT GETTING NCSRY MED CARE-R4/2";
label variable MDDLAY42 "DELAYED IN GETTING NECSRY MED CARE-R4/2";
label variable MDDLRS42 "AC38 RSN DLAYD GETTING NEC MED CARE-R4/2";
label variable MDDLPR42 "AC39 PRB DLAYD GETTING NEC MED CARE-R4/2";
label variable DNUNAB42 "UNABLE TO GET NECESSARY DENTAL CARE-R4/2";
label variable DNUNRS42 "AC42 RSN UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNUNPR42 "AC43 PRB UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNDLAY42 "DELAYED IN GETTING NEC DENTAL CARE-R4/2";
label variable DNDLRS42 "AC46 RSN DLAYD GETTNG NEC DENT CARE-R4/2";
label variable DNDLPR42 "AC47 PRB DLAYD GETTNG NEC DENT CARE-R4/2";
label variable PMUNAB42 "UNABLE TO GET NECESSARY PRES MED-R4/2";
label variable PMUNRS42 "AC50 RSN UNABLE TO GET NEC PRES MED-R4/2";
label variable PMUNPR42 "AC51 PRB UNABLE TO GET NEC PRES MED-R4/2";
label variable PMDLAY42 "DELAYED IN GETTING NECSRY PRES MED-R4/2";
label variable PMDLRS42 "AC54 RSN DLAYD GETTING NEC PRES MED-R4/2";
label variable PMDLPR42 "AC55 PRB DLAYD GETTING NEC PRES MED-R4/2";
label variable EMPST31 "EMPLOYMENT STATUS RD 3/1";
label variable EMPST42 "EMPLOYMENT STATUS RD 4/2";
label variable EMPST53 "EMPLOYMENT STATUS RD 5/3";
label variable RNDFLG31 "DATA COLLECTION ROUND FOR RD 3/1 CMJ";
label variable MORJOB31 "HAS MORE THAN ONE JOB RD 3/1 INT DATE";
label variable MORJOB42 "HAS MORE THAN ONE JOB RD 4/2 INT DATE";
label variable MORJOB53 "HAS MORE THAN ONE JOB RD 5/3 INT DATE";
label variable EVRWRK "EVER WRKD FOR PAY IN LIFE AS OF 12/31/08";
label variable HRWG31X "HOURLY WAGE RD 3/1 CMJ (IMP)";
label variable HRWG42X "HOURLY WAGE RD 4/2 CMJ (IMP)";
label variable HRWG53X "HOURLY WAGE RD 5/3 CMJ (IMP)";
label variable HRWGIM31 "HRWG31X IMPUTATION FLAG";
label variable HRWGIM42 "HRWG42X IMPUTATION FLAG";
label variable HRWGIM53 "HRWG53X IMPUTATION FLAG";
label variable HRHOW31 "HOW HOURLY WAGE WAS CALCULATED RD 3/1";
label variable HRHOW42 "HOW HOURLY WAGE WAS CALCULATED RD 4/2";
label variable HRHOW53 "HOW HOURLY WAGE WAS CALCULATED RD 5/3";
label variable DIFFWG31 "PERSONS WAGES DIFFERENT THIS RD31 AT CMJ";
label variable DIFFWG42 "PERSONS WAGES DIFFERENT THIS RD42 AT CMJ";
label variable DIFFWG53 "PERSONS WAGES DIFFERENT THIS RD53 AT CMJ";
label variable NHRWG31 "UPDATED HRLY WAGE RD 3/1 CMJ (EDITED)";
label variable NHRWG42 "UPDATED HRLY WAGE RD 4/2 CMJ (EDITED)";
label variable NHRWG53 "UPDATED HRLY WAGE RD 5/3 CMJ (EDITED)";
label variable HOUR31 "HOURS PER WEEK AT RD 3/1 CMJ";
label variable HOUR42 "HOURS PER WEEK AT RD 4/2 CMJ";
label variable HOUR53 "HOURS PER WEEK AT RD 5/3 CMJ";
label variable TEMPJB31 "IS CMJ A TEMPORARY JOB RD 3/1";
label variable TEMPJB42 "IS CMJ A TEMPORARY JOB RD 4/2";
label variable TEMPJB53 "IS CMJ A TEMPORARY JOB RD 5/3";
label variable SSNLJB31 "IS CMJ A SEASONAL JOB RD 3/1";
label variable SSNLJB42 "IS CMJ A SEASONAL JOB RD 4/2";
label variable SSNLJB53 "IS CMJ A SEASONAL JOB RD 5/3";
label variable SELFCM31 "SELF-EMPLOYED AT RD 3/1 CMJ";
label variable SELFCM42 "SELF-EMPLOYED AT RD 4/2 CMJ";
label variable SELFCM53 "SELF-EMPLOYED AT RD 5/3 CMJ";
label variable DISVW31X "DISAVOWED HEALTH INS AT RD 3/1 CMJ (ED)";
label variable DISVW42X "DISAVOWED HEALTH INS AT RD 4/2 CMJ (ED)";
label variable DISVW53X "DISAVOWED HEALTH INS AT RD 5/3 CMJ (ED)";
label variable CHOIC31 "CHOICE OF HEALTH PLANS AT RD 3/1 CMJ";
label variable CHOIC42 "CHOICE OF HEALTH PLANS AT RD 4/2 CMJ";
label variable CHOIC53 "CHOICE OF HEALTH PLANS AT RD 5/3 CMJ";
label variable INDCAT31 "INDUSTRY GROUP RD 3/1 CMJ";
label variable INDCAT42 "INDUSTRY GROUP RD 4/2 CMJ";
label variable INDCAT53 "INDUSTRY GROUP RD 5/3 CMJ";
label variable NUMEMP31 "NUMBER OF EMPLOYEES AT RD 3/1 CMJ";
label variable NUMEMP42 "NUMBER OF EMPLOYEES AT RD 4/2 CMJ";
label variable NUMEMP53 "NUMBER OF EMPLOYEES AT RD 5/3 CMJ";
label variable MORE31 "RD 3/1 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE42 "RD 4/2 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE53 "RD 5/3 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable UNION31 "UNION STATUS AT RD 3/1 CMJ";
label variable UNION42 "UNION STATUS AT RD 4/2 CMJ";
label variable UNION53 "UNION STATUS AT RD 5/3 CMJ";
label variable NWK31 "REASON NOT WORKING DURING RD 3/1";
label variable NWK42 "REASON NOT WORKING DURING RD 4/2";
label variable NWK53 "REASON NOT WORKING DURING RD 5/3";
label variable CHGJ3142 "CHANGED JOB BETWEEN RD 3/1 AND RD 4/2";
label variable CHGJ4253 "CHANGED JOB BETWEEN RD 4/2 AND RD 5/3";
label variable YCHJ3142 "WHY CHNGD JOB BETWEEN RD 3/1 AND RD 4/2";
label variable YCHJ4253 "WHY CHNGD JOB BETWEEN RD 4/2 AND RD 5/3";
label variable STJBDD31 "DAY STARTED RD 3/1 CMJ";
label variable STJBMM31 "MONTH STARTED RD 3/1 CMJ";
label variable STJBYY31 "YEAR STARTED RD 3/1 CMJ";
label variable STJBDD42 "DAY STARTED RD 4/2 CMJ";
label variable STJBMM42 "MONTH STARTED RD 4/2 CMJ";
label variable STJBYY42 "YEAR STARTED RD 4/2 CMJ";
label variable STJBDD53 "DAY STARTED RD 5/3 CMJ";
label variable STJBMM53 "MONTH STARTED RD 5/3 CMJ";
label variable STJBYY53 "YEAR STARTED RD 5/3 CMJ";
label variable EVRETIRE "PERSON HAS EVER RETIRED";
label variable OCCCAT31 "OCCUPATION GROUP RD 3/1 CMJ";
label variable OCCCAT42 "OCCUPATION GROUP RD 4/2 CMJ";
label variable OCCCAT53 "OCCUPATION GROUP RD 5/3 CMJ";
label variable PAYVAC31 "PAID VACATION AT RD 3/1 CMJ";
label variable PAYVAC42 "PAID VACATION AT RD 4/2 CMJ";
label variable PAYVAC53 "PAID VACATION AT RD 5/3 CMJ";
label variable SICPAY31 "PAID SICK LEAVE AT RD 3/1 CMJ";
label variable SICPAY42 "PAID SICK LEAVE AT RD 4/2 CMJ";
label variable SICPAY53 "PAID SICK LEAVE AT RD 5/3 CMJ";
label variable PAYDR31 "PAID LEAVE TO VISIT DR RD 3/1 CMJ";
label variable PAYDR42 "PAID LEAVE TO VISIT DR RD 4/2 CMJ";
label variable PAYDR53 "PAID LEAVE TO VISIT DR RD 5/3 CMJ";
label variable RETPLN31 "PENSION PLAN AT RD 3/1 CMJ";
label variable RETPLN42 "PENSION PLAN AT RD 4/2 CMJ";
label variable RETPLN53 "PENSION PLAN AT RD 5/3 CMJ";
label variable BSNTY31 "SOLE PROP, PARTNER, CORP, RD 3/1 CMJ";
label variable BSNTY42 "SOLE PROP, PARTNER, CORP, RD 4/2 CMJ";
label variable BSNTY53 "SOLE PROP, PARTNER, CORP, RD 5/3 CMJ";
label variable JOBORG31 "PRIV (PROFIT,NONPROFIT) GOV RD 3/1 CMJ";
label variable JOBORG42 "PRIV (PROFIT,NONPROFIT) GOV RD 4/2 CMJ";
label variable JOBORG53 "PRIV (PROFIT,NONPROFIT) GOV RD 5/3 CMJ";
label variable HELD31X "HEALTH INSUR HELD FROM RD 3/1 CMJ (ED)";
label variable HELD42X "HEALTH INSUR HELD FROM RD 4/2 CMJ (ED)";
label variable HELD53X "HEALTH INSUR HELD FROM RD 5/3 CMJ (ED)";
label variable OFFER31X "HEALTH INSUR OFFERED BY RD 3/1 CMJ (ED)";
label variable OFFER42X "HEALTH INSUR OFFERED BY RD 4/2 CMJ (ED)";
label variable OFFER53X "HEALTH INSUR OFFERED BY RD 5/3 CMJ (ED)";
label variable OFREMP31 "EMPLOYER OFFERS HEALTH INS RD 3/1 CMJ";
label variable OFREMP42 "EMPLOYER OFFERS HEALTH INS RD 4/2 CMJ";
label variable OFREMP53 "EMPLOYER OFFERS HEALTH INS RD 5/3 CMJ";
label variable YNOINS31 "WHY NOT ELIGIBLE HEALTH INS RD 3/1 CMJ";
label variable YNOINS42 "WHY NOT ELIGIBLE HEALTH INS RD 4/2 CMJ";
label variable YNOINS53 "WHY NOT ELIGIBLE HEALTH INS RD 5/3 CMJ";
label variable TRIJA08X "COVERED BY TRICARE/CHAMPVA IN JAN08 (ED)";
label variable TRIFE08X "COVERED BY TRICARE/CHAMPVA IN FEB08 (ED)";
label variable TRIMA08X "COVERED BY TRICARE/CHAMPVA IN MAR08 (ED)";
label variable TRIAP08X "COVERED BY TRICARE/CHAMPVA IN APR08 (ED)";
label variable TRIMY08X "COVERED BY TRICARE/CHAMPVA IN MAY08 (ED)";
label variable TRIJU08X "COVERED BY TRICARE/CHAMPVA IN JUN08 (ED)";
label variable TRIJL08X "COVERED BY TRICARE/CHAMPVA IN JUL08 (ED)";
label variable TRIAU08X "COVERED BY TRICARE/CHAMPVA IN AUG08 (ED)";
label variable TRISE08X "COVERED BY TRICARE/CHAMPVA IN SEP08 (ED)";
label variable TRIOC08X "COVERED BY TRICARE/CHAMPVA IN OCT08 (ED)";
label variable TRINO08X "COVERED BY TRICARE/CHAMPVA IN NOV08 (ED)";
label variable TRIDE08X "COVERED BY TRICARE/CHAMPVA IN DEC08 (ED)";
label variable MCRJA08 "COVERED BY MEDICARE IN JAN08";
label variable MCRFE08 "COVERED BY MEDICARE IN FEB08";
label variable MCRMA08 "COVERED BY MEDICARE IN MAR08";
label variable MCRAP08 "COVERED BY MEDICARE IN APR08";
label variable MCRMY08 "COVERED BY MEDICARE IN MAY08";
label variable MCRJU08 "COVERED BY MEDICARE IN JUN08";
label variable MCRJL08 "COVERED BY MEDICARE IN JUL08";
label variable MCRAU08 "COVERED BY MEDICARE IN AUG08";
label variable MCRSE08 "COVERED BY MEDICARE IN SEP08";
label variable MCROC08 "COVERED BY MEDICARE IN OCT08";
label variable MCRNO08 "COVERED BY MEDICARE IN NOV08";
label variable MCRDE08 "COVERED BY MEDICARE IN DEC08";
label variable MCRJA08X "COVERED BY MEDICARE IN JAN08 (ED)";
label variable MCRFE08X "COVERED BY MEDICARE IN FEB08 (ED)";
label variable MCRMA08X "COVERED BY MEDICARE IN MAR08 (ED)";
label variable MCRAP08X "COVERED BY MEDICARE IN APR08 (ED)";
label variable MCRMY08X "COVERED BY MEDICARE IN MAY08 (ED)";
label variable MCRJU08X "COVERED BY MEDICARE IN JUN08 (ED)";
label variable MCRJL08X "COVERED BY MEDICARE IN JUL08 (ED)";
label variable MCRAU08X "COVERED BY MEDICARE IN AUG08 (ED)";
label variable MCRSE08X "COVERED BY MEDICARE IN SEP08 (ED)";
label variable MCROC08X "COVERED BY MEDICARE IN OCT08 (ED)";
label variable MCRNO08X "COVERED BY MEDICARE IN NOV08 (ED)";
label variable MCRDE08X "COVERED BY MEDICARE IN DEC08 (ED)";
label variable MCDJA08 "COV BY MEDICAID OR SCHIP IN JAN08";
label variable MCDFE08 "COV BY MEDICAID OR SCHIP IN FEB08";
label variable MCDMA08 "COV BY MEDICAID OR SCHIP IN MAR08";
label variable MCDAP08 "COV BY MEDICAID OR SCHIP IN APR08";
label variable MCDMY08 "COV BY MEDICAID OR SCHIP IN MAY08";
label variable MCDJU08 "COV BY MEDICAID OR SCHIP IN JUN08";
label variable MCDJL08 "COV BY MEDICAID OR SCHIP IN JUL08";
label variable MCDAU08 "COV BY MEDICAID OR SCHIP IN AUG08";
label variable MCDSE08 "COV BY MEDICAID OR SCHIP IN SEP08";
label variable MCDOC08 "COV BY MEDICAID OR SCHIP IN OCT08";
label variable MCDNO08 "COV BY MEDICAID OR SCHIP IN NOV08";
label variable MCDDE08 "COV BY MEDICAID OR SCHIP IN DEC08";
label variable MCDJA08X "COV BY MEDICAID OR SCHIP IN JAN08 (ED)";
label variable MCDFE08X "COV BY MEDICAID OR SCHIP IN FEB08 (ED)";
label variable MCDMA08X "COV BY MEDICAID OR SCHIP IN MAR08 (ED)";
label variable MCDAP08X "COV BY MEDICAID OR SCHIP IN APR08 (ED)";
label variable MCDMY08X "COV BY MEDICAID OR SCHIP IN MAY08 (ED)";
label variable MCDJU08X "COV BY MEDICAID OR SCHIP IN JUN08 (ED)";
label variable MCDJL08X "COV BY MEDICAID OR SCHIP IN JUL08 (ED)";
label variable MCDAU08X "COV BY MEDICAID OR SCHIP IN AUG08 (ED)";
label variable MCDSE08X "COV BY MEDICAID OR SCHIP IN SEP08 (ED)";
label variable MCDOC08X "COV BY MEDICAID OR SCHIP IN OCT08 (ED)";
label variable MCDNO08X "COV BY MEDICAID OR SCHIP IN NOV08 (ED)";
label variable MCDDE08X "COV BY MEDICAID OR SCHIP IN DEC08 (ED)";
label variable OPAJA08 "COV BY OTHER PUBLIC A INS IN JAN08";
label variable OPAFE08 "COV BY OTHER PUBLIC A INS IN FEB08";
label variable OPAMA08 "COV BY OTHER PUBLIC A INS IN MAR08";
label variable OPAAP08 "COV BY OTHER PUBLIC A INS IN APR08";
label variable OPAMY08 "COV BY OTHER PUBLIC A INS IN MAY08";
label variable OPAJU08 "COV BY OTHER PUBLIC A INS IN JUN08";
label variable OPAJL08 "COV BY OTHER PUBLIC A INS IN JUL08";
label variable OPAAU08 "COV BY OTHER PUBLIC A INS IN AUG08";
label variable OPASE08 "COV BY OTHER PUBLIC A INS IN SEP08";
label variable OPAOC08 "COV BY OTHER PUBLIC A INS IN OCT08";
label variable OPANO08 "COV BY OTHER PUBLIC A INS IN NOV08";
label variable OPADE08 "COV BY OTHER PUBLIC A INS IN DEC08";
label variable OPBJA08 "COV BY OTHER PUBLIC B INS IN JAN08";
label variable OPBFE08 "COV BY OTHER PUBLIC B INS IN FEB08";
label variable OPBMA08 "COV BY OTHER PUBLIC B INS IN MAR08";
label variable OPBAP08 "COV BY OTHER PUBLIC B INS IN APR08";
label variable OPBMY08 "COV BY OTHER PUBLIC B INS IN MAY08";
label variable OPBJU08 "COV BY OTHER PUBLIC B INS IN JUN08";
label variable OPBJL08 "COV BY OTHER PUBLIC B INS IN JUL08";
label variable OPBAU08 "COV BY OTHER PUBLIC B INS IN AUG08";
label variable OPBSE08 "COV BY OTHER PUBLIC B INS IN SEP08";
label variable OPBOC08 "COV BY OTHER PUBLIC B INS IN OCT08";
label variable OPBNO08 "COV BY OTHER PUBLIC B INS IN NOV08";
label variable OPBDE08 "COV BY OTHER PUBLIC B INS IN DEC08";
label variable STAJA08 "COVERED BY OTHER STATE PROG IN JAN08";
label variable STAFE08 "COVERED BY OTHER STATE PROG IN FEB08";
label variable STAMA08 "COVERED BY OTHER STATE PROG IN MAR08";
label variable STAAP08 "COVERED BY OTHER STATE PROG IN APR08";
label variable STAMY08 "COVERED BY OTHER STATE PROG IN MAY08";
label variable STAJU08 "COVERED BY OTHER STATE PROG IN JUN08";
label variable STAJL08 "COVERED BY OTHER STATE PROG IN JUL08";
label variable STAAU08 "COVERED BY OTHER STATE PROG IN AUG08";
label variable STASE08 "COVERED BY OTHER STATE PROG IN SEP08";
label variable STAOC08 "COVERED BY OTHER STATE PROG IN OCT08";
label variable STANO08 "COVERED BY OTHER STATE PROG IN NOV08";
label variable STADE08 "COVERED BY OTHER STATE PROG IN DEC08";
label variable PUBJA08X "COVR BY ANY PUBLIC INS IN JAN08 (ED)";
label variable PUBFE08X "COVR BY ANY PUBLIC INS IN FEB08 (ED)";
label variable PUBMA08X "COVR BY ANY PUBLIC INS IN MAR08 (ED)";
label variable PUBAP08X "COVR BY ANY PUBLIC INS IN APR08 (ED)";
label variable PUBMY08X "COVR BY ANY PUBLIC INS IN MAY08 (ED)";
label variable PUBJU08X "COVR BY ANY PUBLIC INS IN JUN08 (ED)";
label variable PUBJL08X "COVR BY ANY PUBLIC INS IN JUL08 (ED)";
label variable PUBAU08X "COVR BY ANY PUBLIC INS IN AUG08 (ED)";
label variable PUBSE08X "COVR BY ANY PUBLIC INS IN SEP08 (ED)";
label variable PUBOC08X "COVR BY ANY PUBLIC INS IN OCT08 (ED)";
label variable PUBNO08X "COVR BY ANY PUBLIC INS IN NOV08 (ED)";
label variable PUBDE08X "COVR BY ANY PUBLIC INS IN DEC08 (ED)";
label variable PEGJA08 "COVERED BY EMPL UNION INS IN JAN08";
label variable PEGFE08 "COVERED BY EMPL UNION INS IN FEB08";
label variable PEGMA08 "COVERED BY EMPL UNION INS IN MAR08";
label variable PEGAP08 "COVERED BY EMPL UNION INS IN APR08";
label variable PEGMY08 "COVERED BY EMPL UNION INS IN MAY08";
label variable PEGJU08 "COVERED BY EMPL UNION INS IN JUN08";
label variable PEGJL08 "COVERED BY EMPL UNION INS IN JUL08";
label variable PEGAU08 "COVERED BY EMPL UNION INS IN AUG08";
label variable PEGSE08 "COVERED BY EMPL UNION INS IN SEP08";
label variable PEGOC08 "COVERED BY EMPL UNION INS IN OCT08";
label variable PEGNO08 "COVERED BY EMPL UNION INS IN NOV08";
label variable PEGDE08 "COVERED BY EMPL UNION INS IN DEC08";
label variable PDKJA08 "COVR BY PRIV INS (SOURCE UNKNWN) JAN08";
label variable PDKFE08 "COVR BY PRIV INS (SOURCE UNKNWN) FEB08";
label variable PDKMA08 "COVR BY PRIV INS (SOURCE UNKNWN) MAR08";
label variable PDKAP08 "COVR BY PRIV INS (SOURCE UNKNWN) APR08";
label variable PDKMY08 "COVR BY PRIV INS (SOURCE UNKNWN) MAY08";
label variable PDKJU08 "COVR BY PRIV INS (SOURCE UNKNWN) JUN08";
label variable PDKJL08 "COVR BY PRIV INS (SOURCE UNKNWN) JUL08";
label variable PDKAU08 "COVR BY PRIV INS (SOURCE UNKNWN) AUG08";
label variable PDKSE08 "COVR BY PRIV INS (SOURCE UNKNWN) SEP08";
label variable PDKOC08 "COVR BY PRIV INS (SOURCE UNKNWN) OCT08";
label variable PDKNO08 "COVR BY PRIV INS (SOURCE UNKNWN) NOV08";
label variable PDKDE08 "COVR BY PRIV INS (SOURCE UNKNWN) DEC08";
label variable PNGJA08 "COVERED BY NONGROUP INS IN JAN08";
label variable PNGFE08 "COVERED BY NONGROUP INS IN FEB08";
label variable PNGMA08 "COVERED BY NONGROUP INS IN MAR08";
label variable PNGAP08 "COVERED BY NONGROUP INS IN APR08";
label variable PNGMY08 "COVERED BY NONGROUP INS IN MAY08";
label variable PNGJU08 "COVERED BY NONGROUP INS IN JUN08";
label variable PNGJL08 "COVERED BY NONGROUP INS IN JUL08";
label variable PNGAU08 "COVERED BY NONGROUP INS IN AUG08";
label variable PNGSE08 "COVERED BY NONGROUP INS IN SEP08";
label variable PNGOC08 "COVERED BY NONGROUP INS IN OCT08";
label variable PNGNO08 "COVERED BY NONGROUP INS IN NOV08";
label variable PNGDE08 "COVERED BY NONGROUP INS IN DEC08";
label variable POGJA08 "COVERED BY OTHER GROUP INS IN JAN08";
label variable POGFE08 "COVERED BY OTHER GROUP INS IN FEB08";
label variable POGMA08 "COVERED BY OTHER GROUP INS IN MAR08";
label variable POGAP08 "COVERED BY OTHER GROUP INS IN APR08";
label variable POGMY08 "COVERED BY OTHER GROUP INS IN MAY08";
label variable POGJU08 "COVERED BY OTHER GROUP INS IN JUN08";
label variable POGJL08 "COVERED BY OTHER GROUP INS IN JUL08";
label variable POGAU08 "COVERED BY OTHER GROUP INS IN AUG08";
label variable POGSE08 "COVERED BY OTHER GROUP INS IN SEP08";
label variable POGOC08 "COVERED BY OTHER GROUP INS IN OCT08";
label variable POGNO08 "COVERED BY OTHER GROUP INS IN NOV08";
label variable POGDE08 "COVERED BY OTHER GROUP INS IN DEC08";
label variable PRSJA08 "COVERED BY SELF-EMP-1 INS IN JAN08";
label variable PRSFE08 "COVERED BY SELF-EMP-1 INS IN FEB08";
label variable PRSMA08 "COVERED BY SELF-EMP-1 INS IN MAR08";
label variable PRSAP08 "COVERED BY SELF-EMP-1 INS IN APR08";
label variable PRSMY08 "COVERED BY SELF-EMP-1 INS IN MAY08";
label variable PRSJU08 "COVERED BY SELF-EMP-1 INS IN JUN08";
label variable PRSJL08 "COVERED BY SELF-EMP-1 INS IN JUL08";
label variable PRSAU08 "COVERED BY SELF-EMP-1 INS IN AUG08";
label variable PRSSE08 "COVERED BY SELF-EMP-1 INS IN SEP08";
label variable PRSOC08 "COVERED BY SELF-EMP-1 INS IN OCT08";
label variable PRSNO08 "COVERED BY SELF-EMP-1 INS IN NOV08";
label variable PRSDE08 "COVERED BY SELF-EMP-1 INS IN DEC08";
label variable POUJA08 "COVERED BY HOLDER OUTSIDE OF RU IN JAN08";
label variable POUFE08 "COVERED BY HOLDER OUTSIDE OF RU IN FEB08";
label variable POUMA08 "COVERED BY HOLDER OUTSIDE OF RU IN MAR08";
label variable POUAP08 "COVERED BY HOLDER OUTSIDE OF RU IN APR08";
label variable POUMY08 "COVERED BY HOLDER OUTSIDE OF RU IN MAY08";
label variable POUJU08 "COVERED BY HOLDER OUTSIDE OF RU IN JUN08";
label variable POUJL08 "COVERED BY HOLDER OUTSIDE OF RU IN JUL08";
label variable POUAU08 "COVERED BY HOLDER OUTSIDE OF RU IN AUG08";
label variable POUSE08 "COVERED BY HOLDER OUTSIDE OF RU IN SEP08";
label variable POUOC08 "COVERED BY HOLDER OUTSIDE OF RU IN OCT08";
label variable POUNO08 "COVERED BY HOLDER OUTSIDE OF RU IN NOV08";
label variable POUDE08 "COVERED BY HOLDER OUTSIDE OF RU IN DEC08";
label variable PRIJA08 "COVERED BY PRIVATE INS IN JAN08";
label variable PRIFE08 "COVERED BY PRIVATE INS IN FEB08";
label variable PRIMA08 "COVERED BY PRIVATE INS IN MAR08";
label variable PRIAP08 "COVERED BY PRIVATE INS IN APR08";
label variable PRIMY08 "COVERED BY PRIVATE INS IN MAY08";
label variable PRIJU08 "COVERED BY PRIVATE INS IN JUN08";
label variable PRIJL08 "COVERED BY PRIVATE INS IN JUL08";
label variable PRIAU08 "COVERED BY PRIVATE INS IN AUG08";
label variable PRISE08 "COVERED BY PRIVATE INS IN SEP08";
label variable PRIOC08 "COVERED BY PRIVATE INS IN OCT08";
label variable PRINO08 "COVERED BY PRIVATE INS IN NOV08";
label variable PRIDE08 "COVERED BY PRIVATE INS IN DEC08";
label variable HPEJA08 "HOLDER OF EMPL UNION INS IN JAN08";
label variable HPEFE08 "HOLDER OF EMPL UNION INS IN FEB08";
label variable HPEMA08 "HOLDER OF EMPL UNION INS IN MAR08";
label variable HPEAP08 "HOLDER OF EMPL UNION INS IN APR08";
label variable HPEMY08 "HOLDER OF EMPL UNION INS IN MAY08";
label variable HPEJU08 "HOLDER OF EMPL UNION INS IN JUN08";
label variable HPEJL08 "HOLDER OF EMPL UNION INS IN JUL08";
label variable HPEAU08 "HOLDER OF EMPL UNION INS IN AUG08";
label variable HPESE08 "HOLDER OF EMPL UNION INS IN SEP08";
label variable HPEOC08 "HOLDER OF EMPL UNION INS IN OCT08";
label variable HPENO08 "HOLDER OF EMPL UNION INS IN NOV08";
label variable HPEDE08 "HOLDER OF EMPL UNION INS IN DEC08";
label variable HPDJA08 "HOLDER OF PRIV INS (SOURCE UNKNWN) JAN08";
label variable HPDFE08 "HOLDER OF PRIV INS (SOURCE UNKNWN) FEB08";
label variable HPDMA08 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAR08";
label variable HPDAP08 "HOLDER OF PRIV INS (SOURCE UNKNWN) APR08";
label variable HPDMY08 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAY08";
label variable HPDJU08 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUN08";
label variable HPDJL08 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUL08";
label variable HPDAU08 "HOLDER OF PRIV INS (SOURCE UNKNWN) AUG08";
label variable HPDSE08 "HOLDER OF PRIV INS (SOURCE UNKNWN) SEP08";
label variable HPDOC08 "HOLDER OF PRIV INS (SOURCE UNKNWN) OCT08";
label variable HPDNO08 "HOLDER OF PRIV INS (SOURCE UNKNWN) NOV08";
label variable HPDDE08 "HOLDER OF PRIV INS (SOURCE UNKNWN) DEC08";
label variable HPNJA08 "HOLDER OF NONGROUP INS IN JAN08";
label variable HPNFE08 "HOLDER OF NONGROUP INS IN FEB08";
label variable HPNMA08 "HOLDER OF NONGROUP INS IN MAR08";
label variable HPNAP08 "HOLDER OF NONGROUP INS IN APR08";
label variable HPNMY08 "HOLDER OF NONGROUP INS IN MAY08";
label variable HPNJU08 "HOLDER OF NONGROUP INS IN JUN08";
label variable HPNJL08 "HOLDER OF NONGROUP INS IN JUL08";
label variable HPNAU08 "HOLDER OF NONGROUP INS IN AUG08";
label variable HPNSE08 "HOLDER OF NONGROUP INS IN SEP08";
label variable HPNOC08 "HOLDER OF NONGROUP INS IN OCT08";
label variable HPNNO08 "HOLDER OF NONGROUP INS IN NOV08";
label variable HPNDE08 "HOLDER OF NONGROUP INS IN DEC08";
label variable HPOJA08 "HOLDER OF OTHER GROUP INS IN JAN08";
label variable HPOFE08 "HOLDER OF OTHER GROUP INS IN FEB08";
label variable HPOMA08 "HOLDER OF OTHER GROUP INS IN MAR08";
label variable HPOAP08 "HOLDER OF OTHER GROUP INS IN APR08";
label variable HPOMY08 "HOLDER OF OTHER GROUP INS IN MAY08";
label variable HPOJU08 "HOLDER OF OTHER GROUP INS IN JUN08";
label variable HPOJL08 "HOLDER OF OTHER GROUP INS IN JUL08";
label variable HPOAU08 "HOLDER OF OTHER GROUP INS IN AUG08";
label variable HPOSE08 "HOLDER OF OTHER GROUP INS IN SEP08";
label variable HPOOC08 "HOLDER OF OTHER GROUP INS IN OCT08";
label variable HPONO08 "HOLDER OF OTHER GROUP INS IN NOV08";
label variable HPODE08 "HOLDER OF OTHER GROUP INS IN DEC08";
label variable HPSJA08 "HOLDER OF SELF-EMP-1 INS IN JAN08";
label variable HPSFE08 "HOLDER OF SELF-EMP-1 INS IN FEB08";
label variable HPSMA08 "HOLDER OF SELF-EMP-1 INS IN MAR08";
label variable HPSAP08 "HOLDER OF SELF-EMP-1 INS IN APR08";
label variable HPSMY08 "HOLDER OF SELF-EMP-1 INS IN MAY08";
label variable HPSJU08 "HOLDER OF SELF-EMP-1 INS IN JUN08";
label variable HPSJL08 "HOLDER OF SELF-EMP-1 INS IN JUL08";
label variable HPSAU08 "HOLDER OF SELF-EMP-1 INS IN AUG08";
label variable HPSSE08 "HOLDER OF SELF-EMP-1 INS IN SEP08";
label variable HPSOC08 "HOLDER OF SELF-EMP-1 INS IN OCT08";
label variable HPSNO08 "HOLDER OF SELF-EMP-1 INS IN NOV08";
label variable HPSDE08 "HOLDER OF SELF-EMP-1 INS IN DEC08";
label variable HPRJA08 "HOLDER OF PRIVATE INSURANCE IN JAN08";
label variable HPRFE08 "HOLDER OF PRIVATE INSURANCE IN FEB08";
label variable HPRMA08 "HOLDER OF PRIVATE INSURANCE IN MAR08";
label variable HPRAP08 "HOLDER OF PRIVATE INSURANCE IN APR08";
label variable HPRMY08 "HOLDER OF PRIVATE INSURANCE IN MAY08";
label variable HPRJU08 "HOLDER OF PRIVATE INSURANCE IN JUN08";
label variable HPRJL08 "HOLDER OF PRIVATE INSURANCE IN JUL08";
label variable HPRAU08 "HOLDER OF PRIVATE INSURANCE IN AUG08";
label variable HPRSE08 "HOLDER OF PRIVATE INSURANCE IN SEP08";
label variable HPROC08 "HOLDER OF PRIVATE INSURANCE IN OCT08";
label variable HPRNO08 "HOLDER OF PRIVATE INSURANCE IN NOV08";
label variable HPRDE08 "HOLDER OF PRIVATE INSURANCE IN DEC08";
label variable INSJA08X "COVR BY HOSP/MED INS IN JAN08 (ED)";
label variable INSFE08X "COVR BY HOSP/MED INS IN FEB08 (ED)";
label variable INSMA08X "COVR BY HOSP/MED INS IN MAR08 (ED)";
label variable INSAP08X "COVR BY HOSP/MED INS IN APR08 (ED)";
label variable INSMY08X "COVR BY HOSP/MED INS IN MAY08 (ED)";
label variable INSJU08X "COVR BY HOSP/MED INS IN JUN08 (ED)";
label variable INSJL08X "COVR BY HOSP/MED INS IN JUL08 (ED)";
label variable INSAU08X "COVR BY HOSP/MED INS IN AUG08 (ED)";
label variable INSSE08X "COVR BY HOSP/MED INS IN SEP08 (ED)";
label variable INSOC08X "COVR BY HOSP/MED INS IN OCT08 (ED)";
label variable INSNO08X "COVR BY HOSP/MED INS IN NOV08 (ED)";
label variable INSDE08X "COVR BY HOSP/MED INS IN DEC08 (ED)";
label variable PRVEV08 "EVER HAVE PRIVATE INSURANCE DURING 08";
label variable TRIEV08 "EVER HAVE TRICARE/CHAMPVA DURING 08";
label variable MCREV08 "EVER HAVE MEDICARE DURING 08 (ED)";
label variable MCDEV08 "EVER HAVE MEDICAID/SCHIP DURING 08 (ED)";
label variable OPAEV08 "EVER HAVE OTHER PUBLIC A INS DURING 08";
label variable OPBEV08 "EVER HAVE OTHER PUBLIC B INS DURING 08";
label variable UNINS08 "UNINSURED ALL OF 08";
label variable INSCOV08 "HEALTH INSURANCE COVERAGE INDICATOR 08";
label variable TRIST31X "COVERED BY TRICARE STANDARD - R3/1";
label variable TRIST42X "COVERED BY TRICARE STANDARD - R4/2";
label variable TRIST08X "COVERED BY TRICARE STANDARD - 12/31/08";
label variable TRIPR31X "COVERED BY TRICARE PRIME - R3/1";
label variable TRIPR42X "COVERED BY TRICARE PRIME - R4/2";
label variable TRIPR08X "COVERED BY TRICARE PRIME - 12/31/08";
label variable TRIEX31X "COVERED BY TRICARE EXTRA - R3/1";
label variable TRIEX42X "COVERED BY TRICARE EXTRA - R4/2";
label variable TRIEX08X "COVERED BY TRICARE EXTRA - 12/31/08";
label variable TRILI31X "COVERED BY TRICARE FOR LIFE - R3/1";
label variable TRILI42X "COVERED BY TRICARE FOR LIFE - R4/2";
label variable TRILI08X "COVERED BY TRICARE FOR LIFE - 12/31/08";
label variable TRICH31X "COVERED BY TRICARE CHAMPVA - R3/1";
label variable TRICH42X "COVERED BY TRICARE CHAMPVA - R4/2";
label variable TRICH08X "COVERED BY TRICARE CHAMPVA - 12/31/08";
label variable MCRPD31 "COV BY MEDICARE PMED BENEFIT - R3/1";
label variable MCRPD42 "COV BY MEDICARE PMED BENEFIT - R4/2";
label variable MCRPD08 "COV BY MEDICARE PMED BENEFIT - 12/31/08";
label variable MCRPD31X "COV BY MEDICARE PMED BENEFIT - R3/1 (ED)";
label variable MCRPD42X "COV BY MEDICARE PMED BENEFIT - R4/2 (ED)";
label variable MCRPD08X "COV BY MCARE PMED BENEFIT-12/31/08 (ED)";
label variable MCRPHO31 "COV BY MEDICARE MANAGED CARE - R3/1";
label variable MCRPHO42 "COV BY MEDICARE MANAGED CARE - R4/2";
label variable MCRPHO08 "COV BY MEDICARE MANAGED CARE - 12/31/08";
label variable MCDHMO31 "COVERED BY MEDICAID OR SCHIP HMO - R3/1";
label variable MCDHMO42 "COVERED BY MEDICAID OR SCHIP HMO - R4/2";
label variable MCDHMO08 "COVRED BY MEDICAID OR SCHIP HMO-12/31/08";
label variable MCDMC31 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R3/1";
label variable MCDMC42 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R4/2";
label variable MCDMC08 "COV BY MCAID/SCHIP GTKEEPR PLAN-12/31/08";
label variable PRVHMO31 "COVERED BY PRIVATE HMO - R3/1";
label variable PRVHMO42 "COVERED BY PRIVATE HMO - R4/2";
label variable PRVHMO08 "COVERED BY PRIVATE HMO - 12/31/08";
label variable PRVMNC31 "COVERED BY PRIVATE GATEKEEPER PLAN-R3/1";
label variable PRVMNC42 "COVERED BY PRIVATE GATEKEEPER PLAN-R4/2";
label variable PRVMNC08 "COVERED BY PRIV GATEKEEPER PLAN-12/31/08";
label variable PRVDRL31 "COV BY PRIV PLAN W/DOCTOR LIST - R3/1";
label variable PRVDRL42 "COV BY PRIV PLAN W/DOCTOR LIST - R4/2";
label variable PRVDRL08 "COV BY PRIV PLAN W/DOCTOR LIST-12/31/08";
label variable PHMONP31 "COV BY HMO-PAYS NON-PLAN DR VISITS-R3/1";
label variable PHMONP42 "COV BY HMO-PAYS NON-PLAN DR VISITS-R4/2";
label variable PHMONP08 "COV BY HMO-PAYS NON-PLAN DRS - 12/31/08";
label variable PMNCNP31 "COV BY GATEKPR-PAYS NON-PLAN DRS-R3/1";
label variable PMNCNP42 "COV BY GATEKPR-PAYS NON-PLAN DRS-R4/2";
label variable PMNCNP08 "COV BY GATEKP-PAYS NON-PLAN DRS-12/31/08";
label variable PRDRNP31 "COV BY DR LIST-PAYS NON-PLAN DRS-R3/1";
label variable PRDRNP42 "COV BY DR LIST-PAYS NON-PLAN DRS-R4/2";
label variable PRDRNP08 "COV BY DR LIST-PAYS NON-PLAN DR-12/31/08";
label variable PREVCOVR "PER COV BY INS IN PREV 2 YRS-PNL 13 ONLY";
label variable COVRMM "MONTH MOST RECENTLY COVERED-PNL 13 ONLY";
label variable COVRYY "YEAR MOST RECENTLY COVERED-PANEL 13 ONLY";
label variable WASESTB "WAS PREV INS BY EMPL OR UNION-PN 13 ONLY";
label variable WASMCARE "WAS PREV INS BY MEDICARE-PANEL 13 ONLY";
label variable WASMCAID "WAS PREV INS BY MCAID/SCHIP-PNL 13 ONLY";
label variable WASCHAMP "WAS PREV INS TRICARE/CHAMPVA-PNL 13 ONLY";
label variable WASVA "WAS PREV INS VA/MILITAR CARE-PNL 13 ONLY";
label variable WASPRIV "WAS PREV INS GRP/ASSOC/INS CO-PN 13 ONLY";
label variable WASOTGOV "WAS PREV INS BY OTH GOV PRG-PNL 13 ONLY";
label variable WASAFDC "WAS PREV INS BY PUBLIC AFDC-PNL 13 ONLY";
label variable WASSSI "WAS PREV INS BY SSI PROGRAM-PNL 13 ONLY";
label variable WASSTAT1 "WAS PREV INS BY STAT PROG 1-PNL 13 ONLY";
label variable WASSTAT2 "WAS PREV INS BY STAT PROG 2-PNL 13 ONLY";
label variable WASSTAT3 "WAS PREV INS BY STAT PROG 3-PNL 13 ONLY";
label variable WASSTAT4 "WAS PREV INS BY STAT PROG 4-PNL 13 ONLY";
label variable WASOTHER "WAS PREV INS BY OTH SOURCE-PANEL 13 ONLY";
label variable NOINSBEF "EVR WOUT HLTH INSR PREV YR-PANEL 13 ONLY";
label variable NOINSTM "# WKS/MON WOUT HLTH INS PRV YR-PN 13 ONL";
label variable NOINUNIT "UNIT OF TIME WOUT HLTH INS-PANEL 13 ONLY";
label variable MORECOVR "COV BY MOR COMPR PL PREV 2 YR-PN 13 ONLY";
label variable INSENDMM "MONTH MOST RECENTLY COVD-PANEL 13 ONLY";
label variable INSENDYY "YEAR MOST RECENTLY COVD-PANEL 13 ONLY";
label variable TRICR31X "COV BY TRICR/CHAMV - R3/1 INT DT (ED)";
label variable TRICR42X "COV BY TRICR/CHAMV - R4/2 INT DT (ED)";
label variable TRICR53X "COV BY TRICR/CHAMV 12-31/R3 INT DT (ED)";
label variable TRICR08X "COV BY TRICR/CHAMV - 12/31/08 (ED)";
label variable TRIAT31X "ANY TIME COV TRICARE/CHAMPVA - R3/1";
label variable TRIAT42X "ANY TIME COV TRICARE/CHAMPVA - R4/2";
label variable TRIAT53X "ANY TIME COV TRICARE/CHAMPVA - R5/3";
label variable TRIAT08X "ANY TIME COV TRICARE/CHAMPVA - 12/31/08";
label variable MCAID31 "COV BY MEDICAID OR SCHIP - R3/1 INT DT";
label variable MCAID42 "COV BY MEDICAID OR SCHIP - R4/2 INT DT";
label variable MCAID53 "COV BY MEDICAID OR SCHIP 12-31/R3 INT DT";
label variable MCAID08 "COV BY MEDICAID OR SCHIP - 12/31/08";
label variable MCAID31X "COV BY MEDICAID/SCHIP - R3/1 INT DT (ED)";
label variable MCAID42X "COV BY MEDICAID/SCHIP - R4/2 INT DT (ED)";
label variable MCAID53X "COV MEDICAID/SCHIP 12-31/R3 INT DT(ED)";
label variable MCAID08X "COV BY MEDICAID OR SCHIP - 12/31/08 (ED)";
label variable MCARE31 "COV BY MEDICARE - R3/1 INT DT";
label variable MCARE42 "COV BY MEDICARE - R4/2 INT DT";
label variable MCARE53 "COV BY MEDICARE 12-31/R3 INT DT";
label variable MCARE08 "COV BY MEDICARE - 12/31/08";
label variable MCARE31X "COV BY MEDICARE - R3/1 INT DT (ED)";
label variable MCARE42X "COV BY MEDICARE - R4/2 INT DT (ED)";
label variable MCARE53X "COV BY MEDICARE 12-31/R3 INT DT (ED)";
label variable MCARE08X "COV BY MEDICARE - 12/31/08 (ED)";
label variable MCDAT31X "ANY TIME COV MEDICAID OR SCHIP - R3/1";
label variable MCDAT42X "ANY TIME COV MEDICAID OR SCHIP - R4/2";
label variable MCDAT53X "ANY TIME COV MEDICAID OR SCHIP - R5/3";
label variable MCDAT08X "ANY TIME COV MEDICAID OR SCHIP-12/31/08";
label variable OTPAAT31 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R3/1";
label variable OTPAAT42 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R4/2";
label variable OTPAAT53 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R5/3";
label variable OTPAAT08 "ANY COV OT GOV MCAID/SCHIP HMO-12/31/08";
label variable OTPBAT31 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R3/1";
label variable OTPBAT42 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R4/2";
label variable OTPBAT53 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R5/3";
label variable OTPBAT08 "ANY CV OT GV NT MCAID/SCHIP HMO-12/31/08";
label variable OTPUBA31 "COV/PAY OTH GOV MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBA42 "COV/PAY OTH GOV MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBA53 "COV/PAY OTH GOV MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBA08 "COV/PAY OTH GOV MCAID/SCHIP HMO-12/31/08";
label variable OTPUBB31 "COV OTH GOV NOT MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBB42 "COV OTH GOV NOT MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBB53 "COV OTH GOV NOT MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBB08 "COV OTH GOV NOT MCAID/SCHIP HMO-12/31/08";
label variable PRIDK31 "COV BY PRIV INS (DK PLAN) - R3/1 INT";
label variable PRIDK42 "COV BY PRIV INS (DK PLAN) - R4/2 INT";
label variable PRIDK53 "COV BY PRIV INS (DK PLAN) 12-31/R3 INT";
label variable PRIDK08 "COV BY PRIV INS (DK PLAN) - 12/31/08";
label variable PRIEU31 "COV BY EMPL/UNION GRP INS - R3/1 INT DT";
label variable PRIEU42 "COV BY EMPL/UNION GRP INS - R4/2 INT DT";
label variable PRIEU53 "COV BY EMPL/UNION GRP INS 12-31/R3 INT";
label variable PRIEU08 "COV BY EMPL/UNION GRP INS - 12/31/08";
label variable PRING31 "COV BY NON-GROUP INS - R3/1 INT DT";
label variable PRING42 "COV BY NON-GROUP INS - R4/2 INT DT";
label variable PRING53 "COV BY NON-GROUP INS 12-31/R3 INT DT";
label variable PRING08 "COV BY NON-GROUP INS - 12/31/08";
label variable PRIOG31 "COV BY OTHER GROUP INS - R3/1 INT DT";
label variable PRIOG42 "COV BY OTHER GROUP INS - R4/2 INT DT";
label variable PRIOG53 "COV BY OTHER GROUP INS 12-31/R3 INT DT";
label variable PRIOG08 "COV BY OTHER GROUP INS - 12/31/08";
label variable PRIS31 "COV BY SELF-EMP-1 INS - R3/1 INT DT";
label variable PRIS42 "COV BY SELF-EMP-1 INS - R4/2 INT DT";
label variable PRIS53 "COV BY SELF-EMP-1 INS 12-31/R3 INT DT";
label variable PRIS08 "COV BY SELF-EMP-1 INS - 12/31/08";
label variable PRIV31 "COV BY PRIV HLTH INS - R3/1 INT DATE";
label variable PRIV42 "COV BY PRIV HLTH INS - R4/2 INT DATE";
label variable PRIV53 "COV BY PRIV HLTH INS 12-31/R3 INT DATE";
label variable PRIV08 "COV BY PRIV HLTH INS - 12/31/08";
label variable PRIVAT31 "ANY TIME COV PRIVATE INS - R3/1";
label variable PRIVAT42 "ANY TIME COV PRIVATE INS - R4/2";
label variable PRIVAT53 "ANY TIME COV PRIVATE INS - R5/3";
label variable PRIVAT08 "ANY TIME COV PRIVATE INS - 12/31/08";
label variable PROUT31 "COV BY SOMEONE OUT OF RU - R3/1 INT";
label variable PROUT42 "COV BY SOMEONE OUT OF RU - R4/2 INT";
label variable PROUT53 "COV BY SOMEONE OUT OF RU 12-31/R3 INT DT";
label variable PROUT08 "COV BY SOMEONE OUT OF RU - 12/31/08";
label variable PUB31X "COV BY PUBLIC INS - R3/1 INT DT (ED)";
label variable PUB42X "COV BY PUBLIC INS - R4/2 INT DT (ED)";
label variable PUB53X "COV BY PUBLIC INS 12-31/R3 INT DT (ED)";
label variable PUB08X "COV BY PUBLIC INS - 12/31/08 (ED)";
label variable PUBAT31X "ANY TIME COV BY PUBLIC - R3/1";
label variable PUBAT42X "ANY TIME COV BY PUBLIC - R4/2";
label variable PUBAT53X "ANY TIME COV BY PUBLIC - R5/3";
label variable PUBAT08X "ANY TIME COV BY PUBLIC - 12/31/08";
label variable INS31X "INSURED - R3/1 INT DATE (ED)";
label variable INS42X "INSURED - R4/2 INT DATE (ED)";
label variable INS53X "INSURED 12-31/R3 INT DATE (ED)";
label variable INS08X "INSURED - 12/31/08 (ED)";
label variable INSAT31X "INSURED ANY TIME IN R3/1";
label variable INSAT42X "INSURED ANY TIME IN R4/2";
label variable INSAT53X "INSURED ANY TIME IN R5/3";
label variable INSAT08X "INSURED ANY TIME IN R5/R3 UNTIL 12/31/08";
label variable STAPR31 "COV BY STATE-SPEC PROG - R3/1 INT DT";
label variable STAPR42 "COV BY STATE-SPEC PROG - R4/2 INT DT";
label variable STAPR53 "COV BY STATE-SPEC PROG 12-31/R3 INT DT";
label variable STAPR08 "COV BY STATE-SPEC PROG - 12/31/08";
label variable STPRAT31 "ANY TIME COVERAGE BY STATE INS - R3/1";
label variable STPRAT42 "ANY TIME COVERAGE BY STATE INS - R4/2";
label variable STPRAT53 "ANY TIME COVERAGE BY STATE INS - R5/3";
label variable STPRAT08 "ANY TIME COV BY STATE INS - 12/31/08";
label variable EVRUNINS "EVER UNINSURED IN 08 USING PRIV/PUBX";
label variable EVRUNAT "EVER UNINSURED IN 08 USING PRIVAT/PUBATX";
label variable DENTIN31 "DENTAL INSURANCE - RD 3/1";
label variable DENTIN42 "DENTAL INSURANCE - RD 4/2";
label variable DENTIN53 "DENTAL INSURANCE - RD 5/3";
label variable DNTINS31 "DENTAL INS - RD 3/1 IN 08";
label variable DNTINS08 "DENTAL INS - R5/R3 UNTIL 12/31/08";
label variable PMEDIN31 "PRESCRIPTION DRUG INSURANCE - RD 3/1";
label variable PMEDIN42 "PRESCRIPTION DRUG INSURANCE - RD 4/2";
label variable PMEDIN53 "PRESCRIPTION DRUG INSURANCE - RD 5/3";
label variable PMDINS31 "PMED INS - RD 3/1 IN 08";
label variable PMDINS08 "PMED INS - R5/R3 UNTIL 12/31/08";
label variable PMEDUP31 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R3/1";
label variable PMEDUP42 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R4/2";
label variable PMEDUP53 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R5/3";
label variable PMEDPY31 "USUAL 3RD PARTY PAYER FOR PMEDS - R3/1";
label variable PMEDPY42 "USUAL 3RD PARTY PAYER FOR PMEDS - R4/2";
label variable PMEDPY53 "USUAL 3RD PARTY PAYER FOR PMEDS - R5/3";
label variable PMEDOP31 "OUT-OF-POCKET PAYMENT FOR LAST PMED-R3/1";
label variable PMEDOP42 "OUT-OF-POCKET PAYMENT FOR LAST PMED-R4/2";
label variable PMEDOP53 "OUT-OF-POCKET PAYMENT FOR LAST PMED-R5/3";
label variable GDCPBM42 "MCAID/SCHIP/O PUB: PRB GET PERS DOC-R4/2";
label variable APRTRM42 "MCAID/SCHIP/O PUB: NEED APPRV 4 TRT-R4/2";
label variable APRDLM42 "MCAID/SCHIP/O PUB: DLY WAIT 4 APPRV-R4/2";
label variable LKINFM42 "MCAID/SCHIP/O PUB: LOOK 4 PLAN INFO-R4/2";
label variable PBINFM42 "MCAID/SCHIP/O PUB: PROB FINDNG INFO-R4/2";
label variable CSTSVM42 "MCAID/SCHIP/O PUB: CALL CUSTMR SERV-R4/2";
label variable PBSVCM42 "MCAID/SCHIP/O PUB: PRB W CUSRVC HLP-R4/2";
label variable PPRWKM42 "MCAID/SCHIP/O PUB: COMP PLAN PPRWRK-R4/2";
label variable PBPWKM42 "MCAID/SCHIP/O PUB: PRB W PLN PPRWRK-R4/2";
label variable RTPLNM42 "MCAID/SCHIP/O PUB: RATE EXP W PLAN-R4/2";
label variable GDCPBT42 "TRICR/CHAMV: PROB GETTING PERS DOC-R4/2";
label variable APRTRT42 "TRICR/CHAMV: NEED APPRVL 4 TREATMNT-R4/2";
label variable APRDLT42 "TRICR/CHAMV: DELAY WAITING 4 APPRVL-R4/2";
label variable LKINFT42 "TRICR/CHAMV: INFO ON HOW PLAN WORKS-R4/2";
label variable PBINFT42 "TRICR/CHAMV: PROBLEM FINDING INFO-R4/2";
label variable CSTSVT42 "TRICR/CHAMV: CALL CUSTOMER SERVICE-R4/2";
label variable PBSVCT42 "TRICR/CHAMV: PROB GET HELP FR CSRVC-R4/2";
label variable PPRWKT42 "TRICR/CHAMV:FILL OUT PAPERWRK 4 PLN-R4/2";
label variable PBPWKT42 "TRICR/CHAMV: PROB W PLAN PAPERWORK-R4/2";
label variable RTPLNT42 "TRICR/CHAMV: RATE EXPERIENCE W PLAN-R4/2";
label variable TOTTCH08 "TOTAL HEALTH CARE CHARGES 08, EXCL RX";
label variable TOTEXP08 "TOTAL HEALTH CARE EXP 08";
label variable TOTSLF08 "TOTAL AMT PAID BY SELF/FAMILY 08";
label variable TOTMCR08 "TOTAL AMT PAID BY MEDICARE 08";
label variable TOTMCD08 "TOTAL AMT PAID BY MEDICAID 08";
label variable TOTPRV08 "TOTAL AMT PAID BY PRIVATE INS 08";
label variable TOTVA08 "TOTAL AMT PAID BY VA 08";
label variable TOTTRI08 "TOTAL AMT PAID BY TRICARE 08";
label variable TOTOFD08 "TOTAL AMT PAID BY OTHER FEDERAL 08";
label variable TOTSTL08 "TOTAL AMT PAID BY OTH ST/LOCAL 08";
label variable TOTWCP08 "TOTAL AMT PAID BY WORKERS COMP 08";
label variable TOTOPR08 "TOTAL AMT PAID BY OTHER PRIVATE 08";
label variable TOTOPU08 "TOTAL AMT PAID BY OTHER PUBLIC 08";
label variable TOTOSR08 "TOTAL AMT PAID BY OTHER SOURCES 08";
label variable OBTOTV08 "# OFFICE-BASED PROVIDER VISITS 08";
label variable OBVTCH08 "OFFICE-BASED PROVIDER VISIT CHARGES 08";
label variable OBVEXP08 "TOTAL OFFICE-BASED EXP 08";
label variable OBVSLF08 "ALL OFFICE VISITS -SELF/FAMILY AMT 08";
label variable OBVMCR08 "ALL OFFICE VISITS -MEDICARE AMT 08";
label variable OBVMCD08 "ALL OFFICE VISITS -MEDICAID AMT 08";
label variable OBVPRV08 "ALL OFFICE VISITS -PRIVATE INS AMT 08";
label variable OBVVA08 "ALL OFFICE VISITS-VA AMT 08";
label variable OBVTRI08 "ALL OFFICE VISITS-TRICARE AMT 08";
label variable OBVOFD08 "ALL OFFICE VISITS-OTHER FEDERAL AMT 08";
label variable OBVSTL08 "ALL OFFICE VISITS-OTH ST/LOCAL AMT 08";
label variable OBVWCP08 "ALL OFFICE VISITS -WORKERS COMP AMT 08";
label variable OBVOPR08 "ALL OFFICE VISITS - OTH PRIVATE AMT 08";
label variable OBVOPU08 "ALL OFFICE VISITS - OTH PUBLIC AMT 08";
label variable OBVOSR08 "ALL OFF VSTS - OTH UNCLASS SRCE AMT 08";
label variable OBDRV08 "# OFFICE-BASED PHYSICIAN VISITS 08";
label variable OBDTCH08 "OFFICE-BASED PHYSICIAN VISIT CHARGES 08";
label variable OBDEXP08 "TOTAL OFF-BASED DR EXP 08";
label variable OBDSLF08 "DR OFFICE VISITS -SELF/FAMILY AMT 08";
label variable OBDMCR08 "DR OFFICE VISITS -MEDICARE AMT 08";
label variable OBDMCD08 "DR OFFICE VISITS -MEDICAID AMT 08";
label variable OBDPRV08 "DR OFFICE VISITS -PRIVATE INS AMT 08";
label variable OBDVA08 "DR OFFICE VISITS -VA AMT 08";
label variable OBDTRI08 "DR OFFICE VISITS -TRICARE AMT 08";
label variable OBDOFD08 "DR OFFICE VISITS -OTHER FEDERAL AMT 08";
label variable OBDSTL08 "DR OFFICE VISITS -OTH ST/LOCAL AMT 08";
label variable OBDWCP08 "DR OFFICE VISITS -WORKERS COMP AMT 08";
label variable OBDOPR08 "DR OFFICE VISITS - OTH PRIVATE AMT 08";
label variable OBDOPU08 "DR OFFICE VISITS - OTH PUBLIC AMT 08";
label variable OBDOSR08 "DR OFF VSTS - OTH UNCLASS SRCE AMT 08";
label variable OBOTHV08 "# OFFICE-BASED NON-PHYSICAN VISITS 08";
label variable OBOTCH08 "OFFICE-BASED NON-DR VISIT CHARGES 08";
label variable OBOEXP08 "TOTAL OFF-BASED NON-DR EXP 08";
label variable OBOSLF08 "NON-DR OFF VISTS -SELF/FAMILY AMT 08";
label variable OBOMCR08 "NON-DR OFF VISTS -MEDICARE AMT 08";
label variable OBOMCD08 "NON-DR OFF VISTS -MEDICAID AMT 08";
label variable OBOPRV08 "NON-DR OFF VISTS -PRIVATE INS AMT 08";
label variable OBOVA08 "NON-DR OFF VISTS -VA AMT 08";
label variable OBOTRI08 "NON-DR OFF VISTS -TRICARE AMT 08";
label variable OBOOFD08 "NON-DR OFF VISTS -OTHER FEDERAL AMT 08";
label variable OBOSTL08 "NON-DR OFF VISTS -OTH ST/LOCAL AMT 08";
label variable OBOWCP08 "NON-DR OFF VISTS -WORKERS COMP AMT 08";
label variable OBOOPR08 "NON-DR OFF VISTS - OTH PRIVATE AMT 08";
label variable OBOOPU08 "NON-DR OFF VISTS - OTH PUBLIC AMT 08";
label variable OBOOSR08 "NON-DR OF VSTS - OTH UNCLASS SRCE AMT 08";
label variable OBCHIR08 "# OFFICE-BASED CHIROPRACTOR VISITS 08";
label variable OBCTCH08 "OFFICE-BASED CHIRO VISIT CHARGES 08";
label variable OBCEXP08 "TOTAL OFF-BASED CHIRO EXP 08";
label variable OBCSLF08 "CHIRO OFF VISITS -SELF/FAMILY AMT 08";
label variable OBCMCR08 "CHIRO OFF VISITS -MEDICARE AMT 08";
label variable OBCMCD08 "CHIRO OFF VISITS -MEDICAID AMT 08";
label variable OBCPRV08 "CHIRO OFF VISITS -PRIVATE INS AMT 08";
label variable OBCVA08 "CHIRO OFF VISITS -VA AMT 08";
label variable OBCTRI08 "CHIRO OFF VISITS -TRICARE AMT 08";
label variable OBCOFD08 "CHIRO OFF VISITS -OTHER FEDERAL AMT 08";
label variable OBCSTL08 "CHIRO OFF VISITS -OTH ST/LOCAL AMT 08";
label variable OBCWCP08 "CHIRO OFF VISITS -WORKERS COMP AMT 08";
label variable OBCOPR08 "CHIRO OFF VISTS - OTHR PRIVATE AMT 08";
label variable OBCOPU08 "CHIRO OFF VISTS - OTHR PUBLIC AMT 08";
label variable OBCOSR08 "CHIRO OF VSTS - OTHR UNCLASS SRCE AMT 08";
label variable OBNURS08 "# OFF-BASED NURSE/PRACTITIONER VISITS 08";
label variable OBNTCH08 "OFFICE-BASED NURSE/PRAC VISIT CHARGES 08";
label variable OBNEXP08 "TOTAL OFF-BASED NURSE/PRAC 08";
label variable OBNSLF08 "NURSE/PRAC OFF VISITS-SELF/FAMILY AMT 08";
label variable OBNMCR08 "NURSE/PRAC OFF VISITS -MEDICARE AMT 08";
label variable OBNMCD08 "NURSE/PRAC OFF VSTS -MEDICAID AMT 08";
label variable OBNPRV08 "NURSE/PRAC OFF VSTS -PRIVATE INS AMT 08";
label variable OBNVA08 "NURSE/PRAC OFF VSTS -VA AMT 08";
label variable OBNTRI08 "NURSE/PRAC OFF VSTS -TRICARE AMT 08";
label variable OBNOFD08 "NURSE/PRAC OFF VSTS-OTHER FEDERAL AMT 08";
label variable OBNSTL08 "NURSE/PRAC OFF VSTS -OTH ST/LOCAL AMT 08";
label variable OBNWCP08 "NURSE/PRAC OFF VSTS -WORKERS COMP AMT 08";
label variable OBNOPR08 "NURSE/PRAC OFF VSTS - OTH PRIVATE AMT 08";
label variable OBNOPU08 "NURSE/PRAC OFF VSTS - OTH PUBLIC AMT 08";
label variable OBNOSR08 "NRS/PR OF VSTS - OTH UNCLASS SRCE AMT 08";
label variable OBOPTO08 "# OFF-BASED OPTOMETRIST VISITS 08";
label variable OBETCH08 "OFFICE-BASED OPTOMTRIST VISIT CHARGES 08";
label variable OBEEXP08 "TOTAL OFF-BASED OPOTMETRIST EXP 08";
label variable OBESLF08 "OPTOMETRIST OFF VSTS -SELF/FAMILY AMT 08";
label variable OBEMCR08 "OPTOMETRIST OFF VSTS -MEDICARE AMT 08";
label variable OBEMCD08 "OPTOMETRIST OFF VSTS -MEDICAID AMT 08";
label variable OBEPRV08 "OPTOMETRIST OFF VSTS -PRIVATE INS AMT 08";
label variable OBEVA08 "OPTOMETRIST OFF VSTS -VA AMT 08";
label variable OBETRI08 "OPTOMETRIST OFF VSTS -TRICARE AMT 08";
label variable OBEOFD08 "OPTOMETRIST OFF VSTS-OTH FEDERAL AMT 08";
label variable OBESTL08 "OPTOMETRIST OFF VSTS -OTH ST/LOCL AMT 08";
label variable OBEWCP08 "OPTOMETRIST OFF VSTS-WORKERS COMP AMT 08";
label variable OBEOPR08 "OPTOMETRIST OFF VSTS -OTH PRIVATE AMT 08";
label variable OBEOPU08 "OPTOMETRIST OFF VSTS -OTH PUBLIC AMT 08";
label variable OBEOSR08 "OPTOM OF VSTS - OTH UNCLASS SRCE AMT 08";
label variable OBASST08 "# OFF-BASED PHYSICIAN ASSIST VISITS 08";
label variable OBATCH08 "OFFICE-BASED PHYS ASST VISIT CHARGES 08";
label variable OBAEXP08 "TOTAL OFF-BASED PHYS ASS T EXP 08";
label variable OBASLF08 "PHYS ASS T OFF VSTS -SELF/FAMILY AMT 08";
label variable OBAMCR08 "PHYS ASS T OFF VSTS -MEDICARE AMT 08";
label variable OBAMCD08 "PHYS ASS T OFF VSTS -MEDICAID AMT 08";
label variable OBAPRV08 "PHYS ASS T OFF VSTS -PRIVATE INS AMT 08";
label variable OBAVA08 "PHYS ASS T OFF VSTS -VA AMT 08";
label variable OBATRI08 "PHYS ASS T OFF VSTS -TRICARE AMT 08";
label variable OBAOFD08 "PHYS ASS T OFF VSTS -OTHER FED AMT 08";
label variable OBASTL08 "PHYS ASS T OFF VSTS -OTH ST/LOCL AMT 08";
label variable OBAWCP08 "PHYS ASS T OFF VSTS-WORKERS COMP AMT 08";
label variable OBAOPR08 "PHYS ASS T OFF VSTS - OTH PRIVATE AMT 08";
label variable OBAOPU08 "PHYS ASS T OFF VSTS - OTH PUBLIC AMT 08";
label variable OBAOSR08 "P A OFF VSTS - OTH UNCLASS SRCE AMT 08";
label variable OBTHER08 "# OFF-BASED PT/OT VISITS 08";
label variable OBTTCH08 "OFFICE-BASED PT/OC VISIT CHARGES 08";
label variable OBTEXP08 "TOT OFF-BASED PT EXP 08";
label variable OBTSLF08 "PT/OT OFF VISITS -SELF/FAMILY AMT 08";
label variable OBTMCR08 "PT/OT OFF VISITS -MEDICARE AMT 08";
label variable OBTMCD08 "PT/OT OFF VISITS -MEDICAID AMT 08";
label variable OBTPRV08 "PT/OT OFF VISITS -PRIVATE INS AMT 08";
label variable OBTVA08 "PT/OT OFF VISITS -VA AMT 08";
label variable OBTTRI08 "PT/OT OFF VISITS -TRICARE AMT 08";
label variable OBTOFD08 "PT/OT OFF VISITS -OTHER FED AMT 08";
label variable OBTSTL08 "PT/OT OFF VISITS -OTH ST/LOCL AMT 08";
label variable OBTWCP08 "PT/OT OFF VISITS -WORKERS COMP AMT 08";
label variable OBTOPR08 "PT/OT OFF VISITS - OTH PRIVATE AMT 08";
label variable OBTOPU08 "PT/OT OFF VISITS - OTH PUBLIC AMT 08";
label variable OBTOSR08 "PT/OT OF VSTS-OTH UNCLASS SRCE AMT 08";
label variable OPTOTV08 "# OUTPATIENT DEPT PROVIDER VISITS 08";
label variable OPTTCH08 "OPD FACILITY + DR VISIT CHARGES - 08";
label variable OPTEXP08 "TOTAL OUTPATIENT FAC + DR EXP 08";
label variable OPTSLF08 "ALL OPD VSTS-SELF/FAMILY AMT-(FAC+DR) 08";
label variable OPTMCR08 "ALL OPD VSTS-MEDICARE AMT-(FAC+DR) 08";
label variable OPTMCD08 "ALL OPD VSTS-MEDICAID AMT-(FAC+DR) 08";
label variable OPTPRV08 "ALL OPD VSTS-PRIV INS AMT-(FAC+DR) 08";
label variable OPTVA08 "ALL OPD VSTS-VA AMT-(FAC+DR) 08";
label variable OPTTRI08 "ALL OPD VSTS-TRICARE AMT-(FAC+DR) 08";
label variable OPTOFD08 "ALL OPD VSTS-OTHER FED AMT-(FAC+DR) 08";
label variable OPTSTL08 "ALL OPD VSTS-OTH ST/LOCAL AMT(FAC+DR) 08";
label variable OPTWCP08 "ALL OPD VSTS-WORKERS COMP AMT(FAC+DR) 08";
label variable OPTOPR08 "ALL OPD VSTS-OTH PRIVATE AMT-(FAC+DR) 08";
label variable OPTOPU08 "ALL OPD VSTS-OTH PUBLIC AMT-(FAC+DR) 08";
label variable OPTOSR08 "ALL OPD VST-OTH UNCLA SRC AMT(FAC+DR) 08";
label variable OPFTCH08 "OPD PROVIDER VISIT CHARGES - FAC 08";
label variable OPFEXP08 "TOTAL OUTPATIENT FACILITY EXP 08";
label variable OPFSLF08 "ALL OPD VISITS-SELF/FAMILY AMT-FAC 08";
label variable OPFMCR08 "ALL OPD VISITS-MEDICARE AMT-FAC 08";
label variable OPFMCD08 "ALL OPD VISITS-MEDICAID AMT-FAC 08";
label variable OPFPRV08 "ALL OPD VISITS-PRIV INS AMT-FAC 08";
label variable OPFVA08 "ALL OPD VISITS-VA AMT-FAC 08";
label variable OPFTRI08 "ALL OPD VISITS-TRICARE AMT-FAC 08";
label variable OPFOFD08 "ALL OPD VISITS-OTHER FED AMT-FAC 08";
label variable OPFSTL08 "ALL OPD VISITS-OTH ST/LOCAL AMT-FAC 08";
label variable OPFWCP08 "ALL OPD VISITS-WORKERS COMP AMT-FAC 08";
label variable OPFOPR08 "ALL OPD VISITS - OTH PRIVATE AMT-FAC 08";
label variable OPFOPU08 "ALL OPD VISITS - OTH PUBLIC AMT-FAC 08";
label variable OPFOSR08 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-FAC 08";
label variable OPDEXP08 "TOTAL OUTPATIENT PROVIDER EXP 08";
label variable OPDTCH08 "OPD PROVIDER VISIT CHARGES - DR 08";
label variable OPDSLF08 "ALL OPD VISITS-SELF/FAMILY AMT-DR 08";
label variable OPDMCR08 "ALL OPD VISITS-MEDICARE AMT -DR 08";
label variable OPDMCD08 "ALL OPD VISITS-MEDICAID AMT -DR 08";
label variable OPDPRV08 "ALL OPD VISITS-PRIV INS AMT-DR 08";
label variable OPDVA08 "ALL OPD VISITS-VA AMT-DR 08";
label variable OPDTRI08 "ALL OPD VISITS-TRICARE AMT-DR 08";
label variable OPDOFD08 "ALL OPD VISITS-OTHER FED AMT-DR 08";
label variable OPDSTL08 "ALL OPD VISITS-OTH ST/LOCAL AMT-DR 08";
label variable OPDWCP08 "ALL OPD VISITS-WORKERS COMP AMT-DR 08";
label variable OPDOPR08 "ALL OPD VISITS - OTH PRIVATE AMT-DR 08";
label variable OPDOPU08 "ALL OPD VISITS-OTH PUBLIC AMT-DR 08";
label variable OPDOSR08 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-DR 08";
label variable OPDRV08 "# OUTPATIENT DEPT PHYSICIAN VISITS 08";
label variable OPVTCH08 "OPD PHYSICIAN VISIT CHARGES - FAC 08";
label variable OPVEXP08 "TOTAL OUTPATIENT PHYSICIAN - FAC EXP 08";
label variable OPVSLF08 "OPD DR VISITS-SELF/FAMILY AMT-FAC 08";
label variable OPVMCR08 "OPD DR VISITS-MEDICARE AMT-FAC 08";
label variable OPVMCD08 "OPD DR VISITS-MEDICAID AMT-FAC 08";
label variable OPVPRV08 "OPD DR VISITS-PRIV INS AMT-FAC 08";
label variable OPVVA08 "OPD DR VISITS-VA AMT-FAC 08";
label variable OPVTRI08 "OPD DR VISITS-TRICARE AMT-FAC 08";
label variable OPVOFD08 "OPD DR VISITS-OTHER FED AMT-FAC 08";
label variable OPVSTL08 "OPD DR VISITS-OTH ST/LOCAL AMT-FAC 08";
label variable OPVWCP08 "OPD DR VISITS-WORKERS COMP AMT-FAC 08";
label variable OPVOPR08 "OPD DR VISITS - OTH PRIVATE AMT-FAC 08";
label variable OPVOPU08 "OPD DR VISITS-OTH PUBLIC AMT-FAC 08";
label variable OPVOSR08 "OPD DR VSTS-OTH UNCLASS SRCE AMT-FAC 08";
label variable OPSEXP08 "TOTAL OUTPATIENT PHYSICIAN - DR EXP 08";
label variable OPSTCH08 "OPD PHYSICIAN VISIT CHARGES - DR 08";
label variable OPSSLF08 "OPD DR VISITS-SELF/FAMILY AMT-DR 08";
label variable OPSMCR08 "OPD DR VISITS-MEDICARE AMT-DR 08";
label variable OPSMCD08 "OPD DR VISITS-MEDICAID AMT-DR 08";
label variable OPSPRV08 "OPD DR VISITS-PRIV INS AMT-DR 08";
label variable OPSVA08 "OPD DR VISITS-VA AMT-DR 08";
label variable OPSTRI08 "OPD DR VISITS-TRICARE AMT-DR 08";
label variable OPSOFD08 "OPD DR VISITS-OTHER FED AMT-DR 08";
label variable OPSSTL08 "OPD DR VISITS-OTH ST/LOCAL AMT-DR 08";
label variable OPSWCP08 "OPD DR VISITS-WORKERS COMP AMT-DR 08";
label variable OPSOPR08 "OPD DR VISITS - OTH PRIVATE AMT-DR 08";
label variable OPSOPU08 "OPD DR VISITS-OTH PUBLIC AMT-DR 08";
label variable OPSOSR08 "OPD DR VSTS-OTH UNCLASS SRCE AMT-DR 08";
label variable OPOTHV08 "# OUTPATIENT DEPT NON-DR VISITS 08";
label variable OPOTCH08 "OPD NON-PHYS VISIT CHARGES - FAC 08";
label variable OPOEXP08 "TOTAL OUTPATIENT NON-DR - FAC EXP 08";
label variable OPOSLF08 "OPD NON-DR VISITS-SELF/FAM AMT-FAC 08";
label variable OPOMCR08 "OPD NON-DR VISITS-MEDICARE AMT-FAC 08";
label variable OPOMCD08 "OPD NON-DR VISITS-MEDICAID AMT-FAC 08";
label variable OPOPRV08 "OPD NON-DR VISITS-PRIV INS AMT-FAC 08";
label variable OPOVA08 "OPD NON-DR VISITS-VA AMT-FAC 08";
label variable OPOTRI08 "OPD NON-DR VISITS-TRICARE AMT-FAC 08";
label variable OPOOFD08 "OPD NON-DR VISITS-OTHER FED AMT-FAC 08";
label variable OPOSTL08 "OPD NON-DR VISITS-OTH ST/LOC AMT-FAC 08";
label variable OPOWCP08 "OPD NON-DR VISITS-WRKRS COMP AMT-FAC 08";
label variable OPOOPR08 "OPD NON-DR VISITS-OTH PRIVATE AMT-FAC 08";
label variable OPOOPU08 "OPD NON-DR VISITS-OTH PUBLIC AMT-FAC 08";
label variable OPOOSR08 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-FAC 08";
label variable OPPEXP08 "TOTAL OUTPATIENT NON-DR - DR EXP 08";
label variable OPPTCH08 "OPD NON-PHYS VISIT CHARGES - DR 08";
label variable OPPSLF08 "OPD NON-DR VISITS-SELF/FAM AMT-DR 08";
label variable OPPMCR08 "OPD NON-DR VISITS-MEDICARE AMT-DR 08";
label variable OPPMCD08 "OPD NON-DR VISITS-MEDICAID AMT-DR 08";
label variable OPPPRV08 "OPD NON-DR VISITS-PRIV INS AMT-DR 08";
label variable OPPVA08 "OPD NON-DR VISITS-VA AMT-DR 08";
label variable OPPTRI08 "OPD NON-DR VISITS-TRICARE AMT-DR 08";
label variable OPPOFD08 "OPD NON-DR VISITS-OTHER FED AMT-DR 08";
label variable OPPSTL08 "OPD NON-DR VISITS-OTH ST/LOC AMT-DR 08";
label variable OPPWCP08 "OPD NON-DR VISITS-WRKRS COMP AMT-DR 08";
label variable OPPOPR08 "OPD NON-DR VISITS-OTH PRIVATE AMT-DR 08";
label variable OPPOPU08 "OPD NON-DR VISITS-OTH PUBLIC AMT-DR 08";
label variable OPPOSR08 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-DR 08";
label variable AMCHIR08 "# CHIROPRACTR VSTS (OFF+OUTPAT), 2008";
label variable AMCTCH08 "CHIRO AMBULATORY VISIT CHARGES 08";
label variable AMCEXP08 "TOTL AMBULTRY (OB+OP) CHIRO EXP 08";
label variable AMCSLF08 "CHIRO AMB VISITS -SELF/FAMILY AMT 08";
label variable AMCMCR08 "CHIRO AMB VISITS -MEDICARE AMT 08";
label variable AMCMCD08 "CHIRO AMB VISITS -MEDICAID AMT 08";
label variable AMCPRV08 "CHIRO AMB VISITS -PRIVATE INS AMT 08";
label variable AMCVA08 "CHIRO AMB VISITS -VA AMT 08";
label variable AMCTRI08 "CHIRO AMB VISITS-TRICARE AMT 08";
label variable AMCOFD08 "CHIRO AMB VISITS -OTHER FEDERAL AMT 08";
label variable AMCSTL08 "CHIRO AMB VISITS -OTH ST/LOCAL AMT 08";
label variable AMCWCP08 "CHIRO AMB VISITS-WORKERS COMP AMT 08";
label variable AMCOPR08 "CHIRO AMB VISITS - OTH PRIVATE AMT 08";
label variable AMCOPU08 "CHIRO AMB VISITS - OTH PUBLIC AMT 08";
label variable AMCOSR08 "CHIR AMB VSTS - OTH UNCLASS SRCE AMT 08";
label variable AMNURS08 "# AMB NURSE/PRCTITIONR VSTS(OB+OP) 08";
label variable AMNTCH08 "NRS/PRAC AMBULATORY VISIT CHARGES 08";
label variable AMNEXP08 "TOTL AMBULTRY (OB+OP) NURSE/PRAC EXP 08";
label variable AMNSLF08 "NRS/PRAC AMB VSTS -SELF/FAMILY AMT 08";
label variable AMNMCR08 "NRS/PRAC AMB VSTS -MEDICARE AMT 08";
label variable AMNMCD08 "NRS/PRAC AMB VSTS -MEDICAID AMT 08";
label variable AMNPRV08 "NRS/PRAC AMB VSTS -PRIV INS AMT 08";
label variable AMNVA08 "NRS/PRAC AMB VSTS-VA AMT 08";
label variable AMNTRI08 "NRS/PRAC AMB VSTS-TRICARE AMT 08";
label variable AMNOFD08 "NRS/PRAC AMB VSTS-OTHER FEDERAL AMT 08";
label variable AMNSTL08 "NRS/PRAC AMB VSTS-OTH ST/LOCAL AMT 08";
label variable AMNWCP08 "NRS/PRAC AMB VSTS-WORKERS COMP AMT 08";
label variable AMNOPR08 "NRS/PRAC AMB VSTS - OTH PRIVATE AMT 08";
label variable AMNOPU08 "NRS/PRAC AMB VSTS - OTH PUBLIC AMT 08";
label variable AMNOSR08 "NRS/PR AMB VSTS - OTH UNCLAS SRCE AMT 08";
label variable AMOPTO08 "# AMB OPTOMETRIST VSTS (OB+OP) 08";
label variable AMETCH08 "OPTOMETRIST AMBULATORY VISIT CHARGES 08";
label variable AMEEXP08 "TOTL AMBULTRY (OB+OP) OPTOMETRIST EXP 08";
label variable AMESLF08 "OPTMTRIST AMB VSTS -SELF/FAMILY AMT 08";
label variable AMEMCR08 "OPTMTRIST AMB VSTS -MEDICARE AMT 08";
label variable AMEMCD08 "OPTMTRIST AMB VSTS -MEDICAID AMT 08";
label variable AMEPRV08 "OPTMTRIST AMB VSTS -PRIVATE INS AMT 08";
label variable AMEVA08 "OPTMTRIST AMB VSTS-VA AMT 08";
label variable AMETRI08 "OPTMTRIST AMB VSTS-TRICARE AMT 08";
label variable AMEOFD08 "OPTMTRIST AMB VSTS-OTHER FED AMT 08";
label variable AMESTL08 "OPTMTRIST AMB VSTS-OTH ST/LOCAL AMT 08";
label variable AMEWCP08 "OPTMTRIST AMB VSTS-WORKERS COMP AMT 08";
label variable AMEOPR08 "OPTMTRIST AMB VSTS - OTH PRIVATE AMT 08";
label variable AMEOPU08 "OPTMTRIST AMB VSTS - OTH PUBLIC AMT 08";
label variable AMEOSR08 "OPTOM AMB VSTS - OTH UNCLAS SRCE AMT 08";
label variable AMASST08 "# PHYSICIAN ASS T VSTS (OFF+OUPAT), 2008";
label variable AMATCH08 "PHYS ASS T AMBULATORY VISIT CHARGES 08";
label variable AMAEXP08 "TOTL AMBULTRY (OB+OP) PHYS ASS T EXP 08";
label variable AMASLF08 "PHYS ASS T AMB VSTS-SELF/FAMILY AMT 08";
label variable AMAMCR08 "PHYS ASS T AMB VSTS-MEDICARE AMT 08";
label variable AMAMCD08 "PHYS ASS T AMB VSTS-MEDICAID AMT 08";
label variable AMAPRV08 "PHYS ASS T AMB VSTS-PRIVATE INS AMT 08";
label variable AMAVA08 "PHYS ASS T AMB VSTS-VA AMT 08";
label variable AMATRI08 "PHYS ASS T AMB VSTS-TRICARE AMT 08";
label variable AMAOFD08 "PHYS ASS T AMB VSTS -OTHER FED AMT 08";
label variable AMASTL08 "PHYS ASS T AMB VSTS-OTH ST/LOCL AMT 08";
label variable AMAWCP08 "PHYS ASS T AMB VSTS-WRKERS COMP AMT 08";
label variable AMAOPR08 "PHYS ASS T AMB VSTS - OTH PRIVATE AMT 08";
label variable AMAOPU08 "PHYS ASS T AMB VSTS - OTH PUBLIC AMT 08";
label variable AMAOSR08 "P A AMB VSTS- OTH UNCLASS SRCE AMT 08";
label variable AMTHER08 "# AMB PT/OT THRPY VISITS (OB+OP) 08";
label variable AMTTCH08 "PT/OC AMBULATORY VISIT CHARGES 08";
label variable AMTEXP08 "TOTL AMBULTRY (OB+OP) PT/OT EXP 08";
label variable AMTSLF08 "PT/OT AMB VISITS-SELF/FAMILY AMT 08";
label variable AMTMCR08 "PT/OT AMB VISITS-MEDICARE AMT 08";
label variable AMTMCD08 "PT/OT AMB VISITS-MEDICAID AMT 08";
label variable AMTPRV08 "PT/OT AMB VISITS-PRIVATE INS AMT 08";
label variable AMTVA08 "PT/OT AMB VISITS-VA AMT 08";
label variable AMTTRI08 "PT/OT AMB VISITS-TRICARE AMT 08";
label variable AMTOFD08 "PT/OT AMB VISITS -OTHER FED AMT 08";
label variable AMTSTL08 "PT/OT AMB VISITS-OTH ST/LOCL AMT 08";
label variable AMTWCP08 "PT/OT AMB VISITS-WORKERS COMP AMT 08";
label variable AMTOPR08 "PT/OT AMB VISITS - OTH PRIVATE AMT 08";
label variable AMTOPU08 "PT/OT AMB VISITS-OTH PUBLIC AMT 08";
label variable AMTOSR08 "PT/OT AMB VSTS-OTH UNCLAS SRCE AMT 08";
label variable AMTOTC08 "# CALLS W/OFFICE & OUPAT DEPTS, 2008";
label variable AMDRC08 "# CALLS W/OFF & OUTPAT PHYSICIANS, 2008";
label variable ERTOT08 "# EMERGENCY ROOM VISITS 08";
label variable ERTTCH08 "ER FACILITY + DR VISIT CHARGES 08";
label variable ERTEXP08 "TOTAL ER FACILITY + DR EXP 08";
label variable ERTSLF08 "ER -SELF/FAMILY AMT-(FAC+DR) 08";
label variable ERTMCR08 "ER -MEDICARE AMT-(FAC+DR) 08";
label variable ERTMCD08 "ER -MEDICAID AMT-(FAC+DR) 08";
label variable ERTPRV08 "ER -PRIV INS AMT-(FAC+DR) 08";
label variable ERTVA08 "ER -VA AMT-(FAC+DR) 08";
label variable ERTTRI08 "ER -TRICARE AMT-(FAC+DR) 08";
label variable ERTOFD08 "ER -OTHER FED AMT-(FAC+DR) 08";
label variable ERTSTL08 "ER -OTH ST/LOCAL AMT-(FAC+DR) 08";
label variable ERTWCP08 "ER -WORKERS COMP AMT-(FAC+DR) 08";
label variable ERTOPR08 "ER -OTH PRIVATE AMT-(FAC+DR) 08";
label variable ERTOPU08 "ER -OTH PUBLIC AMT-(FAC+DR) 08";
label variable ERTOSR08 "ER -OTH UNCLASS SRCE AMT-(FAC+DR) 08";
label variable ERFTCH08 "ER FACILITY VISIT CHARGES 08";
label variable ERFEXP08 "TOTAL ER FACILITY EXP 08";
label variable ERFSLF08 "ER-SELF/FAMILY AMT - FAC 08";
label variable ERFMCR08 "ER-MEDICARE AMT - FAC 08";
label variable ERFMCD08 "ER-MEDICAID AMT - FAC 08";
label variable ERFPRV08 "ER-PRIVATE INS AMT - FAC 08";
label variable ERFVA08 "ER-VA AMT - FAC 08";
label variable ERFTRI08 "ER-TRICARE AMT - FAC 08";
label variable ERFOFD08 "ER-OTHER FEDERAL AMT - FAC 08";
label variable ERFSTL08 "ER-OTH ST/LOCAL AMT - FAC 08";
label variable ERFWCP08 "ER-WORKERS COMP AMT - FAC 08";
label variable ERFOPR08 "ER-OTHER PRIVATE AMT - FAC 08";
label variable ERFOPU08 "ER-OTHER PUBLIC AMT - FAC 08";
label variable ERFOSR08 "ER-OTH UNCLASS SRCE AMT - FAC 08";
label variable ERDEXP08 "TOTAL EMERGENCY ROOM DR EXP 08";
label variable ERDTCH08 "ER DOCTOR VISIT CHARGES 08";
label variable ERDSLF08 "ER-SELF/FAMILY AMT - DR 08";
label variable ERDMCR08 "ER-MEDICARE AMT - DR 08";
label variable ERDMCD08 "ER-MEDICAID AMT - DR 08";
label variable ERDPRV08 "ER-PRIVATE INS AMT - DR 08";
label variable ERDVA08 "ER-VA AMT - DR 08";
label variable ERDTRI08 "ER-TRICARE AMT - DR 08";
label variable ERDOFD08 "ER-OTHER FED AMT - DR 08";
label variable ERDSTL08 "ER-OTH ST/LOCAL AMT - DR 08";
label variable ERDWCP08 "ER-WORKERS COMP AMT - DR 08";
label variable ERDOPR08 "ER - OTHER PRIVATE AMT - DR 08";
label variable ERDOPU08 "ER - OTHER PUBLIC AMT - DR 08";
label variable ERDOSR08 "ER-OTH UNCLASS SRCE AMT - DR 08";
label variable IPZERO08 "# ZERO-NIGHT HOSPITAL STAYS 08";
label variable ZIFTCH08 "ZERO-NITE IP STAY CHARGES - FAC 08";
label variable ZIFEXP08 "TOTAL ZERO-NITE STAYS FAC EXP 08";
label variable ZIFSLF08 "ZERO-NITE IP STAZ -SELF/FAM AMT-FAC 08";
label variable ZIFMCR08 "ZERO-NITE IP STAZ-MEDICARE AMT-FAC 08";
label variable ZIFMCD08 "ZERO-NITE IP STAZ-MEDICAID AMT-FAC 08";
label variable ZIFPRV08 "ZERO-NITE IP STAZ-PRIV INS AMT-FAC 08";
label variable ZIFVA08 "ZERO-NITE IP STAZ-VA AMT-FAC 08";
label variable ZIFTRI08 "ZERO-NITE IP STAZ-TRICARE AMT-FAC 08";
label variable ZIFOFD08 "ZERO-NITE IP STAZ-OTHER FED AMT-FAC 08";
label variable ZIFSTL08 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-FAC 08";
label variable ZIFWCP08 "ZERO-NITE IP STAZ-WRKERS COMP AMT-FAC 08";
label variable ZIFOPR08 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-FAC 08";
label variable ZIFOPU08 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-FAC 08";
label variable ZIFOSR08 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-FAC 08";
label variable ZIDEXP08 "TOTAL ZERO-NITE STAZ DR 08";
label variable ZIDTCH08 "ZERO-NITE IP STAY CHARGES - DR 08";
label variable ZIDSLF08 "ZERO-NITE IP STAZ-SELF/FAM AMT-DR 08";
label variable ZIDMCR08 "ZERO-NITE IP STAZ-MEDICARE AMT-DR 08";
label variable ZIDMCD08 "ZERO-NITE IP STAZ-MEDICAID AMT-DR 08";
label variable ZIDPRV08 "ZERO-NITE IP STAZ-PRIV INS AMT-DR 08";
label variable ZIDVA08 "ZERO-NITE IP STAZ-VA AMT-DR 08";
label variable ZIDTRI08 "ZERO-NITE IP STAZ-TRICARE AMT-DR 08";
label variable ZIDOFD08 "ZERO-NITE IP STAZ-OTHER FED AMT-DR 08";
label variable ZIDSTL08 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-DR 08";
label variable ZIDWCP08 "ZERO-NITE IP STAZ-WRKERS COMP AMT-DR 08";
label variable ZIDOPR08 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-DR 08";
label variable ZIDOPU08 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-DR 08";
label variable ZIDOSR08 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-DR 08";
label variable IPDIS08 "# HOSPITAL DISCHARGES, 2008";
label variable IPTEXP08 "TOT HOSP IP FACILITY + DR EXP 08";
label variable IPTTCH08 "IP HOSP STAY CHARGES (FAC+DR) 08";
label variable IPTSLF08 "IP HOSP STAZ-SELF/FAMILY AMT-(FAC+DR) 08";
label variable IPTMCR08 "IP HOSP STAZ-MEDICARE AMT-(FAC+DR) 08";
label variable IPTMCD08 "IP HOSP STAZ-MEDICAID AMT-(FAC+DR) 08";
label variable IPTPRV08 "IP HOSP STAZ-PRIV INS AMT-(FAC+DR) 08";
label variable IPTVA08 "IP HOSP STAZ-VA AMT-(FAC+DR) 08";
label variable IPTTRI08 "IP HOSP STAZ-TRICARE AMT-(FAC+DR) 08";
label variable IPTOFD08 "IP HOSP STAZ-OTHER FED AMT-(FAC+DR) 08";
label variable IPTSTL08 "IP HOS STAZ-OTH ST/LOCAL AMT-(FAC+DR) 08";
label variable IPTWCP08 "IP HOS STAZ-WORKERS COMP AMT-(FAC+DR) 08";
label variable IPTOPR08 "IP HOSP STAZ-OTH PRIVATE AMT-(FAC+DR) 08";
label variable IPTOPU08 "IP HOSP STAZ-OTH PUBLIC AMT-(FAC+DR) 08";
label variable IPTOSR08 "IP HOS STAZ-OTH UNCLA SRC AMT(FAC+DR) 08";
label variable IPFEXP08 "TOT HOSP IP FACILITY EXP-INC 0 NITES 08";
label variable IPFTCH08 "IP HOSP STAY CHARGES - FAC 08";
label variable IPFSLF08 "IP HOSP STAZ-SELF/FAMILY AMT-FAC 08";
label variable IPFMCR08 "IP HOSP STAZ-MEDICARE AMT-FAC 08";
label variable IPFMCD08 "IP HOSP STAZ-MEDICAID AMT-FAC 08";
label variable IPFPRV08 "IP HOSP STAZ-PRIV INS AMT-FAC 08";
label variable IPFVA08 "IP HOSP STAZ-VA AMT-FAC 08";
label variable IPFTRI08 "IP HOSP STAZ-TRICARE AMT-FAC 08";
label variable IPFOFD08 "IP HOSP STAZ-OTHER FED AMT-FAC 08";
label variable IPFSTL08 "IP HOSP STAZ-OTH ST/LOCAL AMT-FAC 08";
label variable IPFWCP08 "IP HOSP STAZ-WORKERS COMP AMT-FAC 08";
label variable IPFOPR08 "IP HOSP STAZ - OTH PRIVATE AMT-FAC 08";
label variable IPFOPU08 "IP HOSP STAZ - OTH PUBLIC AMT-FAC 08";
label variable IPFOSR08 "IP HOSP STAZ-OT UNCLASS SRCE AMT-FAC 08";
label variable IPDEXP08 "TOTL HOSP STAZ DR EXP 08";
label variable IPDTCH08 "IP HOSP STAY CHARGES - DR 08";
label variable IPDSLF08 "IP HOSP STAZ-SELF/FAMILY AMT-DR 08";
label variable IPDMCR08 "IP HOSP STAZ-MEDICARE AMT- DR 08";
label variable IPDMCD08 "IP HOSP STAZ-MEDICAID AMT-DR 08";
label variable IPDPRV08 "IP HOSP STAZ-PRIV INS AMT- DR 08";
label variable IPDVA08 "IP HOSP STAZ-VA AMT-DR 08";
label variable IPDTRI08 "IP HOSP STAZ-TRICARE AMT-DR 08";
label variable IPDOFD08 "IP HOSP STAZ-OTHER FED AMT-DR 08";
label variable IPDSTL08 "IP HOSP STAZ-OTH ST/LOCAL AMT-DR 08";
label variable IPDWCP08 "IP HOSP STAZ-WORKERS COMP AMT-DR 08";
label variable IPDOPR08 "IP HOSP STAZ - OTH PRIVATE AMT-DR 08";
label variable IPDOPU08 "IP HOSP STAZ - OTH PUBLIC AMT-DR 08";
label variable IPDOSR08 "IP HOSP STAZ-OT UNCLASS SORCE AMT-DR 08";
label variable IPNGTD08 "# NIGHTS IN HOSP FOR DISCHARGES, 2008";
label variable DVTOT08 "# DENTAL CARE VISITS 08";
label variable DVTTCH08 "TOTAL DENTAL CARE VISIT CHARGES 08";
label variable DVTEXP08 "TOTAL DENTAL CARE EXP 08";
label variable DVTSLF08 "ALL DENTAL CARE -SELF/FAMILY AMT 08";
label variable DVTMCR08 "ALL DENTAL CARE -MEDICARE AMT 08";
label variable DVTMCD08 "ALL DENTAL CARE -MEDICAID AMT 08";
label variable DVTPRV08 "ALL DENTAL CARE -PRIVATE INS AMT 08";
label variable DVTVA08 "ALL DENTAL CARE -VA AMT 08";
label variable DVTTRI08 "ALL DENTAL CARE -TRICARE AMT 08";
label variable DVTOFD08 "ALL DENTAL CARE -OTHER FEDRL AMT 08";
label variable DVTSTL08 "ALL DENTAL CARE -OTH ST/LOCAL AMT 08";
label variable DVTWCP08 "ALL DENTAL CARE -WORKERS COMP AMT 08";
label variable DVTOPR08 "ALL DENTAL CARE - OTH PRIVATE AMT 08";
label variable DVTOPU08 "ALL DENTAL CARE - OTH PUBLIC AMT 08";
label variable DVTOSR08 "ALL DENT CARE-OT UNCLASS SRCE AMT 08";
label variable DVGEN08 "# GENERAL DENTIST VISITS 08";
label variable DVGTCH08 "GENERAL DENTAL CARE VISIT CHARGES 08";
label variable DVGEXP08 "TOTAL GENERAL DENTIST EXP 08";
label variable DVGSLF08 "GNRL DENTAL VISITS -SELF/FAM AMT 08";
label variable DVGMCR08 "GNRL DENTAL VISITS -MEDICARE AMT 08";
label variable DVGMCD08 "GNRL DENTAL VISITS -MEDICAID AMT 08";
label variable DVGPRV08 "GNRL DENTAL VISITS -PRIVATE INS AMT 08";
label variable DVGVA08 "GNRL DENTAL VISITS -VA AMT 08";
label variable DVGTRI08 "GNRL DENTAL VISITS-TRICARE AMT 08";
label variable DVGOFD08 "GNRL DENTAL VISITS- OTHER FED AMT 08";
label variable DVGSTL08 "GNRL DENTAL VISITS - OTH ST/LOCAL AMT 08";
label variable DVGWCP08 "GNRL DENTAL VISITS - WORKERS COMP AMT 08";
label variable DVGOPR08 "GNRL DENTAL VISITS - OTH PRIVATE AMT 08";
label variable DVGOPU08 "GNRL DENTAL VISITS - OTH PUBLIC AMT 08";
label variable DVGOSR08 "GNRL DENT VSTS - OT UNCLASS SRCE AMT 08";
label variable DVORTH08 "# ORTHODONTIST VISITS 08";
label variable DVOTCH08 "ORTHODONTIST VISIT CHARGES 08";
label variable DVOEXP08 "TOTAL ORTHODONTIST EXP 08";
label variable DVOSLF08 "ORTHODONTIST VISITS -SELF/FAMILY AMT 08";
label variable DVOMCR08 "ORTHODONTIST VISITS -MEDICARE AMT 08";
label variable DVOMCD08 "ORTHODONTIST VISITS -MEDICAID AMT 08";
label variable DVOPRV08 "ORTHODONTIST VISITS -PRIVATE INS AMT 08";
label variable DVOVA08 "ORTHODONTIST VISITS-VA AMT 08";
label variable DVOTRI08 "ORTHODONTIST VISITS-TRICARE AMT 08";
label variable DVOOFD08 "ORTHODONTIST VISITS-OTHR FED AMT 08";
label variable DVOSTL08 "ORTHODONTIST VISITS-OTHR ST/LOCAL AMT 08";
label variable DVOWCP08 "ORTHODONTIST VISITS-WORKERS COMP AMT 08";
label variable DVOOPR08 "ORTHODONTIST VISITS-OTHR PRIVATE AMT 08";
label variable DVOOPU08 "ORTHODONTIST VISITS-OTHR PUBLIC AMT 08";
label variable DVOOSR08 "ORTHODONT VSTS - OT UNCLASS SRCE AMT 08";
label variable HHTOTD08 "# HOME HEALTH PROVIDER DAYS, 2008";
label variable HHAGD08 "# AGENCY HOME HEALTH PROVIDER DAYS 08";
label variable HHATCH08 "HOME HEALTH AGENCY VISIT CHARGES 08";
label variable HHAEXP08 "TOTAL HOME HEALTH AGENCY EXP 08";
label variable HHASLF08 "HOME HLTH AGENCY -SELF/FAMILY AMT 08";
label variable HHAMCR08 "HOME HLTH AGENCY -MEDICARE AMT 08";
label variable HHAMCD08 "HOME HLTH AGENCY -MEDICAID AMT 08";
label variable HHAPRV08 "HOME HLTH AGENCY -PRIVATE INS AMT 08";
label variable HHAVA08 "HOME HLTH AGENCY-VA AMT 08";
label variable HHATRI08 "HOME HLTH AGENCY-TRICARE AMT 08";
label variable HHAOFD08 "HOME HLTH AGENCY-OTHER FED AMT 08";
label variable HHASTL08 "HOME HLTH AGENCY-OTHR ST/LOCAL AMT 08";
label variable HHAWCP08 "HOME HLTH AGENCY- WORKERS COMP AMT 08";
label variable HHAOPR08 "HOME HLTH AGENCY - OTH PRIVATE AMT 08";
label variable HHAOPU08 "HOME HLTH AGENCY - OTH PUBLIC AMT 08";
label variable HHAOSR08 "H HLTH AGENCY - OT UNCLASS SRCE AMT 08";
label variable HHINDD08 "# NON-AGENCY HOME HEALTH PROVIDR DAYS 08";
label variable HHNTCH08 "HOME HEALTH NON-AGENCY VISIT CHARGES 08";
label variable HHNEXP08 "TOTAL HOME HEALTH NON-AGNCY EXP 08";
label variable HHNSLF08 "HOME HLTH NON-AGNCY -SELF/FAM AMT 08";
label variable HHNMCR08 "HOME HLTH NON-AGNCY -MEDICARE AMT 08";
label variable HHNMCD08 "HOME HLTH NON-AGNCY -MEDICAID AMT 08";
label variable HHNPRV08 "HOME HLTH NON-AGNCY -PRIV INS AMT 08";
label variable HHNVA08 "HOME HLTH NON-AGNCY-VA AMT 08";
label variable HHNTRI08 "HOME HLTH NON-AGNCY-TRICARE AMT 08";
label variable HHNOFD08 "HOME HLTH NON-AGNCY-OTHR FED AMT 08";
label variable HHNSTL08 "HOME HLTH NON-AGNCY-OTHR ST/LOCL AMT 08";
label variable HHNWCP08 "HOME HLTH NON-AGNCY-WORKERS COMP AMT 08";
label variable HHNOPR08 "HOME HLTH NON-AGNCY-OTH PRIVATE AMT 08";
label variable HHNOPU08 "HOME HLTH NON-AGNCY-OTH PUBLIC AMT 08";
label variable HHNOSR08 "H HLTH NON-AGNCY-OT UNCLASS SRCE AMT 08";
label variable HHINFD08 "# INFORMAL HOME HEALTH PROVIDER DAYS 08";
label variable VISEXP08 "TOTAL GLASSES/CONTACT LENS EXP 08";
label variable VISTCH08 "GLASSES/CONTACT LENSES CHARGES 08";
label variable VISSLF08 "GLASSES/CNTCT LENSES -SELF/FAM AMT 08";
label variable VISMCR08 "GLASSES/CNTCT LENSES-MEDICARE AMT 08";
label variable VISMCD08 "GLASSES/CNTCT LENSES-MEDICAID AMT 08";
label variable VISPRV08 "GLASSES/CNTCT LENSES-PRIV INS AMT 08";
label variable VISVA08 "GLASSES/CNTCT LENSES-VA AMT 08";
label variable VISTRI08 "GLASSES/LENSES-TRICARE AMT 08";
label variable VISOFD08 "GLASSES/CNTCT LENSES-OTHR FED AMT 08";
label variable VISSTL08 "GLASSES/CNTCT LENSES-OTH ST/LOCL AMT 08";
label variable VISWCP08 "GLASSES/CNTCT LENSES-WORKERS COMP AMT 08";
label variable VISOPR08 "GLASSES/CNTCT LENSES-OTH PRIVATE AMT 08";
label variable VISOPU08 "GLASSES/CNTCT LENSES-OTH PUBLIC AMT 08";
label variable VISOSR08 "GLASES/CNTCT LENSE-OT UNCLAS SRCE AMT 08";
label variable OTHTCH08 "OTHER EQUP/SUPPLIES CHARGES 08";
label variable OTHEXP08 "TOT OTHER EQUIP/SPLY (EXCL DIAB) EXP 08";
label variable OTHSLF08 "OTHER EQUP/SUPPLIES -SELF/FAM AMT 08";
label variable OTHMCR08 "OTHER EQUP/SUPPLIES-MEDICARE AMT 08";
label variable OTHMCD08 "OTHER EQUP/SUPPLIES-MEDICAID AMT 08";
label variable OTHPRV08 "OTHER EQUP/SUPPLIES-PRIV INS AMT 08";
label variable OTHVA08 "OTHER EQUP/SUPPLY-VA AMT 08";
label variable OTHTRI08 "OTHER EQUP/SUPPLY-TRICARE AMT 08";
label variable OTHOFD08 "OTHER EQUP/SUPPLIES-OTHR FEDRL AMT 08";
label variable OTHSTL08 "OTHER EQUP/SUPPLY-OTHR ST/LOCAL AMT 08";
label variable OTHWCP08 "OTHER EQUP/SUPPLY -WORKERS COMP AMT 08";
label variable OTHOPR08 "OTHER EQUP/SUPPLY-OTH PRIVATE AMT 08";
label variable OTHOPU08 "OTHER EQUP/SUPPLY -OTH PUBLIC AMT 08";
label variable OTHOSR08 "OTH EQUP/SUPLY -OT UNCLASS SRCE AMT 08";
label variable RXTOT08 "# PRESC MEDS INCL REFILLS 08";
label variable RXEXP08 "TOTAL RX-EXP 08";
label variable RXSLF08 "TOTAL RX-SELF/FAMILY AMT 08";
label variable RXMCR08 "TOTAL RX--MEDICARE AMT 08";
label variable RXMCD08 "TOTAL RX-MEDICAID AMT 08";
label variable RXPRV08 "TOTAL RX-PRIVATE INS AMT 08";
label variable RXVA08 "TOTAL RX-VA AMT 08";
label variable RXTRI08 "TOTAL RX-TRICARE AMT 08";
label variable RXOFD08 "TOTAL RX-OTHER FED AMT 08";
label variable RXSTL08 "TOTAL RX-OTHER ST/LOCAL AMT 08";
label variable RXWCP08 "TOTAL RX-WORKERS COMP AMT 08";
label variable RXOPR08 "TOTAL RX - OTH PRIVATE AMT 08";
label variable RXOPU08 "TOTAL RX - OTH PUBLIC AMT 08";
label variable RXOSR08 "TOT RX-OTH UNCLASS SRCE AMT 08";
label variable TOTPTR08 "TOTAL AMT PAID BY PRV & TRI 08";
label variable TOTOTH08 "TOTAL AMT PAID BY OTH COMBINED 08";
label variable OBVPTR08 "ALL OFFICE VISITS -PRV & TRI AMT 08";
label variable OBVOTH08 "ALL OFFICE VISITS -OTH COMBINED AMT 08";
label variable OBDPTR08 "DR OFFICE VISITS -PRV & TRI AMT 08";
label variable OBDOTH08 "DR OFFICE VISITS -OTH COMBINED AMT 08";
label variable OBOPTR08 "NON-DR OFF VISTS -PRV & TRI AMT 08";
label variable OBOOTH08 "NON-DR OFF VISTS -OTH COMBINED AMT 08";
label variable OBCPTR08 "CHIRO OFF VISITS -PRV & TRI AMT 08";
label variable OBCOTH08 "CHIRO OFF VISITS -OTH COMBINED AMT 08";
label variable OBNPTR08 "NURSE/PRAC OFF VSTS -PRV & TRI AMT 08";
label variable OBNOTH08 "NURSE/PRAC OFF VSTS -OTH COMBINED AMT 08";
label variable OBEPTR08 "OPTOMETRIST OFF VSTS -PRV & TRI AMT 08";
label variable OBEOTH08 "OPTOMETRIST OFF VSTS-OTH COMBINED AMT 08";
label variable OBAPTR08 "PHYS ASST OFF VSTS -PRV & TRI AMT 08";
label variable OBAOTH08 "PHYS ASST OFF VSTS -OTH COMBINED AMT 08";
label variable OBTPTR08 "PT/OT OFF VISITS -PRV & TRI AMT 08";
label variable OBTOTH08 "PT/OT OFF VISITS -OTH COMBINED AMT 08";
label variable OPTPTR08 "ALL OPD VSTS-PRV & TRI AMT (FAC+DR) 08";
label variable OPTOTH08 "ALL OPD VSTS-OTH COMBINED AMT(FAC+DR) 08";
label variable OPFPTR08 "ALL OPD VISITS -PRV & TRI AMT-FAC 08";
label variable OPFOTH08 "ALL OPD VISITS -OTH COMBINED AMT-FAC 08";
label variable OPDPTR08 "ALL OPD VISITS -PRV & TRI AMT -DR 08";
label variable OPDOTH08 "ALL OPD VISITS -OTH COMBINED AMT-DR 08";
label variable OPVPTR08 "OPD DR VISITS -PRV & TRI AMT-FAC 08";
label variable OPVOTH08 "OPD DR VISITS -OTH COMBINED AMT-FAC 08";
label variable OPSPTR08 "OPD DR VISITS -PRV & TRI AMT-DR 08";
label variable OPSOTH08 "OPD DR VISITS -OTH COMBINED AMT-DR 08";
label variable OPOPTR08 "OPD NON-DR VISITS -PRV & TRI AMT-FAC 08";
label variable OPOOTH08 "OPD NON-DR VISITS-OTH COMBINE AMT-FAC 08";
label variable OPPPTR08 "OPD NON-DR VISITS -PRV & TRI AMT-DR 08";
label variable OPPOTH08 "OPD NON-DR VISITS-OTH COMBINE AMT-DR 08";
label variable AMCPTR08 "CHIRO AMB VISITS -PRV & TRI AMT 08";
label variable AMCOTH08 "CHIRO AMB VISITS -OTH COMBINED AMT 08";
label variable AMNPTR08 "NRS/PRAC AMB VSTS -PRV & TRI AMT 08";
label variable AMNOTH08 "NRS/PRAC AMB VSTS -OTH COMBINED AMT 08";
label variable AMEPTR08 "OPTMTRIST AMB VSTS -PRV & TRI AMT 08";
label variable AMEOTH08 "OPTMTRIST AMB VSTS -OTH COMBINED AMT 08";
label variable AMAPTR08 "PHYS ASS T AMB VSTS -PRV & TRI AMT 08";
label variable AMAOTH08 "PHYS ASS T AMB VSTS -OTH COMBINED AMT 08";
label variable AMTPTR08 "PT/OT AMB VISITS -PRV & TRI AMT 08";
label variable AMTOTH08 "PT/OT AMB VISITS -OTH COMBINED AMT 08";
label variable ERTPTR08 "ER-PRV & TRI AMT (FAC+DR) 08";
label variable ERTOTH08 "ER -OTH COMBINED AMT (FAC+DR) 08";
label variable ERFPTR08 "ER-PRV & TRI AMT - FAC 08";
label variable ERFOTH08 "ER-OTH COMBINED AMT - FAC 08";
label variable ERDPTR08 "ER-PRV & TRI AMT - DR 08";
label variable ERDOTH08 "ER-OTH COMBINED AMT - DR 08";
label variable ZIFPTR08 "ZERO-NITE IP STAZ-PRV & TRI AMT-FAC 08";
label variable ZIFOTH08 "ZERO-NITE IP STAZ OTH COMBINE AMT-FAC 08";
label variable ZIDPTR08 "ZERO-NITE IP STAZ-PRV & TRI AMT-DR 08";
label variable ZIDOTH08 "ZERO-NITE IP STAZ-OTH COMBINED AMT-DR 08";
label variable IPTPTR08 "IP HOSP STAZ-PRV & TRI AMT (FAC+DR) 08";
label variable IPTOTH08 "IP HOS STAZ-OTH COMBINED AMT (FAC+DR) 08";
label variable IPFPTR08 "IP HOSP STAZ-PRV & TRI AMT-FAC 08";
label variable IPFOTH08 "IP HOSP STAZ-OTH COMBINED AMT-FAC 08";
label variable IPDPTR08 "IP HOSP STAZ-PRV & TRI AMT-DR 08";
label variable IPDOTH08 "IP HOSP STAZ-OTH COMBINED AMT-DR 08";
label variable DVTPTR08 "ALL DENTAL CARE -PRV & TRI AMT 08";
label variable DVTOTH08 "ALL DENTAL CARE -OTH COMBINED AMT 08";
label variable DVGPTR08 "GNRL DENTAL VISITS -PRV & TRI AMT 08";
label variable DVGOTH08 "GNRL DENTAL VISITS -OTH COMBINED AMT 08";
label variable DVOPTR08 "ORTHODONTIST VISITS -PRV & TRI AMT 08";
label variable DVOOTH08 "ORTHODONTIST VISITS -OTH COMBINED AMT 08";
label variable HHAPTR08 "HOME HLTH AGENCY -PRV & TRI AMT 08";
label variable HHAOTH08 "HOME HLTH AGENCY -OTH COMBINED AMT 08";
label variable HHNPTR08 "HOME HLTH NON-AGNCY -PRV & TRI AMT 08";
label variable HHNOTH08 "HOME HLTH NON-AGNCY -OTH COMBINED AMT 08";
label variable VISPTR08 "GLASSES/CNTCT LENSES -PRV & TRI AMT 08";
label variable VISOTH08 "GLASSES/CNTCT LENSES-OTH COMBINED AMT 08";
label variable OTHPTR08 "OTHER EQUP/SUPPLY -PRV & TRI AMT 08";
label variable OTHOTH08 "OTHER EQUP/SUPPLY -OTH COMBINED AMT 08";
label variable RXPTR08 "TOTAL RX-PRV & TRI AMT 08";
label variable RXOTH08 "TOTAL RX-OTH COMBINED AMT 08";
label variable PERWT08F "FINAL PERSON WEIGHT, 2008";
label variable FAMWT08F "FINAL FAMILY WEIGHT, 2008";
label variable FAMWT08C "POV ADJ FAMILY WGT-CPS FAM ON 12/31/08";
label variable SAQWT08F "FINAL SAQ PERSON WEIGHT, 2008";
label variable DIABW08F "FINAL DIABETES CARE SUPPLEMENT WEIGHT";
label variable VARSTR "VARIANCE ESTIMATION STRATUM - 2008";
label variable VARPSU "VARIANCE ESTIMATION PSU - 2008";


*DEFINE VALUE LABELS FOR REPORTS;
label define H1210001X
         -1 "-1 INAPPLICABLE"
         1 "1 YES" ;

label define H1210002X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1210003X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1210004X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1210005X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210006X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H1210008X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1210009X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H1210010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210012X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H1210014X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1210015X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H1210016X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210017X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1210018X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1210019X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1210020X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1210021X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210022X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210023X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H1210024X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1210025X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210026X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1210027X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1210028X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1210029X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H1210030X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210031X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210032X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210033X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH VERSION SAQ WAS ADMINISTERED"
         2 "2 SPANISH VERSION SAQ WAS ADMINISTERED" ;

label define H1210034X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210035X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210036X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210037X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1210038X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1210039X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1210040X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210041X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1210042X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1210043X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 HAD NO VISITS IN THE LAST 12 MONTHS" ;

label define H1210044X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1210045X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT AT ALL"
         2 "2 A LITTLE BIT"
         3 "3 MODERATELY"
         4 "4 QUITE A BIT"
         5 "5 EXTREMELY" ;

label define H1210046X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1210047X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1210048X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF-ADMINISTERED"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         100 "100 INTERVIEWER ADMINISTERED"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP - /HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 PARTNER'S DAUGHTER"
         33 "33 PARTNER'S SON"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP - /HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 PARENT"
         48 "48 GRANDPARENT"
         49 "49 NOT PERSON ON SAQ LABEL,RELATIONSHIP UNK"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1210049X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1210050X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1210051X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1210052X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1210053X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210054X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1210055X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1210056X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210057X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1210058X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210059X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1210060X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1210061X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1210062X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AFDC"
         2 "2 NOT AFDC" ;

label define H1210063X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1210064X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210065X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210066X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1210067X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210068X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210069X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210070X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210071X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         125 "$125"
         1781 "$1781"
         22 "$22"
         245 "$245" ;

label define H1210072X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210073X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210074X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210075X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210076X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210077X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210078X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210079X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210080X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210081X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210082X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210083X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210084X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         242 "$242"
         45 "$45"
         4511 "$4511"
         79 "$79" ;

label define H1210085X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210086X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210087X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210088X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210089X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210090X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210091X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         14 "$14"
         2 "$2"
         87 "$87" ;

label define H1210092X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210093X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210094X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210095X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210096X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210097X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         10 "$10"
         1146 "$1146" ;

label define H1210098X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210099X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         16 "$16"
         34 "$34" ;

label define H1210100X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210101X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210102X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210103X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210104X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210105X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210106X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         135 "$135"
         71 "$71" ;

label define H1210107X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210108X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         10 "$10"
         47 "$47"
         85 "$85" ;

label define H1210109X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210110X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210111X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210112X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210113X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210114X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210115X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210116X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210117X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210118X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210119X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210120X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210121X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210122X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210123X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210124X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210125X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210126X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210127X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210128X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210129X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210130X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210131X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210132X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210133X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210134X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210135X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210136X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210137X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210138X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210139X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210140X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210141X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         118 "$118"
         165 "$165"
         604 "$604" ;

label define H1210142X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210143X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1014 "$1014"
         289 "$289"
         43 "$43" ;

label define H1210144X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210145X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210146X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210147X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210148X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210149X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210150X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210151X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210152X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210153X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210154X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210155X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210156X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210157X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210158X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 NO VISITS IN LAST 12 MONTHS" ;

label define H1210159X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 NO VISITS IN LAST 12 MONTHS" ;

label define H1210160X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210161X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210162X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 RHEUMATOID ARTHRITIS"
         2 "2 OSTEOARTHRITIS"
         3 "3 NOT SPECIFIED" ;

label define H1210165X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210166X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210167X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210168X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210169X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210170X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210171X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210172X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210173X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210174X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210175X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210176X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210177X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210178X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210179X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST 2 YEARS"
         2 "2 WITHIN PAST 3 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H1210180X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9  NOT ASCERTAINED"
         1 "1 WITHIN PAST 2 YEARS"
         2 "2 WITHIN PAST 3 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H1210181X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN LAST 7 DAYS"
         2 "2 MORE THAN 7, BUT WITHIN LAST 30 DAYS"
         3 "3 MORE THAN 30 DAYS AGO" ;

label define H1210182X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210183X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210184X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210185X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1210186X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1210187X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1210188X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2007 "2007 YEAR"
         2008 "2008 YEAR" ;

label define H1210189X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2008 "2008 YEAR" ;

label define H1210190X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2008 "2008 YEAR"
         2009 "2009 YEAR" ;

label define H1210191X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1210192X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1210193X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210194X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210195X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210196X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210197X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210198X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210199X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210200X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210201X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210202X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210203X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210204X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1210205X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210206X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210207X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210208X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210209X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210210X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1210211X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210212X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1210213X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1210214X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1210215X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1210216X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210217X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210218X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210219X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210220X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210221X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210222X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210223X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210224X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210225X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210226X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210227X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210228X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210229X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210230X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210231X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210232X
         -1 "-1  INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210233X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210234X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210235X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210236X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210237X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210238X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210239X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210240X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210241X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210242X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210243X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210244X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210245X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210246X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210247X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210248X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210249X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H1210250X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210251X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210252X
         -1 "-1  INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210253X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210254X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210255X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210256X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1210257X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210258X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1210259X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1210260X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1210261X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H1210262X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H1210263X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H1210264X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210265X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1210266X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210267X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210268X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210269X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210270X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1210271X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1210272X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210273X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210274X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210275X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210276X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210277X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1210278X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210279X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210280X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210281X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210282X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1210283X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1210284X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210285X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1210286X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210287X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210288X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210289X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210290X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210291X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210292X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210293X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210294X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210295X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H1210296X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H1210297X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H1210298X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210299X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210300X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210301X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210302X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNKNOWN" ;

label define H1210303X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1210304X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210305X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210306X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1210307X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210308X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210309X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210310X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210311X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210312X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210313X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210314X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210315X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210316X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210317X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1210318X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ITEMIZED DEDUCTIONS"
         2 "2 STANDARD DEDUCTIONS" ;

label define H1210319X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210320X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 TWICE A YEAR OR MORE"
         2 "2 ONCE A YEAR"
         3 "3 LESS THAN ONCE A YEAR"
         4 "4 NEVER GO TO DENTIST" ;

label define H1210321X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210322X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210323X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210324X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES" ;

label define H1210325X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1210326X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210327X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210328X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210329X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210330X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES [WAGE AMOUNT CHANGED]"
         2 "2 NO [WAGE AMOUNT DID NOT CHANGE]" ;

label define H1210331X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES [WAGE AMOUNT CHANGED]"
         2 "2 NO [WAGE AMOUNT DID NOT CHANGE]" ;

label define H1210332X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES [WAGE AMOUNT CHANGED]"
         2 "2 NO [WAGE AMOUNT DID NOT CHANGE]" ;

label define H1210333X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1210334X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1210335X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1210336X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210337X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H1210338X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210339X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210340X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1210341X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1210342X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210343X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210344X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210345X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1210346X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1210347X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1210348X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210349X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210350X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEPS IN RU"
         2 "2 DEPS IN AND OUT OF RU"
         3 "3 DEPS OUT OF RU" ;

label define H1210351X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO DEPENDENTS OUTSIDE RU"
         1 "1 ONE DEPENDENT OUTSIDE RU"
         2 "2 TWO DEPENDENTS OUTSIDE RU"
         3 "3 THREE DEPENDENTS OUTSIDE RU" ;

label define H1210352X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NUMBER OF TIMES"
         95 "95 95 TIMES OR MORE"
         96 "96 DID NOT HAVE BLOOD TEST" ;

label define H1210353X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210354X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210355X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210356X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210357X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210358X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210359X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210360X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210361X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT CONFIDENT AT ALL"
         2 "2 SOMEWHAT CONFIDENT"
         3 "3 CONFIDENT"
         4 "4 VERY CONFIDENT" ;

label define H1210362X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210363X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210364X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210365X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210366X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210367X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210368X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210369X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210370X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210371X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210372X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210373X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210374X
         -1 "-1  INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8  DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210375X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210376X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210377X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210378X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210379X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210380X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210381X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210382X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210383X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210384X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210385X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210386X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210387X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210388X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210389X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210390X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210391X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210392X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210393X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210394X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210395X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210396X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210397X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210398X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210399X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210400X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210401X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210402X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210403X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210404X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210405X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         170 "$170"
         380 "$380" ;

label define H1210406X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1005 "$1005"
         1300 "$1300"
         235 "$235" ;

label define H1210407X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210408X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         174 "$174" ;

label define H1210409X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         11253 "$11253"
         5200 "$5200" ;

label define H1210410X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210411X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210412X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210413X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210414X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210415X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210416X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210417X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210418X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         255 "$255"
         58 "$58" ;

label define H1210419X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210420X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210421X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210422X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210423X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210424X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210425X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210426X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210427X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210428X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210429X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210430X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210431X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210432X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210433X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210434X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210435X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210436X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210437X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210438X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO SCHOOL/KINDERGARTEN ONLY"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H1210439X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H1210440X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1210441X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1210442X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1210443X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1210444X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210445X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210446X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         3 "3 JOB DURING RD 3/1 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 3/1" ;

label define H1210447X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         3 "3 JOB DURING RD 4/2 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 4/2" ;

label define H1210448X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         3 "3 JOB DURING RD 5/3 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 5/3" ;

label define H1210449X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210450X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210451X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210452X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210453X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1210454X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1210455X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1210456X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1210457X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2008 "2008 YEAR" ;

label define H1210458X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2008 "2008 YEAR" ;

label define H1210459X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2008 "2008 YEAR" ;

label define H1210460X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2008 "2008 YEAR"
         2009 "2009 YEAR" ;

label define H1210461X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210462X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210463X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210464X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210465X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210466X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         17 "$17" ;

label define H1210467X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210468X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210469X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210470X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210471X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210472X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210473X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210474X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210475X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210476X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210477X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210478X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210479X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210480X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210481X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210482X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210483X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210484X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210485X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210486X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210487X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210488X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210489X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210490X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210491X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210492X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210493X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210494X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210495X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210496X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210497X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210498X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210499X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210500X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210501X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210502X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210503X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210504X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210505X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210506X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210507X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210508X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210509X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210510X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210511X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210512X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210513X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210514X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210515X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210516X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210517X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210518X
         -1 "-1 INAPPLICABLE"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H1210519X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1210520X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1210521X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1210522X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210523X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210524X
         -1 "-1 INAPP, NOT MEM OF 12/31 FAMILY"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H1210525X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210526X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIMARY FILER"
         2 "2 SECONDARY FILER" ;

label define H1210527X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SINGLE"
         2 "2 MARRIED FILING JOINT RETURN"
         3 "3 MARRIED FILING SEPARATELY"
         4 "4 HEAD OF HOUSEHOLD W/ QUALIFYING PERSON"
         5 "5 QUALIFYING WIDOWER W/ DEPENDENT" ;

label define H1210528X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1210529X
         -1 "-1 INAPPLICABLE"
         0 "0 NONRESPONDING 12/31 FAMILY"
         1 "1 RESPONDING 12/31 FAMILY" ;

label define H1210530X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1210531X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1210532X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210533X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210534X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210535X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1210536X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1210537X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1210538X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1210539X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 DO NOT HAVE PERSONAL DOCTOR OR NURSE" ;

label define H1210540X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 DO NOT HAVE PERSONAL DOCTOR OR NURSE" ;

label define H1210541X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H1210542X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DRIVE"
         2 "2 IS DRIVEN"
         3 "3 TAXI, BUS, TRAIN, OTHER PUBLIC TRANSPO"
         4 "4 WALKS" ;

label define H1210543X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210544X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1210545X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210546X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210547X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210548X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210549X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SLIGHT IMPAIRMENT"
         3 "3 MODERATE IMPAIRMENT"
         4 "4 MAJOR IMPAIRMENT"
         5 "5 DEAF" ;

label define H1210550X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210551X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210552X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210553X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210554X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210555X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210556X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210557X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210558X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210559X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210560X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210561X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210562X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210563X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210564X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210565X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210566X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210567X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210568X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210569X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1818 "$1818" ;

label define H1210570X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210571X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210572X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210573X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210574X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210575X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210576X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210577X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         4209 "$4209" ;

label define H1210578X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         600 "$600"
         8320 "$8320" ;

label define H1210579X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210580X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210581X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210582X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210583X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210584X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210585X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         4500 "$4500"
         7600 "$7600" ;

label define H1210586X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210587X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210588X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         2400 "$2400"
         75 "$75" ;

label define H1210589X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         2560 "$2560" ;

label define H1210590X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210591X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210592X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210593X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16-INAPPLICABLE" ;

label define H1210594X
         1 "1 HISPANIC"
         2 "2 NOT HISPANIC" ;

label define H1210595X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PUERTO RICAN"
         2 "2 CUBAN/CUBAN AMERICAN"
         3 "3 DOMINICAN"
         4 "4 MEXICAN/MEXICAN AMERICAN"
         5 "5 CENTRAL OR SOUTH AMERICAN"
         6 "6 NON-HISPANIC"
         91 "91 OTHER LATIN AMERICAN"
         92 "92 OTHER HISPANIC/LATINO" ;

label define H1210596X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1210597X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1210598X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1210599X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1210600X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1210601X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210602X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210603X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210604X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210605X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210606X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210607X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210608X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210609X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210610X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210611X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210612X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210613X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210614X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210615X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210616X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210617X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210618X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210619X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210620X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210621X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210622X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210623X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210624X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210625X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210626X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210627X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210628X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210629X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210630X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210631X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210632X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210633X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210634X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210635X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210636X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210637X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210638X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210639X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210640X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210641X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210642X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210643X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210644X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210645X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210646X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210647X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210648X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210649X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210650X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210651X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210652X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210653X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210654X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210655X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210656X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210657X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210658X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210659X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210660X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210661X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210662X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210663X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210664X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210665X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210666X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210667X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210668X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210669X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210670X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210671X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210672X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210673X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210674X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210675X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210676X
         -1 "-1 INAPPLICABLE"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1210677X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1210678X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1210679X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $72.12"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210680X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $72.12"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210681X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $72.12"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210682X
         0 "0 NO"
         1 "1 YES" ;

label define H1210683X
         0 "0 NO"
         1 "1 YES" ;

label define H1210684X
         0 "0 NO"
         1 "1 YES" ;

label define H1210685X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210686X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210687X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210688X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210689X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210690X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210691X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210692X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210693X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210694X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210695X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1210696X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1210697X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1210698X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210699X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210700X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210701X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210702X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210703X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210704X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210705X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210706X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210707X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210708X
         0 "0 NOT IN-SCOPE - NOT RESP/NOT IN AN RU"
         1 "1 IN-SCOPE ON 12/31/2008"
         2 "2 NOT IN-SCOPE ON 12/31/2008" ;

label define H1210709X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/08"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H1210710X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/08"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H1210711X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/08"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H1210712X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/08"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H1210713X
         0 "0 NOT RECORDED AS BEING INSCOPE"
         1 "1 INSCOPE AT SOME TIME DURING 2008"
         2 "2 OUT-OF-SCOPE FOR ALL OF 2008" ;

label define H1210714X
         1 "1 ANY PRIVATE"
         2 "2 PUBLIC ONLY"
         3 "3 UNINSURED" ;

label define H1210715X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210716X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210717X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210718X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210719X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210720X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210721X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210722X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210723X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210724X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210725X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210726X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210727X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210728X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H1210729X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210730X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ENGLISH & SPANISH"
         91 "91 OTHER" ;

label define H1210731X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210732X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210733X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210734X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210735X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210736X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210737X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210738X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210739X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210740X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210741X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210742X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210743X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210744X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210745X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210746X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210747X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210748X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210749X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210750X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210751X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210752X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210753X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210754X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210755X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210756X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210757X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210758X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210759X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210760X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210761X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210762X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210763X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210764X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210765X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210766X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210767X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210768X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210769X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210770X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210771X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210772X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210773X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210774X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210775X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210776X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210777X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210778X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210779X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210780X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210781X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210782X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1210783X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210784X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210785X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1210786X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1210787X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1210788X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210789X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210790X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210791X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210792X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210793X
         -1 "-1 INAPPLICABLE"
         1 "1 KEY"
         2 "2 NOT KEY" ;

label define H1210794X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210795X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210796X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1210797X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210798X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ANOTHER LANGUAGE" ;

label define H1210799X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210800X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210801X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210802X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210803X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1210804X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1210805X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210806X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210807X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210808X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210809X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 OFFICE"
         2 "2 HOSPITAL, NOT ER"
         3 "3 HOSPITAL, ER" ;

label define H1210810X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210811X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210812X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1210813X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210814X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210815X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210816X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210817X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210818X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1210819X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE" ;

label define H1210820X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1210821X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1210822X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1210823X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210824X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210825X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210826X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210827X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210828X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210829X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210830X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210831X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210832X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210833X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210834X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210835X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210836X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210837X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210838X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210839X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210840X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210841X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210842X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210843X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210844X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210845X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210846X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210847X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210848X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210849X
         1 "1 YES"
         2 "2 NO" ;

label define H1210850X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210851X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210852X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1210853X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1210854X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1210855X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210856X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210857X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210858X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210859X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210860X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210861X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210862X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210863X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1210864X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1210865X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1210866X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210867X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210868X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210869X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210870X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210871X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210872X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210873X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210874X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210875X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210876X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210877X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210878X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210879X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210880X
         1 "1 YES"
         2 "2 NO" ;

label define H1210881X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210882X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210883X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210884X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210885X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210886X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210887X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210888X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210889X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210890X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210891X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210892X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210893X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210894X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210895X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210896X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210897X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1210898X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1210899X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1210900X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1210901X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1210902X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1210903X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1210904X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1210905X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1210906X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210907X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1210908X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210909X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1210910X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1210911X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210912X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1210913X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1210914X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210915X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210916X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H1210917X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210918X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H1210919X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210920X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210921X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210922X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1210923X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1210924X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210925X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1210926X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1210927X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1210928X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1210929X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210930X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210931X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210932X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210933X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1210934X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1210935X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1210936X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210937X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210938X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H1210939X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H1210940X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H1210941X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H1210942X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1210943X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1210944X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210945X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210946X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1210947X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1210948X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210949X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210950X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$72.12"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210951X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$72.12"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210952X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$72.12"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210953X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210954X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210955X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210956X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210957X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210958X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WEEKS"
         2 "2 MONTHS" ;

label define H1210959X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210960X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210961X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1210962X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210963X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210964X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1210965X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1210966X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1210967X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1210968X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210969X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210970X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210971X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210972X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210973X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210974X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210975X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210976X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210977X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210978X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210979X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210980X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210981X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210982X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210983X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210984X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210985X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210986X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210987X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210988X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210989X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210990X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210991X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         2 "$2" ;

label define H1210992X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210993X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210994X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210995X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210996X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210997X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         10 "$10"
         1146 "$1146" ;

label define H1210998X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1210999X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         16 "$16 - $16" ;

label define H1211000X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211001X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211002X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211003X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211004X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211005X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211006X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211007X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211008X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211009X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211010X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211011X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211012X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211013X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211014X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211015X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211016X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211017X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211018X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211019X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211020X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211021X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211022X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         135 "$135"
         71 "$71" ;

label define H1211023X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211024X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         10 "$10"
         47 "$47"
         85 "$85" ;

label define H1211025X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211026X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211027X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211028X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211029X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211030X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211031X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211032X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211033X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211034X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211035X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211036X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211037X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211038X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211039X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211040X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211041X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211042X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211043X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211044X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211045X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211046X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211047X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211048X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211049X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211050X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211051X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211052X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211053X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211054X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211055X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211056X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211057X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211058X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211059X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211060X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211061X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211062X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211063X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211064X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211065X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211066X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211067X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211068X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211069X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211070X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211071X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211072X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211073X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211074X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         165 "$165"
         604 "$604" ;

label define H1211075X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211076X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1014 "$1014"
         289 "$289"
         43 "$43" ;

label define H1211077X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211078X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211079X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211080X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211081X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211082X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211083X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211084X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211085X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211086X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211087X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211088X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211089X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211090X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211091X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211092X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211093X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211094X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211095X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211096X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211097X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211098X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211099X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211100X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211101X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211102X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211103X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211104X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NO WORK EXPERIENCE SINCE 1996"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1211105X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NO WORK EXPERIENCE SINCE 1996"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1211106X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NO WORK EXPERIENCE SINCE 1996"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1211107X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211108X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211109X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211110X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211111X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211112X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211113X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211114X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1211115X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211116X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211117X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211118X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211119X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211120X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211121X
         1 "1 YES"
         2 "2 NO" ;

label define H1211122X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211123X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211124X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211125X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211126X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211127X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211128X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211129X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211130X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211131X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211132X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211133X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211134X
         1 "1 YES"
         2 "2 NO" ;

label define H1211135X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211136X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211137X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211138X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211139X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211140X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211141X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211142X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211143X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211144X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211145X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211146X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211147X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211148X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211149X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211150X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211151X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211152X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211153X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211154X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211155X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211156X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211157X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211158X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211159X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211160X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211161X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211162X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211163X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211164X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211165X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211166X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211167X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211168X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211169X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211170X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211171X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211172X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211173X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211174X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211175X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211176X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211177X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211178X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211179X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211180X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211181X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211182X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211183X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211184X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211185X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211186X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211187X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211188X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211189X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211190X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211191X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211192X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211193X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211194X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211195X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211196X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211197X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         21 "$21" ;

label define H1211198X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211199X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211200X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         173 "$173"
         248 "$248" ;

label define H1211201X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211202X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211203X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211204X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211205X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211206X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211207X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211208X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "$1" ;

label define H1211209X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211210X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211211X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211212X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211213X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211214X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211215X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211216X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         28 "$28"
         577 "$577" ;

label define H1211217X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211218X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211219X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211220X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211221X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211222X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211223X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211224X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211225X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211226X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211227X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211228X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211229X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211230X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211231X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211232X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211233X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211234X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211235X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211236X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211237X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211238X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211239X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211240X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211241X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211242X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211243X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211244X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211245X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211246X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211247X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211248X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211249X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211250X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211251X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211252X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211253X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211254X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211255X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211256X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211257X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211258X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211259X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211260X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211261X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211262X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211263X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1211264X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211265X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211266X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211267X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211268X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211269X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211270X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         11 "$11"
         2400 "$2400" ;

label define H1211271X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211272X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         41 "$41" ;

label define H1211273X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211274X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211275X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211276X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211277X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1211278X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211279X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211280X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211281X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1211282X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211283X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211284X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211285X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211286X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211287X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211288X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211289X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211290X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211291X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211292X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211293X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211294X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211295X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211296X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211297X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211298X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211299X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211300X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211301X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211302X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211303X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211304X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1211305X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1211306X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211307X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1211308X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1211309X
         12 "12 PANEL 12"
         13 "13 PANEL 13" ;

label define H1211310X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1211311X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211312X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211313X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211314X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211315X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211316X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211317X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1211318X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1211319X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1211320X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1211321X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1211322X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1211323X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211324X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211325X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211326X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211327X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211328X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211329X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211330X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211331X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211332X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211333X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211334X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211335X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211336X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211337X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211338X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211339X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211340X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211341X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211342X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211343X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211344X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211345X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211346X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211347X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H1211348X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211349X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211350X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211351X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H1211352X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H1211353X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H1211354X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1211355X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1211356X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT APPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211357X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211358X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOSPITAL CLINIC/OUTPATIENT DEPT"
         2 "2 HOSPITAL EMERGENCY ROOM"
         3 "3 NON-HOSPITAL PLACE" ;

label define H1211359X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211360X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211361X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211362X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1211363X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1211364X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211365X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211366X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211367X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211368X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211369X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211370X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1211371X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1211372X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1211373X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211374X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211375X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211376X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H1211377X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H1211378X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H1211379X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211380X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1211381X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1211382X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211383X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211384X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211385X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211386X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211387X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211388X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211389X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211390X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211391X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211392X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211393X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211394X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211395X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211396X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211397X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211398X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211399X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211400X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211401X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211402X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211403X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211404X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211405X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211406X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211407X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211408X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211409X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211410X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211411X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211412X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211413X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211414X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211415X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211416X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211417X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211418X
         1 "1 POOR/NEGATIVE"
         2 "2 NEAR POOR"
         3 "3 LOW INCOME"
         4 "4 MIDDLE INCOME"
         5 "5 HIGH INCOME" ;

label define H1211419X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211420X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211421X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST-NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H1211422X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST - NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H1211423X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST - NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H1211424X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211425X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211426X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211427X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211428X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211429X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211430X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211431X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211432X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211433X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211434X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211435X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211436X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211437X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211438X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211439X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211440X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211441X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211442X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211443X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211444X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211445X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211446X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211447X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211448X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211449X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211450X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211451X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211452X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211453X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211454X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211455X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211456X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211457X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211458X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211459X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211460X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211461X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211462X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211463X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211464X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211465X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211466X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211467X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211468X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211469X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211470X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211471X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211472X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211473X
         -1 "-1 INAPPLICABLE"
         1 "1 FACILITY"
         2 "2 PERSON"
         3 "3 PERSON IN FACILITY PROVIDER" ;

label define H1211474X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1211475X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1211476X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1211477X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1211478X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211479X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211480X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211481X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211482X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211483X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211484X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211485X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211486X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211487X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211488X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211489X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211490X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1211491X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1211492X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1211493X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1211494X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1211495X
         1 "1 YES"
         2 "2 NO" ;

label define H1211496X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1211497X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1211498X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1211499X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1211500X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1211501X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1211502X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1211503X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1211504X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1211505X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1211506X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211507X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211508X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211509X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211510X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211511X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211512X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211513X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211514X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211515X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211516X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211517X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211518X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1211519X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211520X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211521X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211522X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211523X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211524X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211525X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211526X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211527X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211528X
         -1 "-1 INAPPLICABLE"
         1 "1 ASIAN - NO OTHER RACE REPORTED"
         2 "2 ASIAN - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1211529X
         -1 "-1 INAPPLICABLE"
         1 "1 BLACK - NO OTHER RACE REPORTED"
         2 "2 BLACK - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1211530X
         1 "1 PERSON IS HISPANIC"
         2 "2 PERSON IS BLACK-NO OTH RACE/NOT HISPANIC"
         3 "3 PERSON IS ASIAN-NO OTH RACE/NOT HISPANIC"
         4 "4 OTHER RACE/NOT HISPANIC" ;

label define H1211531X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 WHITE - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1211532X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 BLACK - NO OTHER RACE REPORTED"
         3 "3 AMER INDIAN/ALASKA NATIVE - NO OTH RAC"
         4 "4 ASIAN - NO OTHER RACE REPORTED"
         5 "5 NATIVE HAWAIIAN/PACIFIC ISLANDER-NO OTHR"
         6 "6 MULTIPLE RACES REPORTED" ;

label define H1211533X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1211534X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1211535X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211536X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211537X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1211538X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1211539X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211540X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211541X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1211542X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1211543X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1211544X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1211545X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1211546X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1211547X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1211548X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1211549X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1211550X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1211551X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211552X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211553X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211554X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 FOSTER SISTER"
         48 "48 FOSTER BROTHER"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1211555X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 FOSTER SISTER"
         48 "48 FOSTER BROTHER"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1211556X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 FOSTER SISTER"
         48 "48 FOSTER BROTHER"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1211557X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 FOSTER SISTER"
         48 "48 FOSTER BROTHER"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1211558X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ROUND 1"
         2 "2 ROUND 2"
         3 "3 ROUND 3" ;

label define H1211559X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1211560X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1211561X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1211562X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1211563X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1211564X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1211565X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1211566X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1211567X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1211568X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1211569X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1211570X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1211571X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1211572X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211573X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211574X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211575X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211576X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211577X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211578X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211579X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211580X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211581X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211582X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211583X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211584X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211585X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211586X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211587X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211588X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211589X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1211590X
         0 "0 NOT ELIGIBLE"
         1 "1 ELIGIBLE FOR SAQ - HAS SAQ DATA"
         2 "2 ELIGIBLE FOR SAQ - NO SAQ DATA" ;

label define H1211591X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211592X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1211593X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211594X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211595X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1211596X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211597X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211598X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211599X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALWAYS"
         2 "2 NEARLY ALWAYS"
         3 "3 SOMETIMES"
         4 "4 SELDOM"
         5 "5 NEVER"
         6 "6 NEVER DRIVES/RIDES IN A CAR" ;

label define H1211600X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211601X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211602X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211603X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211604X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211605X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H1211606X
         -1 "-1 INAPPLICABLE"
         0 "0 NO"
         1 "1 YES" ;

label define H1211607X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1211608X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1211609X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211610X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211611X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211612X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1211613X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1211614X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1211615X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1211616X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211617X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211618X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1211619X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1211620X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1211621X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1211622X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1211623X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1211624X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1211625X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1211626X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1211627X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H1211628X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211629X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISABILITY"
         2 "2 SOME OTHER REASON" ;

label define H1211630X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1211631X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211632X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1211633X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1211634X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1211635X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211636X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211637X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211638X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211639X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211640X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211641X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211642X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211643X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211644X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211645X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211646X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211647X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211648X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211649X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211650X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211651X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DET IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1211652X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DET IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1211653X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DET IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1211654X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1211655X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1211656X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1211657X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1211658X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1211659X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1211660X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1211661X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1211662X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1211663X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211664X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1211665X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211666X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H1211667X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H1211668X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211669X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211670X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211671X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211672X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1211673X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211674X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LONG TERM 1040"
         2 "2 SHORT FORM 1040A"
         3 "3 SHORT FORM 1040EZ"
         91 "91 OTHER" ;

label define H1211675X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1211676X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1211677X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1211678X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1211679X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1211680X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1211681X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1211682X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211683X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 15 MINUTES"
         2 "2 15 TO 30 MINUTES"
         3 "3 31 TO 60 MINUTES (1 HOUR)"
         4 "4 61 TO 90 MINUTES"
         5 "5 91 MINUTES TO 120 MINUTES (2 HOURS)"
         6 "6 MORE THAN 120 MINUTES (2 HOURS)" ;

label define H1211684X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211685X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211686X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211687X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211688X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211689X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211690X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211691X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211692X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211693X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211694X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211695X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211696X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211697X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211698X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211699X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211700X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211701X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211702X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1211703X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211704X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211705X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211706X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211707X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211708X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211709X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211710X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1211711X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1211712X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1211713X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211714X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211715X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211716X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211717X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211718X
         1 "1 YES"
         2 "2 NO" ;

label define H1211719X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1211720X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1211721X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1211722X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211723X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211724X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211725X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211726X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1211727X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1211728X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1211729X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211730X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211731X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211732X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211733X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1211734X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1211735X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1211736X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1211737X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV  BY TRICARE/CHAMPVA" ;

label define H1211738X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1211739X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1211740X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1211741X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1211742X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1211743X
         -1 "-1 INAPPLICABLE"
         1 "1 MD - GENERAL/FAMILY PRACTICE"
         10 "10 PHYSICIAN'S ASSISTANT"
         11 "11 OTHER NON-MD PROVIDER"
         12 "12 UNKNOWN"
         13 "13 MD - CARDIOLOGIST"
         14 "14 DOCTOR OF OSTEOPATHY"
         15 "15 MD - ENDOCRINOLOGIST"
         16 "16 MD - GASTROENTEROLOGIST"
         17 "17 MD - GERIATRICIAN"
         18 "18 MD - NEPHROLOGIST"
         19 "19 MD - ONCOLOGIST"
         2 "2 MD - INTERNAL MEDICINE"
         20 "20 MD - PULMONOLOGIST"
         21 "21 MD - RHEUMATOLOGIST"
         22 "22 PSYCHIATRIST/PSYCHOLOGIST"
         23 "23 MD - NEUROLOGIST"
         24 "24 ALTERNATIVE CARE PROVIDER"
         3 "3 MD - PEDIATRICS"
         4 "4 MD - OB/GYN"
         5 "5 MD - SURGERY"
         6 "6 MD - OTHER"
         7 "7 CHIROPRACTOR"
         8 "8 NURSE"
         9 "9 NURSE PRACTITIONER" ;

label define H1211744X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211745X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211746X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1211747X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211748X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1211749X
         1 "1 YES"
         2 "2 NO" ;

label define H1211750X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211751X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211752X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211753X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211754X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211755X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1211756X
         -1 "-1 Inapplicable"
         -7 "-7 Refused"
         -8 "-8 DK"
         -9 "-9 Not Ascertained" ;

label define H1211757X
         -1 "-1 Inapplicable"
         -7 "-7 RF"
         -8 "-8 DK"
         -9 "-9 Not Ascertained"
         1 "1 Yes"
         2 "2 No" ;

label define H1211758X
         1 "1 ORIGINAL RESPONSE USED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1211759X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211760X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211761X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 IMPAIRED NEAR, BUT NOT FAR"
         4 "4 IMPAIRED BOTH NEAR AND FAR"
         5 "5 BLIND" ;

label define H1211762X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211763X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211764X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211765X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211766X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211767X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211768X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211769X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211770X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211771X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211772X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211773X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211774X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         50 "$50" ;

label define H1211775X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211776X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         148 "$148"
         213 "$213" ;

label define H1211777X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211778X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1211779X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211780X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211781X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211782X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211783X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211784X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211785X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211786X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211787X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211788X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211789X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211790X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211791X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211792X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211793X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211794X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1211795X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS" ;

label define H1211796X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211797X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1211798X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1211799X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS" ;

label define H1211800X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1211801X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1211802X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1211803X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1211804X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1211805X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1211806X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1211807X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1211808X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1211809X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211810X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211811X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211812X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211813X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211814X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211815X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1211816X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1211817X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211818X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211819X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211820X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1211821X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211822X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1211823X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE ANOTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H1211824X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE OTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H1211825X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEM"
         91 "91 SOME OTHER REASON" ;

label define H1211826X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEM"
         91 "91 SOME OTHER REASON" ;

label define H1211827X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEMS"
         91 "91 SOME OTHER REASON" ;

label define H1211828X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELDOM OR NEVER SICK"
         10 "10 INSURANCE-RELATED REASONS"
         11 "11 JOB-RELATED REASONS"
         12 "12 LOOKING FOR A NEW DOCTOR/NO DOCTOR YET"
         13 "13 USC DOCTOR IS SOMEWHERE ELSE"
         14 "14 DON'T LIKE/DON'T TRUST DOCTORS"
         15 "15 HEALTH-RELATED REASONS"
         16 "16 NEWBORN - NO DOCTOR YET"
         17 "17 SELF, RELATIVE, OR FRIEND IS A DOCTOR"
         19 "19 CARE AVAILABLE ON JOB"
         2 "2 RECENTLY MOVED TO AREA"
         20 "20 WILL NOT GO TO THE DOCTOR"
         21 "21 PROBLEMS WITH TIME AND TRANSPORTATION"
         22 "22 GOES TO HOSPITAL/EMERGENCY ROOM/CLINIC"
         23 "23 USES ALTERNATIVE CARE"
         3 "3 DON'T KNOW WHERE TO GO"
         4 "4 USC IN AREA NOT AVAILABLE"
         5 "5 CAN'T FIND PROVIDER WHO SPEAKS LANGUAGE"
         6 "6 GOES DIFFERENT PLACES FOR DIFF NEEDS"
         7 "7 JUST CHANGED INSURANCE PLANS"
         8 "8 DON'T USE DOCS/TREAT SELF"
         9 "9 COST OF MEDICAL CARE"
         91 "91 OTHER REASON" ;

label define H1211829X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211830X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211831X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211832X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         55 "$55" ;

label define H1211833X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211834X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211835X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211836X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211837X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211838X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211839X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211840X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         55 "$55" ;

label define H1211841X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211842X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1050 "$1050"
         32 "$32" ;

label define H1211843X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211844X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1332 "$1332"
         216 "$216" ;

label define H1211845X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211846X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211847X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211848X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211849X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         6039 "$6039"
         63 "$63" ;

label define H1211850X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211851X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         11864 "$11864" ;

label define H1211852X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         63 "$63" ;

label define H1211853X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211854X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211855X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211856X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211857X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1211858X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         11689 "$11689"
         312 "$312" ;

label define H1211859X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         2 "$2"
         279 "$279" ;

label define H1211860X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         2304 "$2304" ;

* ASSOCIATE VARIABLES WITH VALUE LABEL DEFINITIONS;
label value ACCELI42 H1210001X;
label value ACTDTY31 H1210002X;
label value ACTDTY42 H1210003X;
label value ACTDTY53 H1210004X;
label value ACTLIM31 H1210005X;
label value ACTLIM53 H1210006X;
label value ADAPPT42 H1210007X;
label value ADCAPE42 H1210008X;
label value ADCLIM42 H1210009X;
label value ADCMPD42 H1210010X;
label value ADCMPM42 H1210011X;
label value ADCMPY42 H1210012X;
label value ADDAYA42 H1210013X;
label value ADDOWN42 H1210014X;
label value ADDPRS42 H1210015X;
label value ADDRBP42 H1210016X;
label value ADEFRT42 H1210017X;
label value ADEGMC42 H1210018X;
label value ADEXPL42 H1210019X;
label value ADGENH42 H1210020X;
label value ADHDADDX H1210021X;
label value ADHDAGED H1210022X;
label value ADHECR42 H1210023X;
label value ADHOPE42 H1210024X;
label value ADILCR42 H1210025X;
label value ADILWW42 H1210026X;
label value ADINSA42 H1210027X;
label value ADINSB42 H1210028X;
label value ADINTR42 H1210029X;
label value ADL3MO31 H1210030X;
label value ADL3MO42 H1210031X;
label value ADL3MO53 H1210032X;
label value ADLANG42 H1210033X;
label value ADLHLP31 H1210034X;
label value ADLHLP42 H1210035X;
label value ADLHLP53 H1210036X;
label value ADLIST42 H1210037X;
label value ADMALS42 H1210038X;
label value ADMWLM42 H1210039X;
label value ADNDCR42 H1210040X;
label value ADNERV42 H1210041X;
label value ADNRGY42 H1210042X;
label value ADNSMK42 H1210043X;
label value ADOVER42 H1210044X;
label value ADPAIN42 H1210045X;
label value ADPALS42 H1210046X;
label value ADPRTM42 H1210047X;
label value ADPRX42 H1210048X;
label value ADPWLM42 H1210049X;
label value ADRESP42 H1210050X;
label value ADREST42 H1210051X;
label value ADRISK42 H1210052X;
label value ADRTCR42 H1210053X;
label value ADRTWW42 H1210054X;
label value ADSAD42 H1210055X;
label value ADSMOK42 H1210056X;
label value ADSOCA42 H1210057X;
label value ADSPEC42 H1210058X;
label value ADSPRF42 H1210059X;
label value ADUPRO42 H1210060X;
label value ADWRTH42 H1210061X;
label value AFDC08 H1210062X;
label value AFTHOU42 H1210063X;
label value AIDHLP31 H1210064X;
label value AIDHLP53 H1210065X;
label value ALIIMP08 H1210066X;
label value ALIMP08X H1210067X;
label value AMAEXP08 H1210068X;
label value AMAMCD08 H1210069X;
label value AMAMCR08 H1210070X;
label value AMAOFD08 H1210071X;
label value AMAOPR08 H1210072X;
label value AMAOPU08 H1210073X;
label value AMAOSR08 H1210074X;
label value AMAOTH08 H1210075X;
label value AMAPRV08 H1210076X;
label value AMAPTR08 H1210077X;
label value AMASLF08 H1210078X;
label value AMASST08 H1210079X;
label value AMASTL08 H1210080X;
label value AMATCH08 H1210081X;
label value AMATRI08 H1210082X;
label value AMAVA08 H1210083X;
label value AMAWCP08 H1210084X;
label value AMCEXP08 H1210085X;
label value AMCHIR08 H1210086X;
label value AMCMCD08 H1210087X;
label value AMCMCR08 H1210088X;
label value AMCOFD08 H1210089X;
label value AMCOPR08 H1210090X;
label value AMCOPU08 H1210091X;
label value AMCOSR08 H1210092X;
label value AMCOTH08 H1210093X;
label value AMCPRV08 H1210094X;
label value AMCPTR08 H1210095X;
label value AMCSLF08 H1210096X;
label value AMCSTL08 H1210097X;
label value AMCTCH08 H1210098X;
label value AMCTRI08 H1210099X;
label value AMCVA08 H1210100X;
label value AMCWCP08 H1210101X;
label value AMDRC08 H1210102X;
label value AMEEXP08 H1210103X;
label value AMEMCD08 H1210104X;
label value AMEMCR08 H1210105X;
label value AMEOFD08 H1210106X;
label value AMEOPR08 H1210107X;
label value AMEOPU08 H1210108X;
label value AMEOSR08 H1210109X;
label value AMEOTH08 H1210110X;
label value AMEPRV08 H1210111X;
label value AMEPTR08 H1210112X;
label value AMESLF08 H1210113X;
label value AMESTL08 H1210114X;
label value AMETCH08 H1210115X;
label value AMETRI08 H1210116X;
label value AMEVA08 H1210117X;
label value AMEWCP08 H1210118X;
label value AMNEXP08 H1210119X;
label value AMNMCD08 H1210120X;
label value AMNMCR08 H1210121X;
label value AMNOFD08 H1210122X;
label value AMNOPR08 H1210123X;
label value AMNOPU08 H1210124X;
label value AMNOSR08 H1210125X;
label value AMNOTH08 H1210126X;
label value AMNPRV08 H1210127X;
label value AMNPTR08 H1210128X;
label value AMNSLF08 H1210129X;
label value AMNSTL08 H1210130X;
label value AMNTCH08 H1210131X;
label value AMNTRI08 H1210132X;
label value AMNURS08 H1210133X;
label value AMNVA08 H1210134X;
label value AMNWCP08 H1210135X;
label value AMOPTO08 H1210136X;
label value AMTEXP08 H1210137X;
label value AMTHER08 H1210138X;
label value AMTMCD08 H1210139X;
label value AMTMCR08 H1210140X;
label value AMTOFD08 H1210141X;
label value AMTOPR08 H1210142X;
label value AMTOPU08 H1210143X;
label value AMTOSR08 H1210144X;
label value AMTOTC08 H1210145X;
label value AMTOTH08 H1210146X;
label value AMTPRV08 H1210147X;
label value AMTPTR08 H1210148X;
label value AMTSLF08 H1210149X;
label value AMTSTL08 H1210150X;
label value AMTTCH08 H1210151X;
label value AMTTRI08 H1210152X;
label value AMTVA08 H1210153X;
label value AMTWCP08 H1210154X;
label value ANGIAGED H1210155X;
label value ANGIDX H1210156X;
label value ANYLIM08 H1210157X;
label value APRDLM42 H1210158X;
label value APRDLT42 H1210159X;
label value APRTRM42 H1210160X;
label value APRTRT42 H1210161X;
label value ARTHAGED H1210162X;
label value ARTHDX H1210163X;
label value ARTHTYPE H1210164X;
label value ASACUT53 H1210165X;
label value ASATAK31 H1210166X;
label value ASATAK53 H1210167X;
label value ASDALY53 H1210168X;
label value ASEVFL53 H1210169X;
label value ASIANP42 H1210170X;
label value ASMRCN53 H1210171X;
label value ASPKFL53 H1210172X;
label value ASPREV53 H1210173X;
label value ASPRIN53 H1210174X;
label value ASSTIL31 H1210175X;
label value ASSTIL53 H1210176X;
label value ASTHAGED H1210177X;
label value ASTHDX H1210178X;
label value ASTHEP31 H1210179X;
label value ASTHEP53 H1210180X;
label value ASWNFL53 H1210181X;
label value BEGRFD31 H1210182X;
label value BEGRFD42 H1210183X;
label value BEGRFD53 H1210184X;
label value BEGRFM31 H1210185X;
label value BEGRFM42 H1210186X;
label value BEGRFM53 H1210187X;
label value BEGRFY31 H1210188X;
label value BEGRFY42 H1210189X;
label value BEGRFY53 H1210190X;
label value BENDIF31 H1210191X;
label value BENDIF53 H1210192X;
label value BLCKPR42 H1210193X;
label value BLDRAGED H1210194X;
label value BLDRREMS H1210195X;
label value BLIND42 H1210196X;
label value BLODAGED H1210197X;
label value BLODREMS H1210198X;
label value BMINDX53 H1210199X;
label value BONEAGED H1210200X;
label value BONEREMS H1210201X;
label value BOOST42 H1210202X;
label value BOWEL53 H1210203X;
label value BPCHEK53 H1210204X;
label value BPMLDX H1210205X;
label value BPMONT53 H1210206X;
label value BRAIAGED H1210207X;
label value BRAIREMS H1210208X;
label value BRSTAGED H1210209X;
label value BRSTEX53 H1210210X;
label value BRSTREMS H1210211X;
label value BSNTY31 H1210212X;
label value BSNTY42 H1210213X;
label value BSNTY53 H1210214X;
label value BUSIMP08 H1210215X;
label value CABLADDR H1210216X;
label value CABLOOD H1210217X;
label value CABONE H1210218X;
label value CABRAIN H1210219X;
label value CABREAST H1210220X;
label value CACERVIX H1210221X;
label value CACOLON H1210222X;
label value CAKIDNEY H1210223X;
label value CALARYNX H1210224X;
label value CALEUKEM H1210225X;
label value CALIVER H1210226X;
label value CALUNG H1210227X;
label value CALYMPH H1210228X;
label value CAMELANO H1210229X;
label value CAMOUTH H1210230X;
label value CAMUSCLE H1210231X;
label value CANCERDX H1210232X;
label value CAOTHER H1210233X;
label value CAOVARY H1210234X;
label value CAPANCRS H1210235X;
label value CAPROSTA H1210236X;
label value CARECO42 H1210237X;
label value CARECTUM H1210238X;
label value CASHP08X H1210239X;
label value CASKINDK H1210240X;
label value CASKINNM H1210241X;
label value CASTOMCH H1210242X;
label value CATESTIS H1210243X;
label value CATHROAT H1210244X;
label value CATHYROD H1210245X;
label value CAUTERUS H1210246X;
label value CERVAGED H1210247X;
label value CERVREMS H1210248X;
label value CHAPPT42 H1210249X;
label value CHBMIX42 H1210250X;
label value CHBRON31 H1210251X;
label value CHBRON53 H1210252X;
label value CHCOUN42 H1210253X;
label value CHDAGED H1210254X;
label value CHDDX H1210255X;
label value CHECK53 H1210256X;
label value CHEMPB42 H1210257X;
label value CHENEC42 H1210258X;
label value CHEXPL42 H1210259X;
label value CHEYRE42 H1210260X;
label value CHGJ3142 H1210261X;
label value CHGJ4253 H1210262X;
label value CHHECR42 H1210263X;
label value CHILCR42 H1210264X;
label value CHILWW42 H1210265X;
label value CHLDP08X H1210266X;
label value CHLICO42 H1210267X;
label value CHLIHB42 H1210268X;
label value CHLIMI42 H1210269X;
label value CHLIMP08 H1210270X;
label value CHLIST42 H1210271X;
label value CHNDCR42 H1210272X;
label value CHOIC31 H1210273X;
label value CHOIC42 H1210274X;
label value CHOIC53 H1210275X;
label value CHOLAGED H1210276X;
label value CHOLCK53 H1210277X;
label value CHOLDX H1210278X;
label value CHPMCN42 H1210279X;
label value CHPMED42 H1210280X;
label value CHPMHB42 H1210281X;
label value CHPRTM42 H1210282X;
label value CHRESP42 H1210283X;
label value CHRTCR42 H1210284X;
label value CHRTWW42 H1210285X;
label value CHSERV42 H1210286X;
label value CHSPEC42 H1210287X;
label value CHSRCN42 H1210288X;
label value CHSRHB42 H1210289X;
label value CHTHCO42 H1210290X;
label value CHTHER42 H1210291X;
label value CHTHHB42 H1210292X;
label value CLINIC42 H1210293X;
label value CLMDEP08 H1210294X;
label value CLMHIP08 H1210295X;
label value COGLIM31 H1210296X;
label value COGLIM53 H1210297X;
label value COLOAGED H1210298X;
label value COLOREMS H1210299X;
label value COVRMM H1210300X;
label value COVRYY H1210301X;
label value CSHCN42 H1210302X;
label value CSHIMP08 H1210303X;
label value CSTSVM42 H1210304X;
label value CSTSVT42 H1210305X;
label value DADPRO42 H1210306X;
label value DDBDYS31 H1210307X;
label value DDBDYS42 H1210308X;
label value DDBDYS53 H1210309X;
label value DDNSCL31 H1210310X;
label value DDNSCL42 H1210311X;
label value DDNSCL53 H1210312X;
label value DDNWRK31 H1210313X;
label value DDNWRK42 H1210314X;
label value DDNWRK53 H1210315X;
label value DEAF42 H1210316X;
label value DECIDE42 H1210317X;
label value DEDUCT08 H1210318X;
label value DENTAL42 H1210319X;
label value DENTCK53 H1210320X;
label value DENTIN31 H1210321X;
label value DENTIN42 H1210322X;
label value DENTIN53 H1210323X;
label value DEPDNT08 H1210324X;
label value DFTOUS42 H1210325X;
label value DIABAGED H1210326X;
label value DIABDX H1210327X;
label value DIABW08F H1210328X;
label value DIFFPL42 H1210329X;
label value DIFFWG31 H1210330X;
label value DIFFWG42 H1210331X;
label value DIFFWG53 H1210332X;
label value DISVW31X H1210333X;
label value DISVW42X H1210334X;
label value DISVW53X H1210335X;
label value DIVDP08X H1210336X;
label value DIVIMP08 H1210337X;
label value DKWHRU42 H1210338X;
label value DNDLAY42 H1210339X;
label value DNDLPR42 H1210340X;
label value DNDLRS42 H1210341X;
label value DNTINS08 H1210342X;
label value DNTINS31 H1210343X;
label value DNUNAB42 H1210344X;
label value DNUNPR42 H1210345X;
label value DNUNRS42 H1210346X;
label value DOBMM H1210347X;
label value DOBYY H1210348X;
label value DOCELS42 H1210349X;
label value DPINRU08 H1210350X;
label value DPOTSD08 H1210351X;
label value DSA1C53 H1210352X;
label value DSCB0753 H1210353X;
label value DSCGRP53 H1210354X;
label value DSCH0753 H1210355X;
label value DSCH0853 H1210356X;
label value DSCH0953 H1210357X;
label value DSCHNV53 H1210358X;
label value DSCINT53 H1210359X;
label value DSCNPC53 H1210360X;
label value DSCONF53 H1210361X;
label value DSCPCP53 H1210362X;
label value DSCPHN53 H1210363X;
label value DSDIA53 H1210364X;
label value DSDIET53 H1210365X;
label value DSEB0753 H1210366X;
label value DSEY0753 H1210367X;
label value DSEY0853 H1210368X;
label value DSEY0953 H1210369X;
label value DSEYNV53 H1210370X;
label value DSEYPR53 H1210371X;
label value DSFB0753 H1210372X;
label value DSFL0753 H1210373X;
label value DSFL0853 H1210374X;
label value DSFL0953 H1210375X;
label value DSFLNV53 H1210376X;
label value DSFT0753 H1210377X;
label value DSFT0853 H1210378X;
label value DSFT0953 H1210379X;
label value DSFTNV53 H1210380X;
label value DSINSU53 H1210381X;
label value DSKIDN53 H1210382X;
label value DSMED53 H1210383X;
label value DSPRX53 H1210384X;
label value DSVB0753 H1210385X;
label value DVGEN08 H1210386X;
label value DVGEXP08 H1210387X;
label value DVGMCD08 H1210388X;
label value DVGMCR08 H1210389X;
label value DVGOFD08 H1210390X;
label value DVGOPR08 H1210391X;
label value DVGOPU08 H1210392X;
label value DVGOSR08 H1210393X;
label value DVGOTH08 H1210394X;
label value DVGPRV08 H1210395X;
label value DVGPTR08 H1210396X;
label value DVGSLF08 H1210397X;
label value DVGSTL08 H1210398X;
label value DVGTCH08 H1210399X;
label value DVGTRI08 H1210400X;
label value DVGVA08 H1210401X;
label value DVGWCP08 H1210402X;
label value DVOEXP08 H1210403X;
label value DVOMCD08 H1210404X;
label value DVOMCR08 H1210405X;
label value DVOOFD08 H1210406X;
label value DVOOPR08 H1210407X;
label value DVOOPU08 H1210408X;
label value DVOOSR08 H1210409X;
label value DVOOTH08 H1210410X;
label value DVOPRV08 H1210411X;
label value DVOPTR08 H1210412X;
label value DVORTH08 H1210413X;
label value DVOSLF08 H1210414X;
label value DVOSTL08 H1210415X;
label value DVOTCH08 H1210416X;
label value DVOTRI08 H1210417X;
label value DVOVA08 H1210418X;
label value DVOWCP08 H1210419X;
label value DVTEXP08 H1210420X;
label value DVTMCD08 H1210421X;
label value DVTMCR08 H1210422X;
label value DVTOFD08 H1210423X;
label value DVTOPR08 H1210424X;
label value DVTOPU08 H1210425X;
label value DVTOSR08 H1210426X;
label value DVTOT08 H1210427X;
label value DVTOTH08 H1210428X;
label value DVTPRV08 H1210429X;
label value DVTPTR08 H1210430X;
label value DVTSLF08 H1210431X;
label value DVTSTL08 H1210432X;
label value DVTTCH08 H1210433X;
label value DVTTRI08 H1210434X;
label value DVTVA08 H1210435X;
label value DVTWCP08 H1210436X;
label value EATHLT42 H1210437X;
label value EDUCYR H1210438X;
label value EICRDT08 H1210439X;
label value ELGRND08 H1210440X;
label value ELGRND31 H1210441X;
label value ELGRND42 H1210442X;
label value ELGRND53 H1210443X;
label value EMPHAGED H1210444X;
label value EMPHDX H1210445X;
label value EMPST31 H1210446X;
label value EMPST42 H1210447X;
label value EMPST53 H1210448X;
label value ENDRFD08 H1210449X;
label value ENDRFD31 H1210450X;
label value ENDRFD42 H1210451X;
label value ENDRFD53 H1210452X;
label value ENDRFM08 H1210453X;
label value ENDRFM31 H1210454X;
label value ENDRFM42 H1210455X;
label value ENDRFM53 H1210456X;
label value ENDRFY08 H1210457X;
label value ENDRFY31 H1210458X;
label value ENDRFY42 H1210459X;
label value ENDRFY53 H1210460X;
label value ENGCMF42 H1210461X;
label value ENGSPK42 H1210462X;
label value ERDEXP08 H1210463X;
label value ERDMCD08 H1210464X;
label value ERDMCR08 H1210465X;
label value ERDOFD08 H1210466X;
label value ERDOPR08 H1210467X;
label value ERDOPU08 H1210468X;
label value ERDOSR08 H1210469X;
label value ERDOTH08 H1210470X;
label value ERDPRV08 H1210471X;
label value ERDPTR08 H1210472X;
label value ERDSLF08 H1210473X;
label value ERDSTL08 H1210474X;
label value ERDTCH08 H1210475X;
label value ERDTRI08 H1210476X;
label value ERDVA08 H1210477X;
label value ERDWCP08 H1210478X;
label value ERFEXP08 H1210479X;
label value ERFMCD08 H1210480X;
label value ERFMCR08 H1210481X;
label value ERFOFD08 H1210482X;
label value ERFOPR08 H1210483X;
label value ERFOPU08 H1210484X;
label value ERFOSR08 H1210485X;
label value ERFOTH08 H1210486X;
label value ERFPRV08 H1210487X;
label value ERFPTR08 H1210488X;
label value ERFSLF08 H1210489X;
label value ERFSTL08 H1210490X;
label value ERFTCH08 H1210491X;
label value ERFTRI08 H1210492X;
label value ERFVA08 H1210493X;
label value ERFWCP08 H1210494X;
label value ERTEXP08 H1210495X;
label value ERTMCD08 H1210496X;
label value ERTMCR08 H1210497X;
label value ERTOFD08 H1210498X;
label value ERTOPR08 H1210499X;
label value ERTOPU08 H1210500X;
label value ERTOSR08 H1210501X;
label value ERTOT08 H1210502X;
label value ERTOTH08 H1210503X;
label value ERTPRV08 H1210504X;
label value ERTPTR08 H1210505X;
label value ERTSLF08 H1210506X;
label value ERTSTL08 H1210507X;
label value ERTTCH08 H1210508X;
label value ERTTRI08 H1210509X;
label value ERTVA08 H1210510X;
label value ERTWCP08 H1210511X;
label value EVRETIRE H1210512X;
label value EVRUNAT H1210513X;
label value EVRUNINS H1210514X;
label value EVRWRK H1210515X;
label value EXPLOP42 H1210516X;
label value EXRCIS53 H1210517X;
label value FAMRFPYR H1210518X;
label value FAMSZE31 H1210519X;
label value FAMSZE42 H1210520X;
label value FAMSZE53 H1210521X;
label value FAMWT08C H1210522X;
label value FAMWT08F H1210523X;
label value FCRP1231 H1210524X;
label value FILEDR08 H1210525X;
label value FILER08 H1210526X;
label value FLSTAT08 H1210527X;
label value FLUSHT53 H1210528X;
label value FMRS1231 H1210529X;
label value FNGRDF31 H1210530X;
label value FNGRDF53 H1210531X;
label value FOODMN08 H1210532X;
label value FOODST08 H1210533X;
label value FOODVL08 H1210534X;
label value FTSTU08X H1210535X;
label value FTSTU31X H1210536X;
label value FTSTU42X H1210537X;
label value FTSTU53X H1210538X;
label value GDCPBM42 H1210539X;
label value GDCPBT42 H1210540X;
label value GENDRP42 H1210541X;
label value GOTOUS42 H1210542X;
label value HAVEUS42 H1210543X;
label value HAVFUN42 H1210544X;
label value HEALTH42 H1210545X;
label value HEARAD42 H1210546X;
label value HEARDI42 H1210547X;
label value HEARMO42 H1210548X;
label value HEARNG42 H1210549X;
label value HEARSM42 H1210550X;
label value HELD31X H1210551X;
label value HELD42X H1210552X;
label value HELD53X H1210553X;
label value HELMET42 H1210554X;
label value HHAEXP08 H1210555X;
label value HHAGD08 H1210556X;
label value HHAMCD08 H1210557X;
label value HHAMCR08 H1210558X;
label value HHAOFD08 H1210559X;
label value HHAOPR08 H1210560X;
label value HHAOPU08 H1210561X;
label value HHAOSR08 H1210562X;
label value HHAOTH08 H1210563X;
label value HHAPRV08 H1210564X;
label value HHAPTR08 H1210565X;
label value HHASLF08 H1210566X;
label value HHASTL08 H1210567X;
label value HHATCH08 H1210568X;
label value HHATRI08 H1210569X;
label value HHAVA08 H1210570X;
label value HHAWCP08 H1210571X;
label value HHINDD08 H1210572X;
label value HHINFD08 H1210573X;
label value HHNEXP08 H1210574X;
label value HHNMCD08 H1210575X;
label value HHNMCR08 H1210576X;
label value HHNOFD08 H1210577X;
label value HHNOPR08 H1210578X;
label value HHNOPU08 H1210579X;
label value HHNOSR08 H1210580X;
label value HHNOTH08 H1210581X;
label value HHNPRV08 H1210582X;
label value HHNPTR08 H1210583X;
label value HHNSLF08 H1210584X;
label value HHNSTL08 H1210585X;
label value HHNTCH08 H1210586X;
label value HHNTRI08 H1210587X;
label value HHNVA08 H1210588X;
label value HHNWCP08 H1210589X;
label value HHTOTD08 H1210590X;
label value HIBPAGED H1210591X;
label value HIBPDX H1210592X;
label value HIDEG H1210593X;
label value HISPANX H1210594X;
label value HISPCAT H1210595X;
label value HLTHLF42 H1210596X;
label value HOMEBH42 H1210597X;
label value HONRDC31 H1210598X;
label value HONRDC42 H1210599X;
label value HONRDC53 H1210600X;
label value HOUR31 H1210601X;
label value HOUR42 H1210602X;
label value HOUR53 H1210603X;
label value HPDAP08 H1210604X;
label value HPDAU08 H1210605X;
label value HPDDE08 H1210606X;
label value HPDFE08 H1210607X;
label value HPDJA08 H1210608X;
label value HPDJL08 H1210609X;
label value HPDJU08 H1210610X;
label value HPDMA08 H1210611X;
label value HPDMY08 H1210612X;
label value HPDNO08 H1210613X;
label value HPDOC08 H1210614X;
label value HPDSE08 H1210615X;
label value HPEAP08 H1210616X;
label value HPEAU08 H1210617X;
label value HPEDE08 H1210618X;
label value HPEFE08 H1210619X;
label value HPEJA08 H1210620X;
label value HPEJL08 H1210621X;
label value HPEJU08 H1210622X;
label value HPEMA08 H1210623X;
label value HPEMY08 H1210624X;
label value HPENO08 H1210625X;
label value HPEOC08 H1210626X;
label value HPESE08 H1210627X;
label value HPNAP08 H1210628X;
label value HPNAU08 H1210629X;
label value HPNDE08 H1210630X;
label value HPNFE08 H1210631X;
label value HPNJA08 H1210632X;
label value HPNJL08 H1210633X;
label value HPNJU08 H1210634X;
label value HPNMA08 H1210635X;
label value HPNMY08 H1210636X;
label value HPNNO08 H1210637X;
label value HPNOC08 H1210638X;
label value HPNSE08 H1210639X;
label value HPOAP08 H1210640X;
label value HPOAU08 H1210641X;
label value HPODE08 H1210642X;
label value HPOFE08 H1210643X;
label value HPOJA08 H1210644X;
label value HPOJL08 H1210645X;
label value HPOJU08 H1210646X;
label value HPOMA08 H1210647X;
label value HPOMY08 H1210648X;
label value HPONO08 H1210649X;
label value HPOOC08 H1210650X;
label value HPOSE08 H1210651X;
label value HPRAP08 H1210652X;
label value HPRAU08 H1210653X;
label value HPRDE08 H1210654X;
label value HPRFE08 H1210655X;
label value HPRJA08 H1210656X;
label value HPRJL08 H1210657X;
label value HPRJU08 H1210658X;
label value HPRMA08 H1210659X;
label value HPRMY08 H1210660X;
label value HPRNO08 H1210661X;
label value HPROC08 H1210662X;
label value HPRSE08 H1210663X;
label value HPSAP08 H1210664X;
label value HPSAU08 H1210665X;
label value HPSDE08 H1210666X;
label value HPSFE08 H1210667X;
label value HPSJA08 H1210668X;
label value HPSJL08 H1210669X;
label value HPSJU08 H1210670X;
label value HPSMA08 H1210671X;
label value HPSMY08 H1210672X;
label value HPSNO08 H1210673X;
label value HPSOC08 H1210674X;
label value HPSSE08 H1210675X;
label value HRHOW31 H1210676X;
label value HRHOW42 H1210677X;
label value HRHOW53 H1210678X;
label value HRWG31X H1210679X;
label value HRWG42X H1210680X;
label value HRWG53X H1210681X;
label value HRWGIM31 H1210682X;
label value HRWGIM42 H1210683X;
label value HRWGIM53 H1210684X;
label value HSELIM31 H1210685X;
label value HSELIM53 H1210686X;
label value HSPLAP42 H1210687X;
label value HYSTER53 H1210688X;
label value IADL3M31 H1210689X;
label value IADL3M42 H1210690X;
label value IADL3M53 H1210691X;
label value IADLHP31 H1210692X;
label value IADLHP42 H1210693X;
label value IADLHP53 H1210694X;
label value INDCAT31 H1210695X;
label value INDCAT42 H1210696X;
label value INDCAT53 H1210697X;
label value INS08X H1210698X;
label value INS31X H1210699X;
label value INS42X H1210700X;
label value INS53X H1210701X;
label value INSAP08X H1210702X;
label value INSAT08X H1210703X;
label value INSAT31X H1210704X;
label value INSAT42X H1210705X;
label value INSAT53X H1210706X;
label value INSAU08X H1210707X;
label value INSC1231 H1210708X;
label value INSCOP08 H1210709X;
label value INSCOP31 H1210710X;
label value INSCOP42 H1210711X;
label value INSCOP53 H1210712X;
label value INSCOPE H1210713X;
label value INSCOV08 H1210714X;
label value INSDE08X H1210715X;
label value INSENDMM H1210716X;
label value INSENDYY H1210717X;
label value INSFE08X H1210718X;
label value INSJA08X H1210719X;
label value INSJL08X H1210720X;
label value INSJU08X H1210721X;
label value INSMA08X H1210722X;
label value INSMY08X H1210723X;
label value INSNO08X H1210724X;
label value INSOC08X H1210725X;
label value INSRPL42 H1210726X;
label value INSSE08X H1210727X;
label value INTIMP08 H1210728X;
label value INTRP08X H1210729X;
label value INTVLANG H1210730X;
label value IPDEXP08 H1210731X;
label value IPDIS08 H1210732X;
label value IPDMCD08 H1210733X;
label value IPDMCR08 H1210734X;
label value IPDOFD08 H1210735X;
label value IPDOPR08 H1210736X;
label value IPDOPU08 H1210737X;
label value IPDOSR08 H1210738X;
label value IPDOTH08 H1210739X;
label value IPDPRV08 H1210740X;
label value IPDPTR08 H1210741X;
label value IPDSLF08 H1210742X;
label value IPDSTL08 H1210743X;
label value IPDTCH08 H1210744X;
label value IPDTRI08 H1210745X;
label value IPDVA08 H1210746X;
label value IPDWCP08 H1210747X;
label value IPFEXP08 H1210748X;
label value IPFMCD08 H1210749X;
label value IPFMCR08 H1210750X;
label value IPFOFD08 H1210751X;
label value IPFOPR08 H1210752X;
label value IPFOPU08 H1210753X;
label value IPFOSR08 H1210754X;
label value IPFOTH08 H1210755X;
label value IPFPRV08 H1210756X;
label value IPFPTR08 H1210757X;
label value IPFSLF08 H1210758X;
label value IPFSTL08 H1210759X;
label value IPFTCH08 H1210760X;
label value IPFTRI08 H1210761X;
label value IPFVA08 H1210762X;
label value IPFWCP08 H1210763X;
label value IPNGTD08 H1210764X;
label value IPTEXP08 H1210765X;
label value IPTMCD08 H1210766X;
label value IPTMCR08 H1210767X;
label value IPTOFD08 H1210768X;
label value IPTOPR08 H1210769X;
label value IPTOPU08 H1210770X;
label value IPTOSR08 H1210771X;
label value IPTOTH08 H1210772X;
label value IPTPRV08 H1210773X;
label value IPTPTR08 H1210774X;
label value IPTSLF08 H1210775X;
label value IPTSTL08 H1210776X;
label value IPTTCH08 H1210777X;
label value IPTTRI08 H1210778X;
label value IPTVA08 H1210779X;
label value IPTWCP08 H1210780X;
label value IPZERO08 H1210781X;
label value IRAIMP08 H1210782X;
label value IRASP08X H1210783X;
label value JNTPID08 H1210784X;
label value JOBORG31 H1210785X;
label value JOBORG42 H1210786X;
label value JOBORG53 H1210787X;
label value JOBRSN42 H1210788X;
label value JTINRU08 H1210789X;
label value JTPAIN31 H1210790X;
label value JTPAIN53 H1210791X;
label value K6SUM42 H1210792X;
label value KEYNESS H1210793X;
label value KIDNAGED H1210794X;
label value KIDNREMS H1210795X;
label value KIDPRO42 H1210796X;
label value KNOWDR42 H1210797X;
label value LANGHM42 H1210798X;
label value LANGPR42 H1210799X;
label value LAPBLT42 H1210800X;
label value LEUKAGED H1210801X;
label value LEUKREMS H1210802X;
label value LFTDIF31 H1210803X;
label value LFTDIF53 H1210804X;
label value LIVRAGED H1210805X;
label value LIVRREMS H1210806X;
label value LKINFM42 H1210807X;
label value LKINFT42 H1210808X;
label value LOCATN42 H1210809X;
label value LRNXAGED H1210810X;
label value LRNXREMS H1210811X;
label value LSHLTH42 H1210812X;
label value LSTETH53 H1210813X;
label value LUNGAGED H1210814X;
label value LUNGREMS H1210815X;
label value LYMPAGED H1210816X;
label value LYMPREMS H1210817X;
label value MAMOGR53 H1210818X;
label value MARRY08X H1210819X;
label value MARRY31X H1210820X;
label value MARRY42X H1210821X;
label value MARRY53X H1210822X;
label value MCAID08 H1210823X;
label value MCAID08X H1210824X;
label value MCAID31 H1210825X;
label value MCAID31X H1210826X;
label value MCAID42 H1210827X;
label value MCAID42X H1210828X;
label value MCAID53 H1210829X;
label value MCAID53X H1210830X;
label value MCARE08 H1210831X;
label value MCARE08X H1210832X;
label value MCARE31 H1210833X;
label value MCARE31X H1210834X;
label value MCARE42 H1210835X;
label value MCARE42X H1210836X;
label value MCARE53 H1210837X;
label value MCARE53X H1210838X;
label value MCDAP08 H1210839X;
label value MCDAP08X H1210840X;
label value MCDAT08X H1210841X;
label value MCDAT31X H1210842X;
label value MCDAT42X H1210843X;
label value MCDAT53X H1210844X;
label value MCDAU08 H1210845X;
label value MCDAU08X H1210846X;
label value MCDDE08 H1210847X;
label value MCDDE08X H1210848X;
label value MCDEV08 H1210849X;
label value MCDFE08 H1210850X;
label value MCDFE08X H1210851X;
label value MCDHMO08 H1210852X;
label value MCDHMO31 H1210853X;
label value MCDHMO42 H1210854X;
label value MCDJA08 H1210855X;
label value MCDJA08X H1210856X;
label value MCDJL08 H1210857X;
label value MCDJL08X H1210858X;
label value MCDJU08 H1210859X;
label value MCDJU08X H1210860X;
label value MCDMA08 H1210861X;
label value MCDMA08X H1210862X;
label value MCDMC08 H1210863X;
label value MCDMC31 H1210864X;
label value MCDMC42 H1210865X;
label value MCDMY08 H1210866X;
label value MCDMY08X H1210867X;
label value MCDNO08 H1210868X;
label value MCDNO08X H1210869X;
label value MCDOC08 H1210870X;
label value MCDOC08X H1210871X;
label value MCDSE08 H1210872X;
label value MCDSE08X H1210873X;
label value MCRAP08 H1210874X;
label value MCRAP08X H1210875X;
label value MCRAU08 H1210876X;
label value MCRAU08X H1210877X;
label value MCRDE08 H1210878X;
label value MCRDE08X H1210879X;
label value MCREV08 H1210880X;
label value MCRFE08 H1210881X;
label value MCRFE08X H1210882X;
label value MCRJA08 H1210883X;
label value MCRJA08X H1210884X;
label value MCRJL08 H1210885X;
label value MCRJL08X H1210886X;
label value MCRJU08 H1210887X;
label value MCRJU08X H1210888X;
label value MCRMA08 H1210889X;
label value MCRMA08X H1210890X;
label value MCRMY08 H1210891X;
label value MCRMY08X H1210892X;
label value MCRNO08 H1210893X;
label value MCRNO08X H1210894X;
label value MCROC08 H1210895X;
label value MCROC08X H1210896X;
label value MCRPD08 H1210897X;
label value MCRPD08X H1210898X;
label value MCRPD31 H1210899X;
label value MCRPD31X H1210900X;
label value MCRPD42 H1210901X;
label value MCRPD42X H1210902X;
label value MCRPHO08 H1210903X;
label value MCRPHO31 H1210904X;
label value MCRPHO42 H1210905X;
label value MCRSE08 H1210906X;
label value MCRSE08X H1210907X;
label value MDDLAY42 H1210908X;
label value MDDLPR42 H1210909X;
label value MDDLRS42 H1210910X;
label value MDUNAB42 H1210911X;
label value MDUNPR42 H1210912X;
label value MDUNRS42 H1210913X;
label value MELAAGED H1210914X;
label value MELAREMS H1210915X;
label value MESBPR42 H1210916X;
label value MESHGT42 H1210917X;
label value MESVIS42 H1210918X;
label value MESWGT42 H1210919X;
label value MIAGED H1210920X;
label value MIDX H1210921X;
label value MILDIF31 H1210922X;
label value MILDIF53 H1210923X;
label value MINORP42 H1210924X;
label value MNHLTH31 H1210925X;
label value MNHLTH42 H1210926X;
label value MNHLTH53 H1210927X;
label value MOMPRO42 H1210928X;
label value MORE31 H1210929X;
label value MORE42 H1210930X;
label value MORE53 H1210931X;
label value MORECOVR H1210932X;
label value MORJOB31 H1210933X;
label value MORJOB42 H1210934X;
label value MORJOB53 H1210935X;
label value MOUTAGED H1210936X;
label value MOUTREMS H1210937X;
label value MSA08 H1210938X;
label value MSA31 H1210939X;
label value MSA42 H1210940X;
label value MSA53 H1210941X;
label value MUSCAGED H1210942X;
label value MUSCREMS H1210943X;
label value MYSELF42 H1210944X;
label value NATAMP42 H1210945X;
label value NERVAF42 H1210946X;
label value NEVILL42 H1210947X;
label value NEWARE42 H1210948X;
label value NEWDOC42 H1210949X;
label value NHRWG31 H1210950X;
label value NHRWG42 H1210951X;
label value NHRWG53 H1210952X;
label value NOASPR53 H1210953X;
label value NOFAT53 H1210954X;
label value NOGODR42 H1210955X;
label value NOINSBEF H1210956X;
label value NOINSTM H1210957X;
label value NOINUNIT H1210958X;
label value NOLIKE42 H1210959X;
label value NOREAS42 H1210960X;
label value NOSMOK42 H1210961X;
label value NUMEMP31 H1210962X;
label value NUMEMP42 H1210963X;
label value NUMEMP53 H1210964X;
label value NWK31 H1210965X;
label value NWK42 H1210966X;
label value NWK53 H1210967X;
label value OBAEXP08 H1210968X;
label value OBAMCD08 H1210969X;
label value OBAMCR08 H1210970X;
label value OBAOFD08 H1210971X;
label value OBAOPR08 H1210972X;
label value OBAOPU08 H1210973X;
label value OBAOSR08 H1210974X;
label value OBAOTH08 H1210975X;
label value OBAPRV08 H1210976X;
label value OBAPTR08 H1210977X;
label value OBASLF08 H1210978X;
label value OBASST08 H1210979X;
label value OBASTL08 H1210980X;
label value OBATCH08 H1210981X;
label value OBATRI08 H1210982X;
label value OBAVA08 H1210983X;
label value OBAWCP08 H1210984X;
label value OBCEXP08 H1210985X;
label value OBCHIR08 H1210986X;
label value OBCMCD08 H1210987X;
label value OBCMCR08 H1210988X;
label value OBCOFD08 H1210989X;
label value OBCOPR08 H1210990X;
label value OBCOPU08 H1210991X;
label value OBCOSR08 H1210992X;
label value OBCOTH08 H1210993X;
label value OBCPRV08 H1210994X;
label value OBCPTR08 H1210995X;
label value OBCSLF08 H1210996X;
label value OBCSTL08 H1210997X;
label value OBCTCH08 H1210998X;
label value OBCTRI08 H1210999X;
label value OBCVA08 H1211000X;
label value OBCWCP08 H1211001X;
label value OBDEXP08 H1211002X;
label value OBDMCD08 H1211003X;
label value OBDMCR08 H1211004X;
label value OBDOFD08 H1211005X;
label value OBDOPR08 H1211006X;
label value OBDOPU08 H1211007X;
label value OBDOSR08 H1211008X;
label value OBDOTH08 H1211009X;
label value OBDPRV08 H1211010X;
label value OBDPTR08 H1211011X;
label value OBDRV08 H1211012X;
label value OBDSLF08 H1211013X;
label value OBDSTL08 H1211014X;
label value OBDTCH08 H1211015X;
label value OBDTRI08 H1211016X;
label value OBDVA08 H1211017X;
label value OBDWCP08 H1211018X;
label value OBEEXP08 H1211019X;
label value OBEMCD08 H1211020X;
label value OBEMCR08 H1211021X;
label value OBEOFD08 H1211022X;
label value OBEOPR08 H1211023X;
label value OBEOPU08 H1211024X;
label value OBEOSR08 H1211025X;
label value OBEOTH08 H1211026X;
label value OBEPRV08 H1211027X;
label value OBEPTR08 H1211028X;
label value OBESLF08 H1211029X;
label value OBESTL08 H1211030X;
label value OBETCH08 H1211031X;
label value OBETRI08 H1211032X;
label value OBEVA08 H1211033X;
label value OBEWCP08 H1211034X;
label value OBNEXP08 H1211035X;
label value OBNMCD08 H1211036X;
label value OBNMCR08 H1211037X;
label value OBNOFD08 H1211038X;
label value OBNOPR08 H1211039X;
label value OBNOPU08 H1211040X;
label value OBNOSR08 H1211041X;
label value OBNOTH08 H1211042X;
label value OBNPRV08 H1211043X;
label value OBNPTR08 H1211044X;
label value OBNSLF08 H1211045X;
label value OBNSTL08 H1211046X;
label value OBNTCH08 H1211047X;
label value OBNTRI08 H1211048X;
label value OBNURS08 H1211049X;
label value OBNVA08 H1211050X;
label value OBNWCP08 H1211051X;
label value OBOEXP08 H1211052X;
label value OBOMCD08 H1211053X;
label value OBOMCR08 H1211054X;
label value OBOOFD08 H1211055X;
label value OBOOPR08 H1211056X;
label value OBOOPU08 H1211057X;
label value OBOOSR08 H1211058X;
label value OBOOTH08 H1211059X;
label value OBOPRV08 H1211060X;
label value OBOPTO08 H1211061X;
label value OBOPTR08 H1211062X;
label value OBOSLF08 H1211063X;
label value OBOSTL08 H1211064X;
label value OBOTCH08 H1211065X;
label value OBOTHV08 H1211066X;
label value OBOTRI08 H1211067X;
label value OBOVA08 H1211068X;
label value OBOWCP08 H1211069X;
label value OBTEXP08 H1211070X;
label value OBTHER08 H1211071X;
label value OBTMCD08 H1211072X;
label value OBTMCR08 H1211073X;
label value OBTOFD08 H1211074X;
label value OBTOPR08 H1211075X;
label value OBTOPU08 H1211076X;
label value OBTOSR08 H1211077X;
label value OBTOTH08 H1211078X;
label value OBTOTV08 H1211079X;
label value OBTPRV08 H1211080X;
label value OBTPTR08 H1211081X;
label value OBTSLF08 H1211082X;
label value OBTSTL08 H1211083X;
label value OBTTCH08 H1211084X;
label value OBTTRI08 H1211085X;
label value OBTVA08 H1211086X;
label value OBTWCP08 H1211087X;
label value OBVEXP08 H1211088X;
label value OBVMCD08 H1211089X;
label value OBVMCR08 H1211090X;
label value OBVOFD08 H1211091X;
label value OBVOPR08 H1211092X;
label value OBVOPU08 H1211093X;
label value OBVOSR08 H1211094X;
label value OBVOTH08 H1211095X;
label value OBVPRV08 H1211096X;
label value OBVPTR08 H1211097X;
label value OBVSLF08 H1211098X;
label value OBVSTL08 H1211099X;
label value OBVTCH08 H1211100X;
label value OBVTRI08 H1211101X;
label value OBVVA08 H1211102X;
label value OBVWCP08 H1211103X;
label value OCCCAT31 H1211104X;
label value OCCCAT42 H1211105X;
label value OCCCAT53 H1211106X;
label value OFFER31X H1211107X;
label value OFFER42X H1211108X;
label value OFFER53X H1211109X;
label value OFFHOU42 H1211110X;
label value OFREMP31 H1211111X;
label value OFREMP42 H1211112X;
label value OFREMP53 H1211113X;
label value OHRTAGED H1211114X;
label value OHRTDX H1211115X;
label value ONGONG42 H1211116X;
label value ONJOB42 H1211117X;
label value OPAAP08 H1211118X;
label value OPAAU08 H1211119X;
label value OPADE08 H1211120X;
label value OPAEV08 H1211121X;
label value OPAFE08 H1211122X;
label value OPAJA08 H1211123X;
label value OPAJL08 H1211124X;
label value OPAJU08 H1211125X;
label value OPAMA08 H1211126X;
label value OPAMY08 H1211127X;
label value OPANO08 H1211128X;
label value OPAOC08 H1211129X;
label value OPASE08 H1211130X;
label value OPBAP08 H1211131X;
label value OPBAU08 H1211132X;
label value OPBDE08 H1211133X;
label value OPBEV08 H1211134X;
label value OPBFE08 H1211135X;
label value OPBJA08 H1211136X;
label value OPBJL08 H1211137X;
label value OPBJU08 H1211138X;
label value OPBMA08 H1211139X;
label value OPBMY08 H1211140X;
label value OPBNO08 H1211141X;
label value OPBOC08 H1211142X;
label value OPBSE08 H1211143X;
label value OPDEXP08 H1211144X;
label value OPDMCD08 H1211145X;
label value OPDMCR08 H1211146X;
label value OPDOFD08 H1211147X;
label value OPDOPR08 H1211148X;
label value OPDOPU08 H1211149X;
label value OPDOSR08 H1211150X;
label value OPDOTH08 H1211151X;
label value OPDPRV08 H1211152X;
label value OPDPTR08 H1211153X;
label value OPDRV08 H1211154X;
label value OPDSLF08 H1211155X;
label value OPDSTL08 H1211156X;
label value OPDTCH08 H1211157X;
label value OPDTRI08 H1211158X;
label value OPDVA08 H1211159X;
label value OPDWCP08 H1211160X;
label value OPFEXP08 H1211161X;
label value OPFMCD08 H1211162X;
label value OPFMCR08 H1211163X;
label value OPFOFD08 H1211164X;
label value OPFOPR08 H1211165X;
label value OPFOPU08 H1211166X;
label value OPFOSR08 H1211167X;
label value OPFOTH08 H1211168X;
label value OPFPRV08 H1211169X;
label value OPFPTR08 H1211170X;
label value OPFSLF08 H1211171X;
label value OPFSTL08 H1211172X;
label value OPFTCH08 H1211173X;
label value OPFTRI08 H1211174X;
label value OPFVA08 H1211175X;
label value OPFWCP08 H1211176X;
label value OPOEXP08 H1211177X;
label value OPOMCD08 H1211178X;
label value OPOMCR08 H1211179X;
label value OPOOFD08 H1211180X;
label value OPOOPR08 H1211181X;
label value OPOOPU08 H1211182X;
label value OPOOSR08 H1211183X;
label value OPOOTH08 H1211184X;
label value OPOPRV08 H1211185X;
label value OPOPTR08 H1211186X;
label value OPOSLF08 H1211187X;
label value OPOSTL08 H1211188X;
label value OPOTCH08 H1211189X;
label value OPOTHV08 H1211190X;
label value OPOTRI08 H1211191X;
label value OPOVA08 H1211192X;
label value OPOWCP08 H1211193X;
label value OPPEXP08 H1211194X;
label value OPPMCD08 H1211195X;
label value OPPMCR08 H1211196X;
label value OPPOFD08 H1211197X;
label value OPPOPR08 H1211198X;
label value OPPOPU08 H1211199X;
label value OPPOSR08 H1211200X;
label value OPPOTH08 H1211201X;
label value OPPPRV08 H1211202X;
label value OPPPTR08 H1211203X;
label value OPPSLF08 H1211204X;
label value OPPSTL08 H1211205X;
label value OPPTCH08 H1211206X;
label value OPPTRI08 H1211207X;
label value OPPVA08 H1211208X;
label value OPPWCP08 H1211209X;
label value OPSEXP08 H1211210X;
label value OPSMCD08 H1211211X;
label value OPSMCR08 H1211212X;
label value OPSOFD08 H1211213X;
label value OPSOPR08 H1211214X;
label value OPSOPU08 H1211215X;
label value OPSOSR08 H1211216X;
label value OPSOTH08 H1211217X;
label value OPSPRV08 H1211218X;
label value OPSPTR08 H1211219X;
label value OPSSLF08 H1211220X;
label value OPSSTL08 H1211221X;
label value OPSTCH08 H1211222X;
label value OPSTRI08 H1211223X;
label value OPSVA08 H1211224X;
label value OPSWCP08 H1211225X;
label value OPTEXP08 H1211226X;
label value OPTMCD08 H1211227X;
label value OPTMCR08 H1211228X;
label value OPTOFD08 H1211229X;
label value OPTOPR08 H1211230X;
label value OPTOPU08 H1211231X;
label value OPTOSR08 H1211232X;
label value OPTOTH08 H1211233X;
label value OPTOTV08 H1211234X;
label value OPTPRV08 H1211235X;
label value OPTPTR08 H1211236X;
label value OPTSLF08 H1211237X;
label value OPTSTL08 H1211238X;
label value OPTTCH08 H1211239X;
label value OPTTRI08 H1211240X;
label value OPTVA08 H1211241X;
label value OPTWCP08 H1211242X;
label value OPVEXP08 H1211243X;
label value OPVMCD08 H1211244X;
label value OPVMCR08 H1211245X;
label value OPVOFD08 H1211246X;
label value OPVOPR08 H1211247X;
label value OPVOPU08 H1211248X;
label value OPVOSR08 H1211249X;
label value OPVOTH08 H1211250X;
label value OPVPRV08 H1211251X;
label value OPVPTR08 H1211252X;
label value OPVSLF08 H1211253X;
label value OPVSTL08 H1211254X;
label value OPVTCH08 H1211255X;
label value OPVTRI08 H1211256X;
label value OPVVA08 H1211257X;
label value OPVWCP08 H1211258X;
label value OTHDYS31 H1211259X;
label value OTHDYS42 H1211260X;
label value OTHDYS53 H1211261X;
label value OTHEXP08 H1211262X;
label value OTHIMP08 H1211263X;
label value OTHINS42 H1211264X;
label value OTHMCD08 H1211265X;
label value OTHMCR08 H1211266X;
label value OTHNDD31 H1211267X;
label value OTHNDD42 H1211268X;
label value OTHNDD53 H1211269X;
label value OTHOFD08 H1211270X;
label value OTHOPR08 H1211271X;
label value OTHOPU08 H1211272X;
label value OTHOSR08 H1211273X;
label value OTHOTH08 H1211274X;
label value OTHPRV08 H1211275X;
label value OTHPTR08 H1211276X;
label value OTHRAGED H1211277X;
label value OTHRCP42 H1211278X;
label value OTHREA42 H1211279X;
label value OTHRP08X H1211280X;
label value OTHRREMS H1211281X;
label value OTHSLF08 H1211282X;
label value OTHSTL08 H1211283X;
label value OTHTCH08 H1211284X;
label value OTHTRI08 H1211285X;
label value OTHVA08 H1211286X;
label value OTHWCP08 H1211287X;
label value OTPAAT08 H1211288X;
label value OTPAAT31 H1211289X;
label value OTPAAT42 H1211290X;
label value OTPAAT53 H1211291X;
label value OTPBAT08 H1211292X;
label value OTPBAT31 H1211293X;
label value OTPBAT42 H1211294X;
label value OTPBAT53 H1211295X;
label value OTPUBA08 H1211296X;
label value OTPUBA31 H1211297X;
label value OTPUBA42 H1211298X;
label value OTPUBA53 H1211299X;
label value OTPUBB08 H1211300X;
label value OTPUBB31 H1211301X;
label value OTPUBB42 H1211302X;
label value OTPUBB53 H1211303X;
label value OVRYAGED H1211304X;
label value OVRYREMS H1211305X;
label value PACISP42 H1211306X;
label value PANCAGED H1211307X;
label value PANCREMS H1211308X;
label value PANEL H1211309X;
label value PAPSMR53 H1211310X;
label value PAYDR31 H1211311X;
label value PAYDR42 H1211312X;
label value PAYDR53 H1211313X;
label value PAYVAC31 H1211314X;
label value PAYVAC42 H1211315X;
label value PAYVAC53 H1211316X;
label value PBINFM42 H1211317X;
label value PBINFT42 H1211318X;
label value PBPWKM42 H1211319X;
label value PBPWKT42 H1211320X;
label value PBSVCM42 H1211321X;
label value PBSVCT42 H1211322X;
label value PDKAP08 H1211323X;
label value PDKAU08 H1211324X;
label value PDKDE08 H1211325X;
label value PDKFE08 H1211326X;
label value PDKJA08 H1211327X;
label value PDKJL08 H1211328X;
label value PDKJU08 H1211329X;
label value PDKMA08 H1211330X;
label value PDKMY08 H1211331X;
label value PDKNO08 H1211332X;
label value PDKOC08 H1211333X;
label value PDKSE08 H1211334X;
label value PEGAP08 H1211335X;
label value PEGAU08 H1211336X;
label value PEGDE08 H1211337X;
label value PEGFE08 H1211338X;
label value PEGJA08 H1211339X;
label value PEGJL08 H1211340X;
label value PEGJU08 H1211341X;
label value PEGMA08 H1211342X;
label value PEGMY08 H1211343X;
label value PEGNO08 H1211344X;
label value PEGOC08 H1211345X;
label value PEGSE08 H1211346X;
label value PENIMP08 H1211347X;
label value PENSP08X H1211348X;
label value PERSLA42 H1211349X;
label value PERWT08F H1211350X;
label value PHMONP08 H1211351X;
label value PHMONP31 H1211352X;
label value PHMONP42 H1211353X;
label value PHNREG42 H1211354X;
label value PHQ242 H1211355X;
label value PHYACT53 H1211356X;
label value PHYSCL42 H1211357X;
label value PLCTYP42 H1211358X;
label value PMDINS08 H1211359X;
label value PMDINS31 H1211360X;
label value PMDLAY42 H1211361X;
label value PMDLPR42 H1211362X;
label value PMDLRS42 H1211363X;
label value PMEDIN31 H1211364X;
label value PMEDIN42 H1211365X;
label value PMEDIN53 H1211366X;
label value PMEDOP31 H1211367X;
label value PMEDOP42 H1211368X;
label value PMEDOP53 H1211369X;
label value PMEDPY31 H1211370X;
label value PMEDPY42 H1211371X;
label value PMEDPY53 H1211372X;
label value PMEDUP31 H1211373X;
label value PMEDUP42 H1211374X;
label value PMEDUP53 H1211375X;
label value PMNCNP08 H1211376X;
label value PMNCNP31 H1211377X;
label value PMNCNP42 H1211378X;
label value PMUNAB42 H1211379X;
label value PMUNPR42 H1211380X;
label value PMUNRS42 H1211381X;
label value PNGAP08 H1211382X;
label value PNGAU08 H1211383X;
label value PNGDE08 H1211384X;
label value PNGFE08 H1211385X;
label value PNGJA08 H1211386X;
label value PNGJL08 H1211387X;
label value PNGJU08 H1211388X;
label value PNGMA08 H1211389X;
label value PNGMY08 H1211390X;
label value PNGNO08 H1211391X;
label value PNGOC08 H1211392X;
label value PNGSE08 H1211393X;
label value POGAP08 H1211394X;
label value POGAU08 H1211395X;
label value POGDE08 H1211396X;
label value POGFE08 H1211397X;
label value POGJA08 H1211398X;
label value POGJL08 H1211399X;
label value POGJU08 H1211400X;
label value POGMA08 H1211401X;
label value POGMY08 H1211402X;
label value POGNO08 H1211403X;
label value POGOC08 H1211404X;
label value POGSE08 H1211405X;
label value POUAP08 H1211406X;
label value POUAU08 H1211407X;
label value POUDE08 H1211408X;
label value POUFE08 H1211409X;
label value POUJA08 H1211410X;
label value POUJL08 H1211411X;
label value POUJU08 H1211412X;
label value POUMA08 H1211413X;
label value POUMY08 H1211414X;
label value POUNO08 H1211415X;
label value POUOC08 H1211416X;
label value POUSE08 H1211417X;
label value POVCAT08 H1211418X;
label value PPRWKM42 H1211419X;
label value PPRWKT42 H1211420X;
label value PRDRNP08 H1211421X;
label value PRDRNP31 H1211422X;
label value PRDRNP42 H1211423X;
label value PREGNT31 H1211424X;
label value PREGNT42 H1211425X;
label value PREGNT53 H1211426X;
label value PREVCOVR H1211427X;
label value PREVEN42 H1211428X;
label value PRIAP08 H1211429X;
label value PRIAU08 H1211430X;
label value PRIDE08 H1211431X;
label value PRIDK08 H1211432X;
label value PRIDK31 H1211433X;
label value PRIDK42 H1211434X;
label value PRIDK53 H1211435X;
label value PRIEU08 H1211436X;
label value PRIEU31 H1211437X;
label value PRIEU42 H1211438X;
label value PRIEU53 H1211439X;
label value PRIFE08 H1211440X;
label value PRIJA08 H1211441X;
label value PRIJL08 H1211442X;
label value PRIJU08 H1211443X;
label value PRIMA08 H1211444X;
label value PRIMY08 H1211445X;
label value PRING08 H1211446X;
label value PRING31 H1211447X;
label value PRING42 H1211448X;
label value PRING53 H1211449X;
label value PRINO08 H1211450X;
label value PRIOC08 H1211451X;
label value PRIOG08 H1211452X;
label value PRIOG31 H1211453X;
label value PRIOG42 H1211454X;
label value PRIOG53 H1211455X;
label value PRIS08 H1211456X;
label value PRIS31 H1211457X;
label value PRIS42 H1211458X;
label value PRIS53 H1211459X;
label value PRISE08 H1211460X;
label value PRIV08 H1211461X;
label value PRIV31 H1211462X;
label value PRIV42 H1211463X;
label value PRIV53 H1211464X;
label value PRIVAT08 H1211465X;
label value PRIVAT31 H1211466X;
label value PRIVAT42 H1211467X;
label value PRIVAT53 H1211468X;
label value PROUT08 H1211469X;
label value PROUT31 H1211470X;
label value PROUT42 H1211471X;
label value PROUT53 H1211472X;
label value PROVTY42 H1211473X;
label value PROXY08 H1211474X;
label value PROXY31 H1211475X;
label value PROXY42 H1211476X;
label value PROXY53 H1211477X;
label value PRSAP08 H1211478X;
label value PRSAU08 H1211479X;
label value PRSDE08 H1211480X;
label value PRSFE08 H1211481X;
label value PRSJA08 H1211482X;
label value PRSJL08 H1211483X;
label value PRSJU08 H1211484X;
label value PRSMA08 H1211485X;
label value PRSMY08 H1211486X;
label value PRSNO08 H1211487X;
label value PRSOC08 H1211488X;
label value PRSSE08 H1211489X;
label value PRSTAGED H1211490X;
label value PRSTREMS H1211491X;
label value PRVDRL08 H1211492X;
label value PRVDRL31 H1211493X;
label value PRVDRL42 H1211494X;
label value PRVEV08 H1211495X;
label value PRVHMO08 H1211496X;
label value PRVHMO31 H1211497X;
label value PRVHMO42 H1211498X;
label value PRVMNC08 H1211499X;
label value PRVMNC31 H1211500X;
label value PRVMNC42 H1211501X;
label value PSA53 H1211502X;
label value PSTATS31 H1211503X;
label value PSTATS42 H1211504X;
label value PSTATS53 H1211505X;
label value PUB08X H1211506X;
label value PUB31X H1211507X;
label value PUB42X H1211508X;
label value PUB53X H1211509X;
label value PUBAP08X H1211510X;
label value PUBAT08X H1211511X;
label value PUBAT31X H1211512X;
label value PUBAT42X H1211513X;
label value PUBAT53X H1211514X;
label value PUBAU08X H1211515X;
label value PUBDE08X H1211516X;
label value PUBFE08X H1211517X;
label value PUBIMP08 H1211518X;
label value PUBJA08X H1211519X;
label value PUBJL08X H1211520X;
label value PUBJU08X H1211521X;
label value PUBMA08X H1211522X;
label value PUBMY08X H1211523X;
label value PUBNO08X H1211524X;
label value PUBOC08X H1211525X;
label value PUBP08X H1211526X;
label value PUBSE08X H1211527X;
label value RACEAX H1211528X;
label value RACEBX H1211529X;
label value RACETHNX H1211530X;
label value RACEWX H1211531X;
label value RACEX H1211532X;
label value RCHDIF31 H1211533X;
label value RCHDIF53 H1211534X;
label value READNW42 H1211535X;
label value RECPEP42 H1211536X;
label value RECTAGED H1211537X;
label value RECTREMS H1211538X;
label value REFDP08X H1211539X;
label value REFFRL42 H1211540X;
label value REFIMP08 H1211541X;
label value REGION08 H1211542X;
label value REGION31 H1211543X;
label value REGION42 H1211544X;
label value REGION53 H1211545X;
label value RESP08 H1211546X;
label value RESP31 H1211547X;
label value RESP42 H1211548X;
label value RESP53 H1211549X;
label value RESPCT42 H1211550X;
label value RETPLN31 H1211551X;
label value RETPLN42 H1211552X;
label value RETPLN53 H1211553X;
label value RFREL08X H1211554X;
label value RFREL31X H1211555X;
label value RFREL42X H1211556X;
label value RFREL53X H1211557X;
label value RNDFLG31 H1211558X;
label value RTHLTH31 H1211559X;
label value RTHLTH42 H1211560X;
label value RTHLTH53 H1211561X;
label value RTPLNM42 H1211562X;
label value RTPLNT42 H1211563X;
label value RUCLAS08 H1211564X;
label value RUCLAS31 H1211565X;
label value RUCLAS42 H1211566X;
label value RUCLAS53 H1211567X;
label value RUSIZE08 H1211568X;
label value RUSIZE31 H1211569X;
label value RUSIZE42 H1211570X;
label value RUSIZE53 H1211571X;
label value RXEXP08 H1211572X;
label value RXMCD08 H1211573X;
label value RXMCR08 H1211574X;
label value RXOFD08 H1211575X;
label value RXOPR08 H1211576X;
label value RXOPU08 H1211577X;
label value RXOSR08 H1211578X;
label value RXOTH08 H1211579X;
label value RXPRV08 H1211580X;
label value RXPTR08 H1211581X;
label value RXSLF08 H1211582X;
label value RXSTL08 H1211583X;
label value RXTOT08 H1211584X;
label value RXTRI08 H1211585X;
label value RXVA08 H1211586X;
label value RXWCP08 H1211587X;
label value SAFEST42 H1211588X;
label value SALIMP08 H1211589X;
label value SAQELIG H1211590X;
label value SAQWT08F H1211591X;
label value SCHLBH42 H1211592X;
label value SCHLIM31 H1211593X;
label value SCHLIM53 H1211594X;
label value SCHPRO42 H1211595X;
label value SCLNBD31 H1211596X;
label value SCLNBD42 H1211597X;
label value SCLNBD53 H1211598X;
label value SEATBE53 H1211599X;
label value SEEDIF42 H1211600X;
label value SELDSI42 H1211601X;
label value SELFCM31 H1211602X;
label value SELFCM42 H1211603X;
label value SELFCM53 H1211604X;
label value SEX H1211605X;
label value SFFLAG42 H1211606X;
label value SIBPRO42 H1211607X;
label value SICEAS42 H1211608X;
label value SICPAY31 H1211609X;
label value SICPAY42 H1211610X;
label value SICPAY53 H1211611X;
label value SKDKAGED H1211612X;
label value SKDKREMS H1211613X;
label value SKNMAGED H1211614X;
label value SKNMREMS H1211615X;
label value SOCLIM31 H1211616X;
label value SOCLIM53 H1211617X;
label value SPOUID08 H1211618X;
label value SPOUID31 H1211619X;
label value SPOUID42 H1211620X;
label value SPOUID53 H1211621X;
label value SPOUIN08 H1211622X;
label value SPOUIN31 H1211623X;
label value SPOUIN42 H1211624X;
label value SPOUIN53 H1211625X;
label value SPRPRO42 H1211626X;
label value SSCIMP08 H1211627X;
label value SSECP08X H1211628X;
label value SSIDIS08 H1211629X;
label value SSIIMP08 H1211630X;
label value SSIP08X H1211631X;
label value SSNLJB31 H1211632X;
label value SSNLJB42 H1211633X;
label value SSNLJB53 H1211634X;
label value STAAP08 H1211635X;
label value STAAU08 H1211636X;
label value STADE08 H1211637X;
label value STAFE08 H1211638X;
label value STAJA08 H1211639X;
label value STAJL08 H1211640X;
label value STAJU08 H1211641X;
label value STAMA08 H1211642X;
label value STAMY08 H1211643X;
label value STANO08 H1211644X;
label value STAOC08 H1211645X;
label value STAPR08 H1211646X;
label value STAPR31 H1211647X;
label value STAPR42 H1211648X;
label value STAPR53 H1211649X;
label value STASE08 H1211650X;
label value STJBDD31 H1211651X;
label value STJBDD42 H1211652X;
label value STJBDD53 H1211653X;
label value STJBMM31 H1211654X;
label value STJBMM42 H1211655X;
label value STJBMM53 H1211656X;
label value STJBYY31 H1211657X;
label value STJBYY42 H1211658X;
label value STJBYY53 H1211659X;
label value STNDIF31 H1211660X;
label value STNDIF53 H1211661X;
label value STOMAGED H1211662X;
label value STOMCH53 H1211663X;
label value STOMREMS H1211664X;
label value STOOL53 H1211665X;
label value STPDIF31 H1211666X;
label value STPDIF53 H1211667X;
label value STPRAT08 H1211668X;
label value STPRAT31 H1211669X;
label value STPRAT42 H1211670X;
label value STPRAT53 H1211671X;
label value STRKAGED H1211672X;
label value STRKDX H1211673X;
label value TAXFRM08 H1211674X;
label value TEMPJB31 H1211675X;
label value TEMPJB42 H1211676X;
label value TEMPJB53 H1211677X;
label value THRTAGED H1211678X;
label value THRTREMS H1211679X;
label value THYRAGED H1211680X;
label value THYRREMS H1211681X;
label value TIMALN42 H1211682X;
label value TMTKUS42 H1211683X;
label value TOTDED08 H1211684X;
label value TOTEXP08 H1211685X;
label value TOTMCD08 H1211686X;
label value TOTMCR08 H1211687X;
label value TOTOFD08 H1211688X;
label value TOTOPR08 H1211689X;
label value TOTOPU08 H1211690X;
label value TOTOSR08 H1211691X;
label value TOTOTH08 H1211692X;
label value TOTPRV08 H1211693X;
label value TOTPTR08 H1211694X;
label value TOTSLF08 H1211695X;
label value TOTSTL08 H1211696X;
label value TOTTCH08 H1211697X;
label value TOTTRI08 H1211698X;
label value TOTVA08 H1211699X;
label value TOTWCP08 H1211700X;
label value TRANS42 H1211701X;
label value TRBLE42 H1211702X;
label value TREATM42 H1211703X;
label value TRIAP08X H1211704X;
label value TRIAT08X H1211705X;
label value TRIAT31X H1211706X;
label value TRIAT42X H1211707X;
label value TRIAT53X H1211708X;
label value TRIAU08X H1211709X;
label value TRICH08X H1211710X;
label value TRICH31X H1211711X;
label value TRICH42X H1211712X;
label value TRICR08X H1211713X;
label value TRICR31X H1211714X;
label value TRICR42X H1211715X;
label value TRICR53X H1211716X;
label value TRIDE08X H1211717X;
label value TRIEV08 H1211718X;
label value TRIEX08X H1211719X;
label value TRIEX31X H1211720X;
label value TRIEX42X H1211721X;
label value TRIFE08X H1211722X;
label value TRIJA08X H1211723X;
label value TRIJL08X H1211724X;
label value TRIJU08X H1211725X;
label value TRILI08X H1211726X;
label value TRILI31X H1211727X;
label value TRILI42X H1211728X;
label value TRIMA08X H1211729X;
label value TRIMY08X H1211730X;
label value TRINO08X H1211731X;
label value TRIOC08X H1211732X;
label value TRIPR08X H1211733X;
label value TRIPR31X H1211734X;
label value TRIPR42X H1211735X;
label value TRISE08X H1211736X;
label value TRIST08X H1211737X;
label value TRIST31X H1211738X;
label value TRIST42X H1211739X;
label value TRTIMP08 H1211740X;
label value TSTSAGED H1211741X;
label value TSTSREMS H1211742X;
label value TYPEPE42 H1211743X;
label value UNABLE31 H1211744X;
label value UNABLE53 H1211745X;
label value UNEIMP08 H1211746X;
label value UNEMP08X H1211747X;
label value UNHAP42 H1211748X;
label value UNINS08 H1211749X;
label value UNION31 H1211750X;
label value UNION42 H1211751X;
label value UNION53 H1211752X;
label value USBORN42 H1211753X;
label value USCNOT42 H1211754X;
label value USLIVE42 H1211755X;
label value UTERAGED H1211756X;
label value UTERREMS H1211757X;
label value VETIMP08 H1211758X;
label value VETSP08X H1211759X;
label value VISEXP08 H1211760X;
label value VISION42 H1211761X;
label value VISMCD08 H1211762X;
label value VISMCR08 H1211763X;
label value VISOFD08 H1211764X;
label value VISOPR08 H1211765X;
label value VISOPU08 H1211766X;
label value VISOSR08 H1211767X;
label value VISOTH08 H1211768X;
label value VISPRV08 H1211769X;
label value VISPTR08 H1211770X;
label value VISSLF08 H1211771X;
label value VISSTL08 H1211772X;
label value VISTCH08 H1211773X;
label value VISTRI08 H1211774X;
label value VISVA08 H1211775X;
label value VISWCP08 H1211776X;
label value WAGEP08X H1211777X;
label value WAGIMP08 H1211778X;
label value WASAFDC H1211779X;
label value WASCHAMP H1211780X;
label value WASESTB H1211781X;
label value WASMCAID H1211782X;
label value WASMCARE H1211783X;
label value WASOTGOV H1211784X;
label value WASOTHER H1211785X;
label value WASPRIV H1211786X;
label value WASSSI H1211787X;
label value WASSTAT1 H1211788X;
label value WASSTAT2 H1211789X;
label value WASSTAT3 H1211790X;
label value WASSTAT4 H1211791X;
label value WASVA H1211792X;
label value WCMPP08X H1211793X;
label value WCPIMP08 H1211794X;
label value WHENST53 H1211795X;
label value WHITPR42 H1211796X;
label value WHNBPR42 H1211797X;
label value WHNBST42 H1211798X;
label value WHNBWL53 H1211799X;
label value WHNDEN42 H1211800X;
label value WHNEAT42 H1211801X;
label value WHNHEL42 H1211802X;
label value WHNHGT42 H1211803X;
label value WHNLAP42 H1211804X;
label value WHNPHY42 H1211805X;
label value WHNSAF42 H1211806X;
label value WHNSMK42 H1211807X;
label value WHNWGT42 H1211808X;
label value WILFIL08 H1211809X;
label value WKINBD31 H1211810X;
label value WKINBD42 H1211811X;
label value WKINBD53 H1211812X;
label value WLK3MO31 H1211813X;
label value WLK3MO53 H1211814X;
label value WLKDIF31 H1211815X;
label value WLKDIF53 H1211816X;
label value WLKLIM31 H1211817X;
label value WLKLIM53 H1211818X;
label value WRGLAS42 H1211819X;
label value WRHLTH42 H1211820X;
label value WRKLIM31 H1211821X;
label value WRKLIM53 H1211822X;
label value YCHJ3142 H1211823X;
label value YCHJ4253 H1211824X;
label value YNOINS31 H1211825X;
label value YNOINS42 H1211826X;
label value YNOINS53 H1211827X;
label value YNOUSC42 H1211828X;
label value ZIDEXP08 H1211829X;
label value ZIDMCD08 H1211830X;
label value ZIDMCR08 H1211831X;
label value ZIDOFD08 H1211832X;
label value ZIDOPR08 H1211833X;
label value ZIDOPU08 H1211834X;
label value ZIDOSR08 H1211835X;
label value ZIDOTH08 H1211836X;
label value ZIDPRV08 H1211837X;
label value ZIDPTR08 H1211838X;
label value ZIDSLF08 H1211839X;
label value ZIDSTL08 H1211840X;
label value ZIDTCH08 H1211841X;
label value ZIDTRI08 H1211842X;
label value ZIDVA08 H1211843X;
label value ZIDWCP08 H1211844X;
label value ZIFEXP08 H1211845X;
label value ZIFMCD08 H1211846X;
label value ZIFMCR08 H1211847X;
label value ZIFOFD08 H1211848X;
label value ZIFOPR08 H1211849X;
label value ZIFOPU08 H1211850X;
label value ZIFOSR08 H1211851X;
label value ZIFOTH08 H1211852X;
label value ZIFPRV08 H1211853X;
label value ZIFPTR08 H1211854X;
label value ZIFSLF08 H1211855X;
label value ZIFSTL08 H1211856X;
label value ZIFTCH08 H1211857X;
label value ZIFTRI08 H1211858X;
label value ZIFVA08 H1211859X;
label value ZIFWCP08 H1211860X;

*DISPLAY A DESCRIPTION OF STATA FILE;
describe;

*LIST FIRST 20 OBSERVATIONS IN THE FILE;
list in 1/20;


#delimit cr


/************************************************************************************************
 NOTES:                                                                                          
                                                                                                 
 1. This program has been tested on Stata Version 10 (for Windows).                              
                                                                                                 
 2. This program will create a permanent Stata dataset.  All additional analyses                 
    can be run using this dataset.  In addition to the dataset, this program creates             
    a log file named H121.LOG and a data file named H121.DTA.  If these files (H121.DTA and H121.LOG)
    already exist in the working directory, they will be replaced when this program is executed. 
                                                                                                 
 3. If the program ends prematurely, the log file will remain open.  Before running this         
    program again, the user should enter the following Stata command: log close                  
                                                                                                 
 4. The cd command assigns C:\MEPS\DATA as the working directory and location of the input       
    ASCII and output .DTA and .LOG files and can be modified by the user as necessary.           
                                                                                                 
 5. Stata commands end with a carriage return by default. The command                            
    #delimit ;                                                                                   
    temporarily changes the command ending delimiter from a carriage return to a semicolon.      
                                                                                                 
 6. The infix command assumes that the input variables are numeric unless the variable name      
    is prefaced by str.  For example, DUPERSID is the a string (or character) variable.          
                                                                                                 
************************************************************************************************/

